/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.Parser;

public class PosixParser
extends Parser {
    private ArrayList tokens = new ArrayList();
    private boolean eatTheRest;
    private Option currentOption;
    private Options options;

    private void init() {
        this.eatTheRest = false;
        this.tokens.clear();
        this.currentOption = null;
    }

    @Override
    protected String[] flatten(Options options, String[] arguments2, boolean stopAtNonOption) {
        this.init();
        this.options = options;
        Iterator<String> iter = Arrays.asList(arguments2).iterator();
        String token2 = null;
        while (iter.hasNext()) {
            token2 = iter.next();
            if (token2.startsWith("--")) {
                this.processLongOptionToken(token2, stopAtNonOption);
            } else if ("-".equals(token2)) {
                this.processSingleHyphen(token2);
            } else if (token2.startsWith("-")) {
                int tokenLength = token2.length();
                if (tokenLength == 2) {
                    this.processOptionToken(token2, stopAtNonOption);
                } else {
                    String longOptionCandidate;
                    boolean burst = true;
                    if (token2.length() > 2 && this.options.hasOption(longOptionCandidate = "-" + token2)) {
                        this.tokens.add(token2);
                        burst = false;
                    }
                    if (burst) {
                        this.burstToken(token2, stopAtNonOption);
                    }
                }
            } else if (stopAtNonOption) {
                this.process(token2);
            } else {
                this.tokens.add(token2);
            }
            this.gobble(iter);
        }
        return this.tokens.toArray(new String[0]);
    }

    private void gobble(Iterator iter) {
        if (this.eatTheRest) {
            while (iter.hasNext()) {
                this.tokens.add(iter.next());
            }
        }
    }

    private void process(String value) {
        if (this.currentOption != null && this.currentOption.hasArg()) {
            if (this.currentOption.hasArg()) {
                this.tokens.add(value);
                this.currentOption = null;
            } else if (this.currentOption.hasArgs()) {
                this.tokens.add(value);
            }
        } else {
            this.eatTheRest = true;
            this.tokens.add("--");
            this.tokens.add(value);
        }
    }

    private void processSingleHyphen(String hyphen) {
        this.tokens.add(hyphen);
    }

    private void processOptionToken(String token2, boolean stopAtNonOption) {
        if (this.options.hasOption(token2)) {
            this.currentOption = this.options.getOption(token2);
            this.tokens.add(token2);
        } else if (stopAtNonOption) {
            this.eatTheRest = true;
        } else {
            this.tokens.add(token2);
        }
    }

    private void processLongOptionToken(String longToken, boolean stopAtNonOption) {
        String token2;
        String value = null;
        if (longToken.indexOf(61) != -1) {
            token2 = longToken.substring(0, longToken.indexOf(61));
            value = longToken.substring(longToken.indexOf(61) + 1, longToken.length());
        } else {
            token2 = longToken;
        }
        if (this.options.hasOption(token2)) {
            this.tokens.add(token2);
            if (value != null) {
                this.tokens.add(value);
            }
        } else if (stopAtNonOption) {
            this.eatTheRest = true;
        } else {
            this.tokens.add(token2);
            if (value != null) {
                this.tokens.add(value);
            }
        }
    }

    protected void burstToken(String token2, boolean stopAtNonOption) {
        int tokenLength = token2.length();
        for (int i = 1; i < tokenLength; ++i) {
            String ch = String.valueOf(token2.charAt(i));
            boolean hasOption = this.options.hasOption(ch);
            if (hasOption) {
                this.tokens.add("-" + ch);
                this.currentOption = this.options.getOption(ch);
                if (!this.currentOption.hasArg() || token2.length() == i + 1) continue;
                this.tokens.add(token2.substring(i + 1));
                break;
            }
            if (stopAtNonOption) {
                this.process(token2.substring(i));
                continue;
            }
            this.tokens.add("-" + ch);
        }
    }
}

