/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class CharacterJavaType
extends AbstractClassJavaType<Character>
implements PrimitiveJavaType<Character> {
    public static final CharacterJavaType INSTANCE = new CharacterJavaType();

    public CharacterJavaType() {
        super(Character.class);
    }

    @Override
    public String toString(Character value) {
        return value.toString();
    }

    @Override
    public Character fromString(CharSequence string) {
        if (string.length() != 1) {
            throw new HibernateException("multiple or zero characters found parsing string");
        }
        return Character.valueOf(string.charAt(0));
    }

    @Override
    public <X> X unwrap(Character value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Character.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        if (Number.class.isAssignableFrom(type)) {
            return (X)Short.valueOf((short)value.charValue());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Character wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof String) {
            if (value.equals("")) {
                return Character.valueOf(' ');
            }
            String str = (String)value;
            return Character.valueOf(str.charAt(0));
        }
        if (value instanceof Number) {
            Number nbr = (Number)value;
            return Character.valueOf((char)nbr.shortValue());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public Class getPrimitiveClass() {
        return Character.TYPE;
    }

    @Override
    public Class<Character[]> getArrayClass() {
        return Character[].class;
    }

    @Override
    public Class<?> getPrimitiveArrayClass() {
        return char[].class;
    }

    @Override
    public Character getDefaultValue() {
        return Character.valueOf('\u0000');
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return 1L;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return 3;
    }

    @Override
    public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return 0;
    }
}

