/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.function.ToIntFunction;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;

public class BloomFilter<E> {
    private final int bitsToUse;
    private final IntSet intSet;
    private final Iterable<ToIntFunction<? super E>> hashFunctions;

    BloomFilter(int bitsToUse, IntSet intSet, Iterable<ToIntFunction<? super E>> hashFunctions) {
        this.bitsToUse = bitsToUse;
        this.intSet = intSet;
        this.hashFunctions = hashFunctions;
    }

    public static <E> BloomFilter<E> createFilter(int bitsToUse, Iterable<ToIntFunction<? super E>> hashFunctions) {
        return new BloomFilter<E>(bitsToUse, IntSets.mutableEmptySet(bitsToUse), hashFunctions);
    }

    public static <E> BloomFilter<E> createConcurrentFilter(int bitsToUse, Iterable<ToIntFunction<? super E>> hashFunctions) {
        return new BloomFilter<E>(bitsToUse, IntSets.concurrentSet(bitsToUse), hashFunctions);
    }

    public boolean addToFilter(E value) {
        boolean setABit = false;
        for (ToIntFunction<E> function : this.hashFunctions) {
            int hashResult = Math.abs(function.applyAsInt(value));
            int bitToCheck = hashResult % this.bitsToUse;
            setABit |= this.intSet.add(bitToCheck);
        }
        return setABit;
    }

    public boolean possiblyPresent(E value) {
        for (ToIntFunction<E> function : this.hashFunctions) {
            int hashResult = Math.abs(function.applyAsInt(value));
            int bitToCheck = hashResult % this.bitsToUse;
            if (this.intSet.contains(bitToCheck)) continue;
            return false;
        }
        return true;
    }

    public void setBits(IntSet intSet) {
        this.intSet.clear();
        this.intSet.addAll(intSet);
    }

    public IntSet getIntSet() {
        return IntSets.immutableSet(this.intSet);
    }

    public String toString() {
        return "BloomFilter{bitsToUse=" + this.bitsToUse + ", intSet=" + this.intSet + "}";
    }
}

