/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.io.Output;
import java.io.DataOutput;
import java.io.IOException;

public class KryoDataOutput
implements DataOutput,
AutoCloseable {
    protected Output output;

    public KryoDataOutput(Output output) {
        this.output = output;
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    @Override
    public void write(int b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.output.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.output.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.output.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.output.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.output.writeChar((char)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.output.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.output.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.output.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.output.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.output.write((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.output.write(v & 0xFF);
            this.output.write(v >>> 8 & 0xFF);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.output.writeString(s);
    }

    @Override
    public void close() throws Exception {
        this.output.close();
    }
}

