/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import io.reactivex.rxjava3.core.Flowable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.infinispan.commons.util.IntSet;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.util.logging.LogFactory;

public class TemporaryTable {
    private static final Log log = LogFactory.getLog(TemporaryTable.class, Log.class);
    private final AtomicReferenceArray<ConcurrentMap<Object, Entry>> table;

    public TemporaryTable(int numSegments) {
        this.table = new AtomicReferenceArray(numSegments);
    }

    public int getSegmentMax() {
        return this.table.length();
    }

    public void addSegments(IntSet segments) {
        segments.forEach(segment -> this.table.compareAndSet(segment, null, new ConcurrentHashMap()));
    }

    public void removeSegments(IntSet segments) {
        segments.forEach(segment -> this.table.set(segment, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(int segment, Object key, int file, int offset) {
        block10: {
            Entry entry;
            ConcurrentMap<Object, Entry> map = this.table.get(segment);
            if (map == null) {
                log.tracef("Table did not have segment %s", segment);
                return false;
            }
            while ((entry = map.putIfAbsent(key, new Entry(file, offset, false))) != null) {
                Entry entry2 = entry;
                synchronized (entry2) {
                    if (entry.isRemoved()) {
                        continue;
                    }
                    if (entry.isLocked()) {
                        try {
                            if (log.isTraceEnabled()) {
                                log.tracef("Waiting for lock on %s", key);
                            }
                            entry.wait();
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IllegalStateException("Unexpected interruption!", e);
                        }
                    }
                    log.tracef("Updated key to %s:%s", file, offset);
                    entry.update(file, offset);
                    break block10;
                }
            }
            log.tracef("Set key to %s:%s", file, offset);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockedEntry replaceOrLock(int segment, Object key, int file, int offset, int prevFile, int prevOffset) {
        Entry lockedEntry;
        Entry entry;
        ConcurrentMap<Object, Entry> map = this.table.get(segment);
        if (map == null) {
            log.tracef("Table did not have segment %s", segment);
            return null;
        }
        while ((entry = map.putIfAbsent(key, lockedEntry = new Entry(-1, -1, true))) != null) {
            Entry entry2 = entry;
            synchronized (entry2) {
                if (entry.isRemoved()) {
                    continue;
                }
                if (entry.isLocked()) {
                    throw new IllegalStateException("Unexpected double locking");
                }
                if (entry.getFile() == prevFile && entry.getOffset() == prevOffset) {
                    log.tracef("Updated entry for key %s to %s:%s from %s:%s", new Object[]{key, file, offset, prevFile, prevOffset});
                    entry.update(file, offset);
                } else {
                    log.tracef("Did not update entry for key %s as %s:%s does not match %s:%s", new Object[]{key, prevFile, prevOffset, entry.getFile(), entry.getOffset()});
                }
                return null;
            }
        }
        log.tracef("Locked entry for key %s", key);
        return lockedEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAndUnlock(LockedEntry lockedEntry, int file, int offset) {
        Entry entry;
        Entry entry2 = entry = (Entry)lockedEntry;
        synchronized (entry2) {
            log.tracef("Updating entry to %s:%s from %s:%s", new Object[]{file, offset, entry.file, entry.offset});
            entry.file = file;
            entry.offset = offset;
            entry.locked = false;
            entry.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndUnlock(LockedEntry lockedEntry, int segment, Object key) {
        Entry entry;
        Entry entry2 = entry = (Entry)lockedEntry;
        synchronized (entry2) {
            ConcurrentMap<Object, Entry> map = this.table.get(segment);
            if (map != null) {
                Entry removedEntry = (Entry)map.remove(key);
                assert (removedEntry == entry) : "Removed entry " + removedEntry + " for key which didn't match " + lockedEntry;
                log.tracef("Removed and unlocking entry %s", entry);
            } else {
                log.tracef("Table did not have segment %s", segment);
            }
            entry.setRemoved(true);
            entry.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPosition get(int segment, Object key) {
        ConcurrentMap<Object, Entry> map = this.table.get(segment);
        if (map == null) {
            log.tracef("Table did not have segment %s", segment);
            return null;
        }
        Entry entry = (Entry)map.get(key);
        if (entry == null) {
            log.tracef("Key %s not present in temporary table", key);
            return null;
        }
        Entry entry2 = entry;
        synchronized (entry2) {
            if (entry.isLocked()) {
                log.tracef("Key %s was present in temporary table with %s:%s, but locked", key, entry.getFile(), entry.getOffset());
                return null;
            }
            log.tracef("Key %s was present in temporary table with %s:%s", key, entry.getFile(), entry.getOffset());
            return new EntryPosition(entry.getFile(), entry.getOffset());
        }
    }

    public void clear() {
        log.tracef("Clearing TemporaryTable", new Object[0]);
        for (int i = 0; i < this.table.length(); ++i) {
            ConcurrentMap<Object, Entry> map = this.table.get(i);
            if (map == null) continue;
            map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConditionally(int segment, Object key, int file, int offset) {
        ConcurrentMap<Object, Entry> map = this.table.get(segment);
        if (map == null) {
            log.tracef("Table did not have segment %s", segment);
            return;
        }
        Entry tempEntry = (Entry)map.get(key);
        if (tempEntry != null) {
            Entry entry = tempEntry;
            synchronized (entry) {
                if (tempEntry.isLocked()) {
                    log.tracef("Key %s was present in temporary table with %s:%s, but locked", key, tempEntry.getFile(), tempEntry.getOffset());
                    return;
                }
                if (tempEntry.getFile() == file && tempEntry.getOffset() == offset) {
                    log.tracef("Removed Key %s was present in temporary table with %s:%s", key, file, offset);
                    map.remove(key, tempEntry);
                    tempEntry.setRemoved(true);
                } else {
                    log.tracef("Key %s was present in temporary table with %s:%s, which doesn't match %s:%s", new Object[]{key, tempEntry.getFile(), tempEntry.getOffset(), file, offset});
                }
            }
        } else {
            log.tracef("Table did contain key %s", key);
        }
    }

    <K, V> Flowable<Map.Entry<Object, EntryPosition>> publish(IntSet segments) {
        return Flowable.fromIterable((Iterable)segments).flatMap(segment -> {
            ConcurrentMap<Object, Entry> map = this.table.get((int)segment);
            if (map == null) {
                return Flowable.empty();
            }
            return Flowable.fromIterable(map.entrySet()).filter(entry -> !((Entry)entry.getValue()).isLocked()).map(entry -> new AbstractMap.SimpleImmutableEntry(entry.getKey(), new EntryPosition(((Entry)entry.getValue()).getFile(), ((Entry)entry.getValue()).getOffset())));
        });
    }

    private static class Entry
    extends LockedEntry {
        private int file;
        private int offset;
        private boolean locked;
        private boolean removed = false;

        Entry(int file, int offset, boolean locked) {
            this.file = file;
            this.offset = offset;
            this.locked = locked;
        }

        public int getFile() {
            return this.file;
        }

        public int getOffset() {
            return this.offset;
        }

        public void update(int currentFile, int currentOffset) {
            this.file = currentFile;
            this.offset = currentOffset;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void setRemoved(boolean removed) {
            this.removed = removed;
        }

        public boolean isLocked() {
            return this.locked;
        }
    }

    public static abstract class LockedEntry {
        private LockedEntry() {
        }
    }
}

