/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.UndoRedoSupport;
import javax.swing.SwingUtilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public final class UndoSupport<E> {
    private UndoManager undoManager;
    private UndoRedoSupport undoRedoSupport;
    private UndoRedoSupport.Listener undoSupportHandler = new UndoSupportHandler();
    private FunctionList.Function<UndoRedoSupport.Edit, UndoableEdit> editAdapter;

    private UndoSupport(UndoManager undoManager, EventList<E> source, FunctionList.Function<UndoRedoSupport.Edit, UndoableEdit> editAdapter) {
        this.undoManager = undoManager;
        this.undoRedoSupport = UndoRedoSupport.install(source);
        this.editAdapter = editAdapter;
        this.undoRedoSupport.addUndoSupportListener(this.undoSupportHandler);
    }

    public static <E> UndoSupport install(UndoManager undoManager, EventList<E> source) {
        return UndoSupport.install(undoManager, source, new DefaultEditAdapter());
    }

    public static <E> UndoSupport install(UndoManager undoManager, EventList<E> source, FunctionList.Function<UndoRedoSupport.Edit, UndoableEdit> editAdapter) {
        UndoSupport.checkAccessThread();
        return new UndoSupport<E>(undoManager, source, editAdapter);
    }

    public void uninstall() {
        UndoSupport.checkAccessThread();
        this.undoRedoSupport.removeUndoSupportListener(this.undoSupportHandler);
        this.undoRedoSupport.uninstall();
        this.undoSupportHandler = null;
        this.undoRedoSupport = null;
        this.undoManager = null;
        this.editAdapter = null;
    }

    private static void checkAccessThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("UndoRedoSupport must be accessed from the Swing Event Dispatch Thread, but was called on Thread \"" + Thread.currentThread().getName() + "\"");
        }
    }

    private static class DefaultEditAdapter
    implements FunctionList.Function<UndoRedoSupport.Edit, UndoableEdit> {
        private DefaultEditAdapter() {
        }

        @Override
        public UndoableEdit evaluate(UndoRedoSupport.Edit edit) {
            return new EditAdapter(edit);
        }

        private static class EditAdapter
        extends AbstractUndoableEdit {
            private final UndoRedoSupport.Edit edit;

            public EditAdapter(UndoRedoSupport.Edit edit) {
                this.edit = edit;
            }

            @Override
            public void undo() {
                this.edit.undo();
            }

            @Override
            public boolean canUndo() {
                return this.edit.canUndo();
            }

            @Override
            public void redo() {
                this.edit.redo();
            }

            @Override
            public boolean canRedo() {
                return this.edit.canRedo();
            }
        }
    }

    private class UndoSupportHandler
    implements UndoRedoSupport.Listener {
        private UndoSupportHandler() {
        }

        @Override
        public void undoableEditHappened(UndoRedoSupport.Edit edit) {
            UndoSupport.this.undoManager.addEdit((UndoableEdit)UndoSupport.this.editAdapter.evaluate(edit));
        }
    }
}

