/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.util.Arrays;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.CpuInfo;
import org.hyperic.sigar.cmd.Free;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.cmd.Ulimit;
import org.hyperic.sigar.cmd.Uptime;
import org.hyperic.sigar.cmd.Version;

public class SysInfo
extends SigarCommandBase {
    public SysInfo(Shell shell) {
        super(shell);
    }

    public SysInfo() {
    }

    public String getUsageShort() {
        return "Display system information";
    }

    public void output(String[] args) throws SigarException {
        Version.printInfo(this.out);
        this.println("");
        new Uptime(this.shell).output(args);
        this.println("");
        CpuInfo cpuinfo = new CpuInfo(this.shell);
        cpuinfo.displayTimes = false;
        cpuinfo.output(args);
        this.println("");
        new Free(this.shell).output(args);
        this.println("");
        this.println("File Systems........." + Arrays.asList(this.sigar.getFileSystemList()));
        this.println("");
        this.println("Network Interfaces..." + Arrays.asList(this.sigar.getNetInterfaceList()));
        this.println("");
        this.println("System resource limits:");
        new Ulimit(this.shell).output(args);
    }

    public static void main(String[] args) throws Exception {
        new SysInfo().processCommand(args);
    }
}

