/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service;

import com.xebialabs.deployit.core.rest.exception.StitchException;
import com.xebialabs.deployit.plugin.stitch.configuration.git.GitAuthenticationStrategies$;
import com.xebialabs.deployit.plugin.stitch.configuration.git.GitUserCredentials;
import com.xebialabs.deployit.plugin.stitch.configuration.git.OpenSSHConfigBootstrapper$;
import com.xebialabs.deployit.plugin.stitch.model.ci.GitSource;
import com.xebialabs.deployit.plugin.stitch.service.GitOpsService;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.RepositoryCrawler;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.dto.GitSourceInfo;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005\t-c\u0001\u0002\f\u0018\u0001\u0011BQa\u000e\u0001\u0005\u0002aBQA\u000f\u0001\u0005\nmBQ!\u0015\u0001\u0005\nICQ!\u0016\u0001\u0005BYCQ!\u001f\u0001\u0005\niDq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002\"\u0001!\t%a\t\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u00111\u000b\u0001\u0005B\u0005U\u0003bBA/\u0001\u0011%\u0011q\f\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\t\u0019\u0007\u0001C!\u0003{Bq!!\"\u0001\t\u0013\t9\tC\u0004\u0002\u001a\u0002!\t%a'\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\"9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0007bBAi\u0001\u0011\u0005\u00131\u001b\u0005\b\u0003C\u0004A\u0011IAr\u0011\u001d\ti\u000f\u0001C\u0005\u0003_DqA!\u0004\u0001\t\u0013\u0011y\u0001C\u0004\u0003\u001a\u0001!\tEa\u0007\u0003#\u001dKGo\u00149t'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u00193\u000591/\u001a:wS\u000e,'B\u0001\u000e\u001c\u0003\u0019\u0019H/\u001b;dQ*\u0011A$H\u0001\u0007a2,x-\u001b8\u000b\u0005yy\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005\u0001\n\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005\u0011\u0013aA2p[\u000e\u00011\u0003\u0002\u0001&W=\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u0017.\u001b\u00059\u0012B\u0001\u0018\u0018\u000559\u0015\u000e^(qgN+'O^5dKB\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\u0006g24GG\u001b\u0006\u0002i\u0005AqM]5{u2,G-\u0003\u00027c\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001:!\ta\u0003!A\tsKN|GN^3NC&t'I]1oG\"$\"\u0001P$\u0011\u0005u\"eB\u0001 C!\tyt%D\u0001A\u0015\t\t5%\u0001\u0004=e>|GOP\u0005\u0003\u0007\u001e\na\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111i\n\u0005\u0006\u0011\n\u0001\r!S\u0001\u0007g>,(oY3\u0011\u0005){U\"A&\u000b\u00051k\u0015AA2j\u0015\tq\u0015$A\u0003n_\u0012,G.\u0003\u0002Q\u0017\nIq)\u001b;T_V\u00148-Z\u0001\u0018e\u0016\u001cx\u000e\u001c<f\u001fJLw-\u001b8Ce\u0006t7\r\u001b(b[\u0016$\"\u0001P*\t\u000bQ\u001b\u0001\u0019\u0001\u001f\u0002\t9\fW.Z\u0001\u0013G2|g.Z$jiJ+\u0007o\\:ji>\u0014\u0018\u0010F\u0002X]b\u0004RA\n-[MrJ!!W\u0014\u0003\rQ+\b\u000f\\34!\tYF-D\u0001]\u0015\tif,A\u0002ba&T!a\u00181\u0002\t)<\u0017\u000e\u001e\u0006\u0003C\n\fq!Z2mSB\u001cXMC\u0001d\u0003\ry'oZ\u0005\u0003Kr\u00131aR5u!\t9G.D\u0001i\u0015\tI'.\u0001\u0002j_*\t1.\u0001\u0003kCZ\f\u0017BA7i\u0005\u00111\u0015\u000e\\3\t\u000b=$\u0001\u0019\u00019\u0002\u0017\r\u0014X\rZ3oi&\fGn\u001d\t\u0003cZl\u0011A\u001d\u0006\u0003gR\f1aZ5u\u0015\t)\u0018$A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0003oJ\u0014!cR5u+N,'o\u0011:fI\u0016tG/[1mg\")\u0001\n\u0002a\u0001\u0013\u0006Q2\r\\8oK\u001eKGOU3q_NLGo\u001c:z)\u0016l\u0007\u000f\\1uKR!qk\u001f?\u007f\u0011\u0015AU\u00011\u0001J\u0011\u0015iX\u00011\u0001=\u0003\u0019\u0011'/\u00198dQ\"1q0\u0002a\u0001\u0003\u0003\t\u0011A\u001a\t\bM\u0005\r\u0011q\u00014[\u0013\r\t)a\n\u0002\n\rVt7\r^5p]J\u0002B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0003gS2,'bAA\tU\u0006\u0019a.[8\n\t\u0005U\u00111\u0002\u0002\u0005!\u0006$\b.\u0001\rdY>tWmR5u%\u0016\u0004xn]5u_JL(I]1oG\"$raVA\u000e\u0003;\ty\u0002C\u0003p\r\u0001\u0007\u0001\u000fC\u0003I\r\u0001\u0007\u0011\nC\u0003~\r\u0001\u0007A(A\u000edY>tWmR5u%\u0016\u0004xn]5u_JL\u0018I\u001c3Ce\u0006t7\r\u001b\u000b\b/\u0006\u0015\u0012qEA\u0015\u0011\u0015yw\u00011\u0001q\u0011\u0015Au\u00011\u0001J\u0011\u0015ix\u00011\u0001=\u0003\u001d\u0019G.Z1okB$B!a\f\u00026A\u0019a%!\r\n\u0007\u0005MrE\u0001\u0003V]&$\bbBA\u001c\u0011\u0001\u0007\u0011\u0011H\u0001\ne\u0016\u001cx.\u001e:dKN\u0004D!a\u000f\u0002BA1a\u0005\u0017.\u0002>\u0019\u0004B!a\u0010\u0002B1\u0001A\u0001DA\"\u0003k\t\t\u0011!A\u0003\u0002\u0005\u0015#aA0%cE!\u0011qIA'!\r1\u0013\u0011J\u0005\u0004\u0003\u0017:#a\u0002(pi\"Lgn\u001a\t\u0004M\u0005=\u0013bAA)O\t\u0019\u0011I\\=\u0002\u000b\rdW-\u00198\u0015\r\u0005=\u0012qKA-\u0011\u0015\u0019\u0018\u00021\u0001[\u0011\u0019\tY&\u0003a\u0001M\u00061am\u001c7eKJ\f\u0011\u0003Z3mKR,'+Z2veNLg/\u001a7z)\u0011\ty#!\u0019\t\r\u00055!\u00021\u0001g\u0003]9W\r^$jiN{WO]2f\u0005J\fgn\u00195OC6,7\u000f\u0006\u0004\u0002h\u0005e\u00141\u0010\t\u0006\u0003S\n\u0019\b\u0010\b\u0005\u0003W\nyGD\u0002@\u0003[J\u0011\u0001K\u0005\u0004\u0003c:\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003k\n9H\u0001\u0003MSN$(bAA9O!)qn\u0003a\u0001a\")\u0001j\u0003a\u0001\u0013R1\u0011qMA@\u0003\u0003CQa\u001c\u0007A\u0002ADa!a!\r\u0001\u0004a\u0014aA;sY\u0006AB.[:u\u000f&$8k\\;sG\u0016\u0014%/\u00198dQ:\u000bW.Z:\u0015\t\u0005\u001d\u0014\u0011\u0012\u0005\b\u0003\u0017k\u0001\u0019AAG\u00031a\u0017n\u001d;Ce\u0006t7\r[3t!\u001d1\u0013qRA\u0004\u0003'K1!!%(\u0005%1UO\\2uS>t\u0017\u0007E\u0002\\\u0003+K1!a&]\u0005=a5OU3n_R,7i\\7nC:$\u0017\u0001E4fi\u001eKGoU8ve\u000e,\u0017J\u001c4p)\u0019\ti*!-\u00024B!\u0011qTAW\u001b\t\t\tK\u0003\u0003\u0002$\u0006\u0015\u0016a\u00013u_*!\u0011qUAU\u0003\u0015Ig\u000eZ3y\u0015\r\tYkF\u0001\u0007K:<\u0017N\\3\n\t\u0005=\u0016\u0011\u0015\u0002\u000e\u000f&$8k\\;sG\u0016LeNZ8\t\u000but\u0001\u0019\u0001\u001f\t\r\u0005Uf\u00021\u0001g\u0003=awnY1m%\u0016\u0004xNR8mI\u0016\u0014\u0018!D:bm\u0016\fe\u000eZ\"p[6LG\u000f\u0006\u0006\u00020\u0005m\u0016QXA`\u0003\u0003DQa\\\bA\u0002ADQ\u0001S\bA\u0002%CQa]\bA\u0002iCa!a1\u0010\u0001\u0004a\u0014!C2p[6LG/T:h\u0003\u0019\u0019w.\\7jiRQ\u0011qFAe\u0003\u0017\fi-a4\t\u000b=\u0004\u0002\u0019\u00019\t\u000b!\u0003\u0002\u0019A%\t\u000bM\u0004\u0002\u0019\u0001.\t\r\u0005\r\u0007\u00031\u0001=\u00031\u0011'/\u00198dQ\u0016C\u0018n\u001d;t)!\t).a7\u0002^\u0006}\u0007c\u0001\u0014\u0002X&\u0019\u0011\u0011\\\u0014\u0003\u000f\t{w\u000e\\3b]\")q.\u0005a\u0001a\")\u0001*\u0005a\u0001\u0013\")Q0\u0005a\u0001y\u0005YQ.\u001a:hK\n\u0013\u0018M\\2i)!\ty#!:\u0002h\u0006%\b\"B8\u0013\u0001\u0004\u0001\b\"\u0002%\u0013\u0001\u0004I\u0005BBAv%\u0001\u0007A(\u0001\u0006ce\u0006t7\r\u001b(b[\u0016\fq\u0001Z8NKJ<W\r\u0006\u0005\u0002r\u0006]\u0018\u0011 B\u0005!\rY\u00161_\u0005\u0004\u0003kd&aC'fe\u001e,'+Z:vYRDQa]\nA\u0002iCq!a?\u0014\u0001\u0004\ti0\u0001\bce\u0006t7\r[(cU\u0016\u001cG/\u00133\u0011\t\u0005}(QA\u0007\u0003\u0005\u0003Q1Aa\u0001_\u0003\ra\u0017NY\u0005\u0005\u0005\u000f\u0011\tA\u0001\u0005PE*,7\r^%e\u0011\u0019\u0011Ya\u0005a\u0001y\u00059Q.Z:tC\u001e,\u0017\u0001\u00065b]\u0012dW-T3sO\u0016\u001cuN\u001c4mS\u000e$8\u000f\u0006\u0005\u00020\tE!1\u0003B\u000b\u0011\u0015AE\u00031\u0001J\u0011\u0019\tY\u000f\u0006a\u0001y!9!q\u0003\u000bA\u0002\u0005E\u0018aC7fe\u001e,'+Z:vYR\fA\u0002Z3mKR,'I]1oG\"$\u0002\"a\f\u0003\u001e\t}!\u0011\u0005\u0005\u0006_V\u0001\r\u0001\u001d\u0005\u0006\u0011V\u0001\r!\u0013\u0005\u0007\u0003W,\u0002\u0019\u0001\u001f)\u0007\u0001\u0011)\u0003\u0005\u0003\u0003(\teRB\u0001B\u0015\u0015\u0011\u0011YC!\f\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u00030\tE\u0012a\u00024bGR|'/\u001f\u0006\u0005\u0005g\u0011)$A\u0003cK\u0006t7OC\u0002\u00038\t\fqb\u001d9sS:<gM]1nK^|'o[\u0005\u0005\u0005w\u0011ICA\u0005BkR|w/\u001b:fI\"\u001a\u0001Aa\u0010\u0011\t\t\u0005#qI\u0007\u0003\u0005\u0007RAA!\u0012\u00036\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\t%#1\t\u0002\b'\u0016\u0014h/[2f\u0001")
public class GitOpsServiceImpl
implements GitOpsService,
Logging {
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private String DefaultBranch;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Tuple3<Git, File, String> cloneGitRepository(GitSource source) {
        return GitOpsService.cloneGitRepository$(this, source);
    }

    @Override
    public Tuple3<Git, File, String> cloneGitRepositoryBranch(GitSource source, String branchName) {
        return GitOpsService.cloneGitRepositoryBranch$(this, source, branchName);
    }

    @Override
    public Tuple3<Git, File, String> cloneGitRepositoryAndBranch(GitSource source, String branch) {
        return GitOpsService.cloneGitRepositoryAndBranch$(this, source, branch);
    }

    @Override
    public List<String> getGitSourceBranchNames(GitSource source) {
        return GitOpsService.getGitSourceBranchNames$(this, source);
    }

    @Override
    public void deleteBranch(GitSource source, String branchName) {
        GitOpsService.deleteBranch$(this, source, branchName);
    }

    @Override
    public boolean branchExists(GitSource source, String branch) {
        return GitOpsService.branchExists$(this, source, branch);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        GitOpsServiceImpl gitOpsServiceImpl = this;
        synchronized (gitOpsServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public String DefaultBranch() {
        return this.DefaultBranch;
    }

    @Override
    public void com$xebialabs$deployit$plugin$stitch$service$GitOpsService$_setter_$DefaultBranch_$eq(String x$1) {
        this.DefaultBranch = x$1;
    }

    private String resolveMainBranch(GitSource source) {
        return (String)Option$.MODULE$.apply((Object)Repository.normalizeBranchName((String)source.masterBranchName())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1)))).getOrElse((Function0 & Serializable)() -> this.DefaultBranch());
    }

    private String resolveOriginBranchName(String name) {
        return "origin/".concat(name);
    }

    @Override
    public Tuple3<Git, File, String> cloneGitRepository(GitUserCredentials credentials, GitSource source) {
        return this.cloneGitRepositoryBranch(credentials, source, this.resolveMainBranch(source));
    }

    private Tuple3<Git, File, String> cloneGitRepositoryTemplate(GitSource source, String branch, Function2<Path, File, Git> f) {
        File localRepoFolder = Files.createTempDirectory("git_source", new FileAttribute[0]).toAbsolutePath().toFile();
        this.logger().debug((Function0 & Serializable)() -> "Cloning git source: " + source.repositoryUrl() + " into a local folder: " + localRepoFolder);
        Path configRoot = OpenSSHConfigBootstrapper$.MODULE$.writeTempConfigWithDefaults();
        Git git = (Git)f.apply((Object)configRoot, (Object)localRepoFolder);
        OpenSSHConfigBootstrapper$.MODULE$.deleteTempConfig(configRoot);
        return new Tuple3((Object)git, (Object)localRepoFolder, (Object)branch);
    }

    @Override
    public Tuple3<Git, File, String> cloneGitRepositoryBranch(GitUserCredentials credentials, GitSource source, String branch) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.cloneGitRepositoryTemplate(source, branch, (Function2<Path, File, Git>)(Function2 & Serializable)(configRoot, localRepoFolder) -> GitAuthenticationStrategies$.MODULE$.cloneGitRepositoryWithAuthentication(credentials, source, configRoot.toFile()).setDirectory(localRepoFolder).setBranch(branch).call()));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tuple3 value = (Tuple3)success.value();
            return value;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().error((Function0 & Serializable)() -> "Error while cloning [" + branch + "], error was: " + exception.getMessage(), (Function0 & Serializable)() -> exception);
            throw new RepositoryCrawler.StitchRepositoryException(exception, "Error while cloning [" + branch + "]");
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Tuple3<Git, File, String> cloneGitRepositoryAndBranch(GitUserCredentials credentials, GitSource source, String branch) {
        Tuple3<Git, File, String> tuple3 = this.cloneGitRepository(credentials, source);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Git git = (Git)tuple3._1();
        File file = (File)tuple3._2();
        Tuple2 tuple2 = new Tuple2((Object)git, (Object)file);
        Git git2 = (Git)tuple2._1();
        File file2 = (File)tuple2._2();
        git2.checkout().setCreateBranch(true).setName(branch).call();
        return new Tuple3((Object)git2, (Object)file2, (Object)branch);
    }

    @Override
    public void cleanup(Tuple3<Git, ?, File> resources) {
        Tuple3<Git, ?, File> tuple3 = resources;
        if (tuple3 != null) {
            Git git = (Git)tuple3._1();
            File folder = (File)tuple3._3();
            if (git != null) {
                Git git2 = git;
                if (folder != null) {
                    File file = folder;
                    this.clean(git2, file);
                    return;
                }
            }
        }
        throw new MatchError(tuple3);
    }

    @Override
    public void clean(Git git, File folder) {
        git.getRepository().close();
        git.close();
        this.deleteRecursively(folder);
    }

    private void deleteRecursively(File file2) {
        if (file2.isDirectory()) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])file2.listFiles()), (Function1 & Serializable)file -> {
                this.deleteRecursively(file);
                return BoxedUnit.UNIT;
            });
        }
        try {
            if (file2.exists()) {
                file2.delete();
            }
        }
        catch (IOException e) {
            this.logger().error((Function0 & Serializable)() -> "Error occurred during the cleaning of cloned repository " + e.getMessage());
        }
    }

    @Override
    public List<String> getGitSourceBranchNames(GitUserCredentials credentials, GitSource source) {
        return this.getGitSourceBranchNames(credentials, source.repositoryUrl());
    }

    @Override
    public List<String> getGitSourceBranchNames(GitUserCredentials credentials, String url) {
        return this.listGitSourceBranchNames((Function1<Path, LsRemoteCommand>)(Function1 & Serializable)configRoot -> GitAuthenticationStrategies$.MODULE$.listWithAuthentication(credentials, url, configRoot.toFile()));
    }

    private List<String> listGitSourceBranchNames(Function1<Path, LsRemoteCommand> listBranches) {
        Path configRoot = OpenSSHConfigBootstrapper$.MODULE$.writeTempConfigWithDefaults();
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CollectionConverters$.MODULE$.CollectionHasAsScala(((LsRemoteCommand)listBranches.apply((Object)configRoot)).setTags(false).setHeads(true).call()).asScala());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Iterable branchRefs = (Iterable)success.value();
            OpenSSHConfigBootstrapper$.MODULE$.deleteTempConfig(configRoot);
            return ((IterableOnceOps)((IterableOps)branchRefs.map((Function1 & Serializable)ref -> Repository.shortenRefName((String)ref.getName()))).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GitOpsServiceImpl.$anonfun$listGitSourceBranchNames$3(x$3)))).toList();
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable e = failure.exception();
            if (e instanceof TransportException) {
                TransportException transportException = (TransportException)e;
                OpenSSHConfigBootstrapper$.MODULE$.deleteTempConfig(configRoot);
                throw new StitchException("Exception during fetching branch list.", transportException.getCause());
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            OpenSSHConfigBootstrapper$.MODULE$.deleteTempConfig(configRoot);
            throw new StitchException("Exception during fetching branch list.", e);
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public GitSourceInfo getGitSourceInfo(String branch, File localRepoFolder) {
        Repository localRepo = Git.open((File)localRepoFolder).getRepository();
        RevWalk walk = new RevWalk(localRepo);
        RevCommit commit = walk.parseCommit((AnyObjectId)localRepo.resolve(branch));
        String commitAuthor = commit.getAuthorIdent().getName();
        String commitId = commit.getId().getName();
        return new GitSourceInfo(commitAuthor, commitId);
    }

    @Override
    public void saveAndCommit(GitUserCredentials credentials, GitSource source, Git git, String commitMsg) {
        Throwable exception;
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            git.add().addFilepattern(".").call();
            this.commit(credentials, source, git, commitMsg);
        });
        if (try_ instanceof Success) {
            this.logger().info((Function0 & Serializable)() -> "Commit message: " + commitMsg);
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable exception2 = failure.exception();
            if (exception2 instanceof RepositoryCrawler.StitchRepositoryException) {
                RepositoryCrawler.StitchRepositoryException stitchRepositoryException = (RepositoryCrawler.StitchRepositoryException)((Object)exception2);
                throw stitchRepositoryException;
            }
        }
        if (bl && (exception = failure.exception()) instanceof Exception) {
            Exception exception3 = (Exception)exception;
            this.logger().error((Function0 & Serializable)() -> "Error while adding and committing a file", (Function0 & Serializable)() -> exception3);
            throw new RepositoryCrawler.StitchRepositoryException(exception3, "Error while adding and committing the file to git - " + exception3.getMessage());
        }
        String message = "Unsupported state " + try_ + " while adding and committing a file";
        this.logger().warn((Function0 & Serializable)() -> message);
        throw new IllegalStateException(message);
    }

    private void commit(GitUserCredentials credentials, GitSource source, Git git, String commitMsg) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            git.commit().setMessage(commitMsg).setAuthor(credentials.username(), credentials.email()).setCommitter(credentials.username(), credentials.email()).call();
            Path configRoot = OpenSSHConfigBootstrapper$.MODULE$.writeTempConfigWithDefaults();
            GitAuthenticationStrategies$.MODULE$.pushGitRepositoryWithAuthentication(git, credentials, source, configRoot.toFile(), (List<RefSpec>)Nil$.MODULE$);
            OpenSSHConfigBootstrapper$.MODULE$.deleteTempConfig(configRoot);
        });
        if (try_ instanceof Success) {
            this.logger().info((Function0 & Serializable)() -> "Commit message: " + commitMsg);
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().error((Function0 & Serializable)() -> "Error while committing a file", (Function0 & Serializable)() -> exception);
            throw new RepositoryCrawler.StitchRepositoryException(exception, "Error while committing the file to git - " + exception.getMessage());
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public boolean branchExists(GitUserCredentials credentials, GitSource source, String branch) {
        return this.getGitSourceBranchNames(credentials, source).contains((Object)branch);
    }

    @Override
    public void mergeBranch(GitUserCredentials credentials, GitSource source, String branchName) {
        Tuple3<Git, File, String> tuple3 = this.cloneGitRepository(credentials, source);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Git git = (Git)tuple3._1();
        File folder = (File)tuple3._2();
        Tuple2 tuple2 = new Tuple2((Object)git, (Object)folder);
        Git git2 = (Git)tuple2._1();
        File folder2 = (File)tuple2._2();
        ObjectId branchObjectId = git2.getRepository().resolve(this.resolveOriginBranchName(branchName));
        String message = "Merge branch '" + branchName + "' into " + this.resolveMainBranch(source);
        MergeResult mergeResult = this.doMerge(git2, branchObjectId, message);
        if (mergeResult.getMergeStatus().isSuccessful()) {
            this.logger().debug((Function0 & Serializable)() -> "Successfully merged [" + branchName + "] to [" + source.masterBranchName() + "]");
            this.commit(credentials, source, git2, message);
        } else if (mergeResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.CONFLICTING)) {
            this.handleMergeConflicts(source, branchName, mergeResult);
        } else {
            String warnMessage = "Failed merged [" + branchName + "] to [" + source.masterBranchName() + "]: until JGit supports merge resets, please run 'git reset --merge' to get back to a clean state";
            this.logger().warn((Function0 & Serializable)() -> warnMessage);
            throw new RepositoryCrawler.StitchRepositoryMergeException(null, warnMessage);
        }
        this.clean(git2, folder2);
    }

    private MergeResult doMerge(Git git, ObjectId branchObjectId, String message) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> git.merge().setFastForward(MergeCommand.FastForwardMode.FF).setCommit(true).include((AnyObjectId)branchObjectId).setSquash(true).call());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            MergeResult result = (MergeResult)success.value();
            return result;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().error((Function0 & Serializable)() -> "Error while: " + message, (Function0 & Serializable)() -> exception);
            throw new RepositoryCrawler.StitchRepositoryMergeException(exception, "Error while: " + message + ": " + exception.getMessage());
        }
        throw new MatchError((Object)try_);
    }

    private void handleMergeConflicts(GitSource source, String branchName, MergeResult mergeResult) {
        StringBuilder builder = new StringBuilder();
        CollectionConverters$.MODULE$.MapHasAsScala(mergeResult.getConflicts()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            GitOpsServiceImpl.$anonfun$handleMergeConflicts$1(builder, mergeResult, x0$1);
            return BoxedUnit.UNIT;
        });
        String conflicts = builder.result();
        this.logger().warn((Function0 & Serializable)() -> "Failed merged [" + branchName + "] to [" + source.masterBranchName() + "]: please resolve your merge conflicts and re-run publishing:\n " + conflicts);
        throw new RepositoryCrawler.StitchRepositoryMergeConflictsException("Merge conflicts occurred try resolving them manually and re-running publish:\n " + conflicts);
    }

    @Override
    public void deleteBranch(GitUserCredentials credentials, GitSource source, String branchName) {
        Path configRoot = OpenSSHConfigBootstrapper$.MODULE$.writeTempConfigWithDefaults();
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple3<Git, File, String> tuple3 = this.cloneGitRepository(source);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Git git = (Git)tuple3._1();
            Git git2 = git;
            git2.branchDelete().setBranchNames(new String[]{branchName}).setForce(true).call();
            RefSpec refSpec = new RefSpec(":refs/heads/" + branchName);
            GitAuthenticationStrategies$.MODULE$.pushGitRepositoryWithAuthentication(git2, credentials, source, configRoot.toFile(), (List<RefSpec>)new .colon.colon((Object)refSpec, (List)Nil$.MODULE$));
        });
        if (try_ instanceof Success) {
            this.logger().info((Function0 & Serializable)() -> "Deleted branch [" + branchName + "] from source: " + source.getId());
            OpenSSHConfigBootstrapper$.MODULE$.deleteTempConfig(configRoot);
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            OpenSSHConfigBootstrapper$.MODULE$.deleteTempConfig(configRoot);
            this.logger().error((Function0 & Serializable)() -> "Error while deleting branch [" + branchName + "] from source: " + source.getId() + ".", (Function0 & Serializable)() -> exception);
            throw new RepositoryCrawler.StitchRepositoryException(exception, "Error while deleting branch [" + branchName + "] from source " + source.getId() + " - " + exception.getMessage());
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ boolean $anonfun$listGitSourceBranchNames$3(String x$3) {
        return x$3.toLowerCase().matches("head");
    }

    public static final /* synthetic */ void $anonfun$handleMergeConflicts$2(StringBuilder builder$1, MergeResult mergeResult$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int[] conflict = (int[])tuple2._1();
            int i = tuple2._2$mcI$sp();
            builder$1.$plus$plus$eq("Conflict #" + i + "\n");
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.intArrayOps(conflict))), (Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    int chunk = tuple2._1$mcI$sp();
                    int j = tuple2._2$mcI$sp();
                    if (chunk >= 0 && j < conflict.length - 1 && j <= mergeResult$1.getMergedCommits().length - 1) {
                        return builder$1.$plus$plus$eq("\tat line #" + (chunk + 1) + " for " + mergeResult$1.getMergedCommits()[j] + "\n");
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$handleMergeConflicts$1(StringBuilder builder$1, MergeResult mergeResult$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String path = (String)tuple2._1();
            int[][] conflicts = (int[][])tuple2._2();
            builder$1.$plus$plus$eq("Conflicts in file " + path + "\n");
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])conflicts))), (Function1 & Serializable)x0$2 -> {
                GitOpsServiceImpl.$anonfun$handleMergeConflicts$2(builder$1, mergeResult$1, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public GitOpsServiceImpl() {
        GitOpsService.$init$(this);
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }
}

