/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.config.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.config.AnnotationAttributeConfiguration;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.impl.parser.AnnotationParser;

final class AnnotationAttributeConfigurationImpl
implements AnnotationAttributeConfiguration {
    private final String name;
    private final String packageName;
    private final boolean isMultiple;
    private final Object defaultValue;
    private final AnnotationElement.AttributeType type;
    private final Set<String> allowedValues;

    private AnnotationAttributeConfigurationImpl(String name, String packageName, boolean isMultiple, Object defaultValue, AnnotationElement.AttributeType type, Set<String> allowedValues) {
        this.name = name;
        this.packageName = packageName;
        this.isMultiple = isMultiple;
        this.defaultValue = defaultValue;
        this.type = type;
        this.allowedValues = allowedValues;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String packageName() {
        return this.packageName;
    }

    @Override
    public boolean multiple() {
        return this.isMultiple;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public AnnotationElement.AttributeType type() {
        return this.type;
    }

    @Override
    public Set<String> allowedValues() {
        return this.allowedValues;
    }

    @Override
    public boolean isAllowed(AnnotationElement.Value value) {
        if (this.allowedValues != null) {
            String v = String.valueOf(value.getValue());
            return this.allowedValues.contains(v) || this.packageName != null && v.startsWith(this.packageName) && this.allowedValues.contains(v.substring(this.packageName.length() + 1));
        }
        return true;
    }

    static final class BuilderImpl
    implements AnnotationAttributeConfiguration.Builder {
        private final AnnotationConfiguration.Builder parentBuilder;
        private final String name;
        private String packageName;
        AnnotationElement.AttributeType type = AnnotationElement.AttributeType.STRING;
        boolean isMultiple;
        Object defaultValue;
        String[] allowedValues;

        BuilderImpl(AnnotationConfiguration.Builder parentBuilder, String name) {
            this.parentBuilder = parentBuilder;
            this.name = name;
        }

        @Override
        public AnnotationAttributeConfiguration.Builder type(AnnotationElement.AttributeType type) {
            if (type == null) {
                throw new IllegalArgumentException("Annotation element type must not be null");
            }
            this.type = type;
            return this;
        }

        @Override
        public AnnotationAttributeConfiguration.Builder multiple(boolean isMultiple) {
            this.isMultiple = isMultiple;
            return this;
        }

        @Override
        public AnnotationAttributeConfiguration.Builder defaultValue(Object defaultValue) {
            if (defaultValue == null) {
                throw new IllegalArgumentException("Default value cannot be null");
            }
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public AnnotationAttributeConfiguration.Builder allowedValues(String ... allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        @Override
        public AnnotationAttributeConfiguration.Builder attribute(String name) {
            return this.parentBuilder.attribute(name);
        }

        @Override
        public AnnotationAttributeConfiguration.Builder metadataCreator(AnnotationMetadataCreator<?, ? extends AnnotatedDescriptor> annotationMetadataCreator) {
            this.parentBuilder.metadataCreator(annotationMetadataCreator);
            return this;
        }

        @Override
        public AnnotationAttributeConfiguration.Builder repeatable(String containingAnnotationName) {
            this.parentBuilder.repeatable(containingAnnotationName);
            return this;
        }

        @Override
        public AnnotationAttributeConfiguration.Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        AnnotationAttributeConfiguration buildAnnotationAttributeConfiguration() {
            HashSet<String> allowedValuesSet = null;
            if (this.allowedValues != null && this.allowedValues.length != 0) {
                switch (this.type) {
                    case ANNOTATION: 
                    case IDENTIFIER: 
                    case STRING: {
                        allowedValuesSet = new HashSet<String>(Arrays.asList(this.allowedValues));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The type ('" + this.type + "') of annotation element '" + this.name + "' does not support a set of allowed values");
                    }
                }
            }
            if (this.type == AnnotationElement.AttributeType.ANNOTATION && (allowedValuesSet == null || allowedValuesSet.size() != 1)) {
                throw new IllegalArgumentException("The type ('" + this.type + "') of annotation element '" + this.name + "' requires exactly one allowed value");
            }
            if (this.defaultValue != null) {
                switch (this.type) {
                    case ANNOTATION: {
                        if (!(this.defaultValue instanceof String)) {
                            throw new IllegalArgumentException("Illegal default value type for annotation element '" + this.name + "'. Annotation expected.");
                        }
                        AnnotationParser parser = new AnnotationParser((String)this.defaultValue, false);
                        List<AnnotationElement.Annotation> _annotations = parser.parse();
                        if (_annotations.size() != 1) {
                            throw new IllegalArgumentException("Default value for annotation element '" + this.name + "' must contain a single annotation value");
                        }
                        AnnotationElement.Annotation annotationValue = _annotations.iterator().next();
                        if (!allowedValuesSet.contains(annotationValue.getName())) {
                            throw new IllegalArgumentException("Default value for annotation element '" + this.name + "' must be an annotation of type " + (String)allowedValuesSet.iterator().next());
                        }
                        this.defaultValue = annotationValue;
                        break;
                    }
                    case IDENTIFIER: 
                    case STRING: {
                        if (this.defaultValue instanceof String) break;
                        throw new IllegalArgumentException("Illegal default value type for annotation element '" + this.name + "'. String expected.");
                    }
                    case CHARACTER: {
                        if (this.defaultValue instanceof Character) break;
                        throw new IllegalArgumentException("Illegal default value type for annotation element '" + this.name + "'. Character expected.");
                    }
                    case BOOLEAN: {
                        if (this.defaultValue instanceof Boolean) break;
                        throw new IllegalArgumentException("Illegal default value type for annotation element '" + this.name + "'. Boolean expected.");
                    }
                    case INT: {
                        if (this.defaultValue instanceof Integer) break;
                        throw new IllegalArgumentException("Illegal default value type for annotation element '" + this.name + "'. Integer expected.");
                    }
                    case LONG: {
                        if (this.defaultValue instanceof Long) break;
                        throw new IllegalArgumentException("Illegal default value type for annotation element '" + this.name + "'. Long expected.");
                    }
                    case FLOAT: {
                        if (this.defaultValue instanceof Float) break;
                        throw new IllegalArgumentException("Illegal default value type for annotation element '" + this.name + "'. Float expected.");
                    }
                    case DOUBLE: {
                        if (this.defaultValue instanceof Double) break;
                        throw new IllegalArgumentException("Illegal default value type for annotation element '" + this.name + "'. Double expected.");
                    }
                }
            }
            return new AnnotationAttributeConfigurationImpl(this.name, this.packageName, this.isMultiple, this.defaultValue, this.type, allowedValuesSet);
        }

        @Override
        public AnnotationConfiguration.Builder parentBuilder() {
            return this.parentBuilder;
        }

        @Override
        public AnnotationConfiguration.Builder annotation(String annotationName, AnnotationElement.AnnotationTarget ... target) {
            return this.parentBuilder.annotation(annotationName, target);
        }

        @Override
        public Configuration build() {
            return this.parentBuilder.build();
        }
    }
}

