/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Map;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="size")
@ApplicableTo(value={PropertyKind.STRING, PropertyKind.SET_OF_STRING, PropertyKind.SET_OF_CI, PropertyKind.LIST_OF_STRING, PropertyKind.LIST_OF_CI, PropertyKind.MAP_STRING_STRING})
@Target(value={ElementType.FIELD})
public @interface Size {
    public static final String DEFAULT_MESSAGE = "The size must be between %s and %s";
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = Integer.MAX_VALUE;

    public int min() default 0;

    public int max() default 0x7FFFFFFF;

    public String message() default "The size must be between %s and %s";

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<Object> {
        private int min = 0;
        private int max = Integer.MAX_VALUE;
        private String message = "The size must be between %s and %s";

        @Override
        public void validate(Object value, ValidationContext context) {
            if (this.min < 0) {
                context.error("The min parameter cannot be negative.", new Object[0]);
            }
            if (this.max < 0) {
                context.error("The max parameter cannot be negative.", new Object[0]);
            }
            if (this.max < this.min) {
                context.error("The length cannot be negative.", new Object[0]);
            }
            if (value != null) {
                int size;
                if (value instanceof String) {
                    int length = ((String)value).length();
                    if (this.isNotValid(length)) {
                        context.error(this.message, this.min, this.max);
                    }
                } else if (value instanceof Collection) {
                    int size2 = ((Collection)value).size();
                    if (this.isNotValid(size2)) {
                        context.error(this.message, this.min, this.max);
                    }
                } else if (value instanceof Map && this.isNotValid(size = ((Map)value).size())) {
                    context.error(this.message, this.min, this.max);
                }
            }
        }

        private boolean isNotValid(int length) {
            return length < this.min || length > this.max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

