/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.components.ComponentSource;
import com.jeta.forms.gui.components.ContainedFormFactory;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.TabProperty;
import com.jeta.open.i18n.I18N;
import com.jeta.open.registry.JETARegistry;
import com.jeta.open.support.EmptyCollection;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class TabbedPaneProperties
extends JETAProperty {
    static final long serialVersionUID = 3096566296606257673L;
    public static final int VERSION = 1;
    private LinkedList m_items;
    public static final String PROPERTY_ID = "tabs";
    static final /* synthetic */ boolean $assertionsDisabled;

    public TabbedPaneProperties() {
        super(PROPERTY_ID);
    }

    public void addTab(TabProperty tabProperty) {
        if (this.m_items == null) {
            this.m_items = new LinkedList();
        }
        this.m_items.add(tabProperty);
    }

    public Collection getTabs() {
        if (this.m_items != null) {
            return this.m_items;
        }
        return EmptyCollection.getInstance();
    }

    public void setValue(Object object) {
        if (object instanceof TabbedPaneProperties) {
            TabbedPaneProperties tabbedPaneProperties = (TabbedPaneProperties)object;
            this.m_items = new LinkedList();
            if (tabbedPaneProperties.m_items != null) {
                Iterator iterator = tabbedPaneProperties.m_items.iterator();
                while (iterator.hasNext()) {
                    TabProperty tabProperty = (TabProperty)iterator.next();
                    TabProperty tabProperty2 = new TabProperty();
                    tabProperty2.setValue(tabProperty);
                    this.m_items.add(tabProperty2);
                }
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jETABean) {
        Component component = null;
        if (jETABean != null) {
            component = jETABean.getDelegate();
        }
        if (component instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            int n = jTabbedPane.getSelectedIndex();
            jTabbedPane.removeAll();
            if (this.m_items != null) {
                Iterator iterator = this.m_items.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    TabProperty tabProperty = (TabProperty)iterator.next();
                    if (FormUtils.isDesignMode()) {
                        try {
                            object = (ContainedFormFactory)JETARegistry.lookup("contained.form.factory");
                            ComponentSource componentSource = (ComponentSource)JETARegistry.lookup("component.source");
                            FormUtils.safeAssert(componentSource != null);
                            FormUtils.safeAssert(object != null);
                            FormComponent formComponent = object.createTopParent(jTabbedPane, componentSource, tabProperty.getForm());
                            jTabbedPane.addTab(tabProperty.getTitle(), tabProperty.icon(), formComponent);
                        }
                        catch (FormException formException) {
                            FormsLogger.severe(formException);
                        }
                        continue;
                    }
                    try {
                        object = FormComponent.create();
                        ((FormComponent)object).setState(tabProperty.getFormMemento());
                        ((FormComponent)object).setTopLevelForm(true);
                        jTabbedPane.addTab(tabProperty.getTitle(), tabProperty.icon(), (Component)object);
                    }
                    catch (FormException formException) {
                        FormsLogger.severe(formException);
                    }
                }
                if (n >= 0 && n < jTabbedPane.getTabCount()) {
                    jTabbedPane.setSelectedIndex(n);
                }
            }
            if (FormUtils.isDesignMode() && jTabbedPane.getTabCount() == 0) {
                jTabbedPane.addTab(I18N.getLocalizedMessage("Tab Pane"), new JLabel(""));
            }
        }
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        super.read(jETAObjectInput.getSuperClassInput());
        int n = jETAObjectInput.readVersion();
        this.m_items = (LinkedList)jETAObjectInput.readObject("items");
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        super.write(jETAObjectOutput.getSuperClassOutput(JETAProperty.class));
        jETAObjectOutput.writeVersion(1);
        jETAObjectOutput.writeObject("items", this.m_items);
    }

    static {
        $assertionsDisabled = !TabbedPaneProperties.class.desiredAssertionStatus();
    }
}

