/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.ssh.HostKeyAlgoSupported;
import org.springframework.cloud.config.server.ssh.SshPropertyValidator;
import org.springframework.util.StringUtils;

public class HostKeyAlgoSupportedValidator
implements ConstraintValidator<HostKeyAlgoSupported, MultipleJGitEnvironmentProperties> {
    private static final String GIT_PROPERTY_PREFIX = "spring.cloud.config.server.git.";
    private static final Set<String> VALID_HOST_KEY_ALGORITHMS = new LinkedHashSet<String>(Arrays.asList("ssh-dss", "ssh-rsa", "ssh-ed25519", "ecdsa-sha2-nistp256", "ecdsa-sha2-nistp384", "ecdsa-sha2-nistp521"));
    private final SshPropertyValidator sshPropertyValidator = new SshPropertyValidator();

    public void initialize(HostKeyAlgoSupported constrainAnnotation) {
    }

    public boolean isValid(MultipleJGitEnvironmentProperties sshUriProperties, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        HashSet<Boolean> validationResults = new HashSet<Boolean>();
        List<JGitEnvironmentProperties> extractedProperties = this.sshPropertyValidator.extractRepoProperties(sshUriProperties);
        for (JGitEnvironmentProperties extractedProperty : extractedProperties) {
            if (!sshUriProperties.isIgnoreLocalSshSettings() || !SshPropertyValidator.isSshUri(extractedProperty.getUri())) continue;
            validationResults.add(this.isHostKeySpecifiedWhenAlgorithmSet(extractedProperty, context));
        }
        return !validationResults.contains(false);
    }

    private boolean isHostKeySpecifiedWhenAlgorithmSet(JGitEnvironmentProperties sshUriProperties, ConstraintValidatorContext context) {
        if (StringUtils.hasText((String)sshUriProperties.getHostKeyAlgorithm()) && !VALID_HOST_KEY_ALGORITHMS.contains(sshUriProperties.getHostKeyAlgorithm())) {
            context.buildConstraintViolationWithTemplate(String.format("Property '%shostKeyAlgorithm' must be one of %s", GIT_PROPERTY_PREFIX, VALID_HOST_KEY_ALGORITHMS)).addConstraintViolation();
            return false;
        }
        return true;
    }
}

