/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service;

import com.xebialabs.deployit.core.rest.exception.MissingRequestArgumentException;
import com.xebialabs.deployit.core.rest.view.ExternalFilesView;
import com.xebialabs.deployit.core.rest.view.PageableView;
import com.xebialabs.deployit.core.rest.view.RuleListItemView;
import com.xebialabs.deployit.core.rest.view.RuleWithContentView;
import com.xebialabs.deployit.core.rest.view.RuleWithSourceContentView;
import com.xebialabs.deployit.core.rest.view.RuleWithSourceContentView$;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.stitch.dao.BaseSpecificationRepository;
import com.xebialabs.deployit.plugin.stitch.dao.BaseSpecificationRepository$SpecificationFilter$;
import com.xebialabs.deployit.plugin.stitch.dao.SourceSyncStateRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.RuleRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.configuration.TransactionalStitchService;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.processor.RuleProcessorRepository;
import com.xebialabs.deployit.plugin.stitch.model.SourceSyncState;
import com.xebialabs.deployit.plugin.stitch.model.processor.RuleProcessor;
import com.xebialabs.deployit.plugin.stitch.model.specification.Rule;
import com.xebialabs.deployit.plugin.stitch.service.RuleService;
import com.xebialabs.deployit.plugin.stitch.service.package$;
import com.xebialabs.deployit.plugin.stitch.service.util.PageableUtils$;
import com.xebialabs.deployit.plugin.stitch.service.util.ProcessorParameterUtils$;
import com.xebialabs.deployit.security.sql.CiResolver;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@TransactionalStitchService
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001\u0002\u0006\f\u0001aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015A\u0005\u0001\"\u0003J\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!!\t\u0001\t\u0003\n\u0019C\u0001\nEK\u001a\fW\u000f\u001c;Sk2,7+\u001a:wS\u000e,'B\u0001\u0007\u000e\u0003\u001d\u0019XM\u001d<jG\u0016T!AD\b\u0002\rM$\u0018\u000e^2i\u0015\t\u0001\u0012#\u0001\u0004qYV<\u0017N\u001c\u0006\u0003%M\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003)U\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003Y\t1aY8n\u0007\u0001\u00192\u0001A\r !\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fMB\u0011\u0001%I\u0007\u0002\u0017%\u0011!e\u0003\u0002\f%VdWmU3sm&\u001cW-\u0001\u0006sKB|7/\u001b;pef\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u0007)\u0004\u0018M\u0003\u0002*\u001b\u0005\u0019A-Y8\n\u0005-2#A\u0004*vY\u0016\u0014V\r]8tSR|'/_\u0001\u0014aJ|7-Z:t_J\u0014V\r]8tSR|'/\u001f\t\u0003]Ej\u0011a\f\u0006\u0003a\u0019\n\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\n\u0005Iz#a\u0006*vY\u0016\u0004&o\\2fgN|'OU3q_NLGo\u001c:z\u0003e\u0019x.\u001e:dKNKhnY*uCR,'+\u001a9pg&$xN]=\u0011\u0005U2T\"\u0001\u0015\n\u0005]B#!G*pkJ\u001cWmU=oGN#\u0018\r^3SKB|7/\u001b;pef\f!bY5SKN|GN^3s!\tQt(D\u0001<\u0015\taT(A\u0002tc2T!AP\t\u0002\u0011M,7-\u001e:jifL!\u0001Q\u001e\u0003\u0015\rK'+Z:pYZ,'/\u0001\u0004=S:LGO\u0010\u000b\u0006\u0007\u0012+ei\u0012\t\u0003A\u0001AQaI\u0003A\u0002\u0011BQ\u0001L\u0003A\u00025BQaM\u0003A\u0002QBQ\u0001O\u0003A\u0002e\na!\u001b3U_B[EC\u0001&V!\tY%K\u0004\u0002M!B\u0011QjG\u0007\u0002\u001d*\u0011qjF\u0001\u0007yI|w\u000e\u001e \n\u0005E[\u0012A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!U\u000e\t\u000bY3\u0001\u0019A,\u0002\u0005%$\u0007C\u0001\u000eY\u0013\tI6DA\u0002J]R\fA\u0001\\5tiR1A,\u001b<z\u0003\u0017\u00012!\u00183g\u001b\u0005q&BA0a\u0003\u00111\u0018.Z<\u000b\u0005\u0005\u0014\u0017\u0001\u0002:fgRT!aY\t\u0002\t\r|'/Z\u0005\u0003Kz\u0013A\u0002U1hK\u0006\u0014G.\u001a,jK^\u0004\"!X4\n\u0005!t&\u0001\u0005*vY\u0016d\u0015n\u001d;Ji\u0016lg+[3x\u0011\u0015Qw\u00011\u0001l\u0003-q\u0017-\\3ta\u0006\u001cW-\u00133\u0011\u0007iag.\u0003\u0002n7\t1q\n\u001d;j_:\u0004\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\tU$\u0018\u000e\u001c\u0006\u0002g\u0006!!.\u0019<b\u0013\t)\bO\u0001\u0003V+&#\u0005\"B<\b\u0001\u0004A\u0018a\u00038b[\u0016\u0004\u0016\r\u001e;fe:\u00042A\u00077K\u0011\u0015Qx\u00011\u0001|\u0003\u0019\u0001\u0018mZ5oOB\u0019A0a\u0002\u000e\u0003uT!A`@\u0002\u0007\u0011$xN\u0003\u0003\u0002\u0002\u0005\r\u0011aA1qS*\u0019\u0011QA\t\u0002\r\u0015tw-\u001b8f\u0013\r\tI! \u0002\u0007!\u0006<\u0017N\\4\t\u000f\u00055q\u00011\u0001\u0002\u0010\u0005)qN\u001d3feB\u0019A0!\u0005\n\u0007\u0005MQP\u0001\u0005Pe\u0012,'/\u001b8h\u0003\u001d1\u0017N\u001c3P]\u0016$B!!\u0007\u0002 A\u0019Q,a\u0007\n\u0007\u0005uaLA\nSk2,w+\u001b;i\u0007>tG/\u001a8u-&,w\u000fC\u0003W\u0011\u0001\u0007a.\u0001\rhKR\u0014V\u000f\\3FqR,'O\\1m\r&dWm\u001d'jgR$B!!\n\u0002>A1\u0011qEA\u0019\u0003oqA!!\u000b\u0002.9\u0019Q*a\u000b\n\u0003qI1!a\f\u001c\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\r\u00026\t!A*[:u\u0015\r\tyc\u0007\t\u0004;\u0006e\u0012bAA\u001e=\n\tR\t\u001f;fe:\fGNR5mKN4\u0016.Z<\t\u000bYK\u0001\u0019\u00018)\u0007\u0001\t\t\u0005\u0005\u0003\u0002D\u0005eSBAA#\u0015\u0011\t9%!\u0013\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002L\u00055\u0013a\u00024bGR|'/\u001f\u0006\u0005\u0003\u001f\n\t&A\u0003cK\u0006t7O\u0003\u0003\u0002T\u0005U\u0013aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005]\u0013aA8sO&!\u00111LA#\u0005%\tU\u000f^8xSJ,G\rK\u0002\u0001\u0003?\u0002B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003K2\u0013!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002j\u0005\r$A\u0007+sC:\u001c\u0018m\u0019;j_:\fGn\u0015;ji\u000eD7+\u001a:wS\u000e,\u0007f\u0001\u0001\u0002nA!\u0011qNA;\u001b\t\t\tH\u0003\u0003\u0002t\u0005E\u0013AC:uKJ,w\u000e^=qK&!\u0011qOA9\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DefaultRuleService
implements RuleService {
    private final RuleRepository repository;
    private final RuleProcessorRepository processorRepository;
    private final SourceSyncStateRepository sourceSyncStateRepository;
    private final CiResolver ciResolver;

    private String idToPK(int id) {
        return this.ciResolver.getIdFromPk((Number)BoxesRunTime.boxToInteger((int)id));
    }

    @Override
    public PageableView<RuleListItemView> list(Option<UUID> namespaceId, Option<String> namePattern, Paging paging, Ordering order) {
        Page rules = this.repository.listByFilter(new BaseSpecificationRepository.SpecificationFilter(namespaceId, namePattern, BaseSpecificationRepository$SpecificationFilter$.MODULE$.apply$default$3(), BaseSpecificationRepository$SpecificationFilter$.MODULE$.apply$default$4()), (Pageable)PageRequest.of((int)PageableUtils$.MODULE$.PageableNormalizer(paging).getPageNumber(), (int)PageableUtils$.MODULE$.PageableNormalizer(paging).getPageSize(), (Sort.Direction)PageableUtils$.MODULE$.SortDirectionNormalizer(order).getSortDirection(), (String[])new String[]{PageableUtils$.MODULE$.SortDirectionNormalizer(order).getSortField()}));
        List ruleList = CollectionConverters$.MODULE$.ListHasAsScala(rules.getContent()).asScala().toList();
        Map syncStatesMap = ((List)ruleList.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.sourceId())).distinct()).map((Function1 & Serializable)sourceId -> DefaultRuleService.$anonfun$list$2(this, BoxesRunTime.unboxToInt((Object)sourceId))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        List newRules = ruleList.map((Function1 & Serializable)rule -> {
            Option syncState = (Option)syncStatesMap.getOrElse((Object)BoxesRunTime.boxToInteger((int)rule.sourceId()), (Function0 & Serializable)() -> None$.MODULE$);
            return package$.MODULE$.createRuleListItemView((Rule)rule, this.idToPK(rule.sourceId()), (Option<SourceSyncState>)syncState);
        });
        return new PageableView<RuleListItemView>(newRules, rules.hasNext(), rules.getTotalElements());
    }

    @Override
    public RuleWithContentView findOne(UUID id) {
        RuleWithSourceContentView rule = RuleWithSourceContentView$.MODULE$.rule2RuleWithContentView((Rule)Option$.MODULE$.apply((Object)id).map((Function1 & Serializable)i -> (Rule)$this.repository.get((UUID)i).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Rule with id " + i + " not found", new Object[0]);
        })).getOrElse((Function0 & Serializable)() -> {
            throw new MissingRequestArgumentException("Missing rule id in the request");
        }));
        Option<SourceSyncState> syncState = this.sourceSyncStateRepository.getBySourceId(rule.sourceId());
        return new RuleWithContentView(rule.id(), rule.name(), this.idToPK(rule.sourceId()), rule.branchName(), rule.description(), package$.MODULE$.extractFieldOption(syncState, (Function1 & Serializable)s -> s.endDate()), package$.MODULE$.extractFieldOption(syncState, (Function1 & Serializable)s -> s.commitAuthor()), package$.MODULE$.extractFieldOption(syncState, (Function1 & Serializable)s -> s.commitHash()), rule.content());
    }

    @Override
    public List<ExternalFilesView> getRuleExternalFilesList(UUID id) {
        return ProcessorParameterUtils$.MODULE$.toExternalFilesView(((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.processorRepository.findAllByRuleId(id)).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            RuleProcessor ruleProcessor = x0$1;
            if (ruleProcessor != null) {
                RuleProcessor ruleProcessor2 = ruleProcessor;
                return new Some((Object)ruleProcessor2);
            }
            return None$.MODULE$;
        })).flatMap((Function1 & Serializable)x -> CollectionConverters$.MODULE$.ListHasAsScala(x.getParameters()).asScala())).toList());
    }

    public static final /* synthetic */ Tuple2 $anonfun$list$2(DefaultRuleService $this, int sourceId) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)sourceId), $this.sourceSyncStateRepository.getBySourceId(sourceId));
    }

    public DefaultRuleService(RuleRepository repository, RuleProcessorRepository processorRepository, SourceSyncStateRepository sourceSyncStateRepository, CiResolver ciResolver) {
        this.repository = repository;
        this.processorRepository = processorRepository;
        this.sourceSyncStateRepository = sourceSyncStateRepository;
        this.ciResolver = ciResolver;
    }
}

