/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.BaseMessage;
import org.jgroups.Message;
import org.jgroups.util.ByteArray;
import org.jgroups.util.ObjectWrapper;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class ObjectMessage
extends BaseMessage {
    protected Object obj;

    public ObjectMessage() {
    }

    public ObjectMessage(Address dest) {
        super(dest);
    }

    public ObjectMessage(Address dest, Object obj) {
        super(dest);
        this.setObject(obj);
    }

    @Override
    public Supplier<Message> create() {
        return ObjectMessage::new;
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public boolean hasPayload() {
        return this.obj != null;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public int getLength() {
        return this.obj != null ? this.objSize() : 0;
    }

    @Override
    public byte[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectMessage setArray(byte[] b, int off, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectMessage setArray(ByteArray buf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectMessage setObject(Object obj) {
        this.obj = obj == null || obj instanceof SizeStreamable || Util.isPrimitiveType(obj) ? obj : new ObjectWrapper(obj);
        return this;
    }

    @Override
    public <T> T getObject() {
        if (this.obj == null) {
            return null;
        }
        if (this.obj instanceof ObjectWrapper) {
            return ((ObjectWrapper)this.obj).getObject();
        }
        return (T)this.obj;
    }

    @Override
    public int size() {
        return super.size() + this.objSize();
    }

    @Override
    public void writePayload(DataOutput out) throws IOException {
        Util.objectToStream(this.obj, out);
    }

    @Override
    public void readPayload(DataInput in) throws IOException, ClassNotFoundException {
        this.obj = Util.objectFromStream(in);
    }

    @Override
    protected Message copyPayload(Message copy) {
        if (this.obj != null) {
            copy.setObject(this.obj);
        }
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + String.format(", obj: %s", this.obj);
    }

    protected int objSize() {
        return Util.size(this.obj);
    }
}

