/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.InputChunked;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.OutputChunked;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.minlog.Log;

public class CompatibleFieldSerializer<T>
extends FieldSerializer<T> {
    private static final int THRESHOLD_BINARY_SEARCH = 32;

    public CompatibleFieldSerializer(Kryo kryo, Class type) {
        super(kryo, type);
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields = this.getFields();
        ObjectMap context = kryo.getGraphContext();
        if (!context.containsKey(this)) {
            context.put(this, null);
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Write " + fields.length + " field names."));
            }
            output.writeVarInt(fields.length, true);
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                output.writeString(this.getCachedFieldName(fields[i]));
            }
        }
        OutputChunked outputChunked = new OutputChunked(output, 1024);
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            fields[i].write(outputChunked, object);
            outputChunked.endChunks();
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        ObjectMap context = kryo.getGraphContext();
        FieldSerializer.CachedField[] fields = (FieldSerializer.CachedField[])context.get(this);
        if (fields == null) {
            int length = input.readVarInt(true);
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Read " + length + " field names."));
            }
            String[] names = new String[length];
            for (int i = 0; i < length; ++i) {
                names[i] = input.readString();
            }
            fields = new FieldSerializer.CachedField[length];
            FieldSerializer.CachedField[] allFields = this.getFields();
            if (length < 32) {
                block1: for (int i = 0; i < length; ++i) {
                    String schemaName = names[i];
                    int nn = allFields.length;
                    for (int ii = 0; ii < nn; ++ii) {
                        if (!this.getCachedFieldName(allFields[ii]).equals(schemaName)) continue;
                        fields[i] = allFields[ii];
                        continue block1;
                    }
                    if (!Log.TRACE) continue;
                    Log.trace((String)"kryo", (String)("Ignore obsolete field: " + schemaName));
                }
            } else {
                int maxFieldLength = allFields.length;
                block3: for (int i = 0; i < length; ++i) {
                    String schemaName = names[i];
                    int low = 0;
                    int high = maxFieldLength - 1;
                    while (low <= high) {
                        int mid = low + high >>> 1;
                        String midVal = this.getCachedFieldName(allFields[mid]);
                        int compare = schemaName.compareTo(midVal);
                        if (compare < 0) {
                            high = mid - 1;
                            continue;
                        }
                        if (compare > 0) {
                            low = mid + 1;
                            continue;
                        }
                        fields[i] = allFields[mid];
                        continue block3;
                    }
                    if (!Log.TRACE) continue;
                    Log.trace((String)"kryo", (String)("Ignore obsolete field: " + schemaName));
                }
            }
            context.put(this, fields);
        }
        InputChunked inputChunked = new InputChunked(input, 1024);
        boolean hasGenerics = this.getGenerics() != null;
        for (FieldSerializer.CachedField cachedField : fields) {
            if (cachedField != null && hasGenerics) {
                cachedField = this.getField(this.getCachedFieldName(cachedField));
            }
            if (cachedField == null) {
                if (Log.TRACE) {
                    Log.trace((String)"kryo", (String)"Skip obsolete field.");
                }
                inputChunked.nextChunks();
                continue;
            }
            cachedField.read(inputChunked, object);
            inputChunked.nextChunks();
        }
        return object;
    }
}

