/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commons.util.Util;
import org.infinispan.metadata.impl.IracMetadata;

public class IracTombstoneInfo {
    private final Object key;
    private final int segment;
    private final IracMetadata metadata;

    public IracTombstoneInfo(Object key, int segment, IracMetadata metadata) {
        this.key = Objects.requireNonNull(key);
        this.segment = segment;
        this.metadata = Objects.requireNonNull(metadata);
    }

    public Object getKey() {
        return this.key;
    }

    public int getSegment() {
        return this.segment;
    }

    public IracMetadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IracTombstoneInfo that = (IracTombstoneInfo)o;
        if (this.segment != that.segment) {
            return false;
        }
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.segment;
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    public String toString() {
        return "IracTombstoneInfo{key=" + Util.toStr((Object)this.key) + ", segment=" + this.segment + ", metadata=" + this.metadata + "}";
    }

    public static void writeTo(ObjectOutput output, IracTombstoneInfo tombstone) throws IOException {
        if (tombstone == null) {
            output.writeObject(null);
            return;
        }
        output.writeObject(tombstone.key);
        output.writeInt(tombstone.segment);
        IracMetadata.writeTo(output, tombstone.metadata);
    }

    public static IracTombstoneInfo readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        Object key = input.readObject();
        return key == null ? null : new IracTombstoneInfo(key, input.readInt(), IracMetadata.readFrom(input));
    }
}

