/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.startup;

import com.xebialabs.plugin.manager.config.ConfigWrapper$;
import com.xebialabs.plugin.manager.metadata.XLProduct;
import com.xebialabs.plugin.manager.metadata.XLProduct$;
import com.xebialabs.plugin.manager.model.DbPlugin;
import com.xebialabs.plugin.manager.model.DbPlugin$;
import com.xebialabs.plugin.manager.model.DbPlugin$DbPluginOps$;
import com.xebialabs.plugin.manager.model.FilePlugin;
import com.xebialabs.plugin.manager.model.FilePlugin$;
import com.xebialabs.plugin.manager.model.FilePlugin$FilePluginOps$;
import com.xebialabs.plugin.manager.repository.sql.SqlPluginRepository;
import com.xebialabs.plugin.manager.rest.api.PluginSource$;
import com.xebialabs.plugin.manager.rest.api.PluginStatus$;
import com.xebialabs.plugin.manager.startup.SourceOfTruth$;
import com.xebialabs.plugin.manager.util.PluginsTraverser$;
import com.xebialabs.xlplatform.sugar.PathSugar$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.slf4j.Marker;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d\u0001\u0002\n\u0014\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u00159\u0006\u0001\"\u0001_\u0011\u001d\u0011\u0007A1A\u0005\u0002\rDaA\u001b\u0001!\u0002\u0013!\u0007\"B6\u0001\t\u0003a\u0007\"B6\u0001\t\u0013\u0001\bbBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V!9\u00111\f\u0001\u0005\n\u0005u#A\u0005)mk\u001eLgnU=oG\"\u0014xN\\5{KJT!\u0001F\u000b\u0002\u000fM$\u0018M\u001d;va*\u0011acF\u0001\b[\u0006t\u0017mZ3s\u0015\tA\u0012$\u0001\u0004qYV<\u0017N\u001c\u0006\u00035m\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003q\t1aY8n\u0007\u0001\u00192\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0006g24GG\u001b\u0006\u0002U\u0005AqM]5{u2,G-\u0003\u0002-O\t9Aj\\4hS:<\u0017\u0001\u00059mk\u001eLgNU3q_NLGo\u001c:z!\tyC'D\u00011\u0015\t\t$'A\u0002tc2T!aM\u000b\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00026a\t\u00192+\u001d7QYV<\u0017N\u001c*fa>\u001c\u0018\u000e^8ss\u00069\u0001O]8ek\u000e$\bC\u0001\u001d@\u001d\tIT\b\u0005\u0002;C5\t1H\u0003\u0002=;\u00051AH]8pizJ!AP\u0011\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}\u0005\n!\u0002\u001d7vO&t7\u000fR5s!\t!5*D\u0001F\u0015\t1u)\u0001\u0003gS2,'B\u0001%J\u0003\rq\u0017n\u001c\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\taUI\u0001\u0003QCRD\u0017!D:pkJ\u001cWm\u00144UeV$\b\u000e\u0005\u0002P':\u0011\u0001+U\u0007\u0002'%\u0011!kE\u0001\u000e'>,(oY3PMR\u0013X\u000f\u001e5\n\u0005Q+&!\u0002,bYV,\u0017B\u0001,\"\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u0015I&l\u0017/^!\t\u0001\u0006\u0001C\u0003.\u000b\u0001\u0007a\u0006C\u00037\u000b\u0001\u0007q\u0007C\u0003C\u000b\u0001\u00071\tC\u0003N\u000b\u0001\u0007a\n\u0006\u0003Z?\u0002\f\u0007\"B\u0017\u0007\u0001\u0004q\u0003\"\u0002\u001c\u0007\u0001\u00049\u0004\"B'\u0007\u0001\u0004q\u0015!\u0003=m!J|G-^2u+\u0005!\u0007CA3i\u001b\u00051'BA4\u0016\u0003!iW\r^1eCR\f\u0017BA5g\u0005%AF\n\u0015:pIV\u001cG/\u0001\u0006yYB\u0013x\u000eZ;di\u0002\n1b]=oGBcWoZ5ogR\tQ\u000e\u0005\u0002!]&\u0011q.\t\u0002\u0005+:LG\u000f\u0006\u0004nc\u0006\u0015\u0011Q\u0003\u0005\u0006e*\u0001\ra]\u0001\nMN\u0004F.^4j]N\u00042\u0001^=}\u001d\t)xO\u0004\u0002;m&\t!%\u0003\u0002yC\u00059\u0001/Y2lC\u001e,\u0017B\u0001>|\u0005\u0011a\u0015n\u001d;\u000b\u0005a\f\u0003cA?\u0002\u00025\taP\u0003\u0002\u0000+\u0005)Qn\u001c3fY&\u0019\u00111\u0001@\u0003\u0015\u0019KG.\u001a)mk\u001eLg\u000eC\u0004\u0002\b)\u0001\r!!\u0003\u0002\u0013\u0011\u0014\u0007\u000b\\;hS:\u001c\b#\u0002;\u0002\f\u0005=\u0011bAA\u0007w\n\u00191+Z9\u0011\u0007u\f\t\"C\u0002\u0002\u0014y\u0014\u0001\u0002\u00122QYV<\u0017N\u001c\u0005\b\u0003/Q\u0001\u0019AA\r\u00031\u0001H.^4j]N{WO]2f!\r\tYb\u0015\b\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\r\t\u0007/\u001b\u0006\u0004\u0003K)\u0012\u0001\u0002:fgRLA!!\u000b\u0002 \u0005a\u0001\u000b\\;hS:\u001cv.\u001e:dK\u0006Q2/\u001f8d+NLgn\u001a#c\u0003N\u001cv.\u001e:dK>3GK];uQR)Q.a\f\u00022!)!o\u0003a\u0001g\"9\u0011qA\u0006A\u0002\u0005%\u0011AG:z]\u000e,6/\u001b8h\rN\f5oU8ve\u000e,wJ\u001a+skRDGcB7\u00028\u0005e\u00121\b\u0005\u0006e2\u0001\ra\u001d\u0005\b\u0003\u000fa\u0001\u0019AA\u0005\u0011\u001d\t9\u0002\u0004a\u0001\u00033\t\u0011c\u001e:ji\u0016$vNR5mKNL8\u000f^3n)\ri\u0017\u0011\t\u0005\b\u0003\u0007j\u0001\u0019AA\b\u0003!!'\r\u00157vO&t\u0017!F2mK\u0006tW\u000f\u001d$s_64\u0015\u000e\\3tsN$X-\u001c\u000b\u0004[\u0006%\u0003BBA&\u001d\u0001\u0007A0\u0001\u0005ggBcWoZ5o\u0003M\u0019G.Z1okB4%o\\7ECR\f'-Y:f)\ri\u0017\u0011\u000b\u0005\b\u0003\u0007z\u0001\u0019AA\b\u0003=9(/\u001b;f)>$\u0015\r^1cCN,G#B7\u0002X\u0005e\u0003\"\u0002\r\u0011\u0001\u0004a\bbBA\f!\u0001\u0007\u0011\u0011D\u0001\u0015S:LG\u000f\u0015:pIV\u001cGo\u00159fG&4\u0017nY:\u0015\u00075\fy\u0006C\u00037#\u0001\u0007A\r")
public class PluginSynchronizer
implements Logging {
    private final SqlPluginRepository pluginRepository;
    private final Path pluginsDir;
    private final Enumeration.Value sourceOfTruth;
    private final XLProduct xlProduct;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PluginSynchronizer pluginSynchronizer = this;
        synchronized (pluginSynchronizer) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public XLProduct xlProduct() {
        return this.xlProduct;
    }

    public void syncPlugins() {
        if (PathSugar$.MODULE$.path2File(this.pluginsDir).exists() && this.pluginRepository.pluginTablesExist()) {
            this.info((Function0<Object>)(Function0 & Serializable)() -> "Starting plugin synchronization, using " + $this.sourceOfTruth + " as source of truth");
            Map dbPluginsBySource = this.pluginRepository.getAllWithBytes().groupBy((Function1 & Serializable)x$1 -> x$1.source().toString());
            PluginsTraverser$.MODULE$.traverse(this.pluginsDir, ConfigWrapper$.MODULE$.extension(), (Function2<Enumeration.Value, List<FilePlugin>, BoxedUnit>)(Function2 & Serializable)(pluginSource, plugins) -> {
                this.syncPlugins((List<FilePlugin>)plugins, (Seq<DbPlugin>)((Seq)dbPluginsBySource.getOrElse((Object)pluginSource.toString(), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())), pluginSource);
                return BoxedUnit.UNIT;
            }, (Function1<List<FilePlugin>, BoxedUnit>)(Function1 & Serializable)plugins -> {
                this.syncPlugins((List<FilePlugin>)plugins, (Seq<DbPlugin>)((Seq)dbPluginsBySource.getOrElse((Object)PluginSource$.MODULE$.LOCAL().toString(), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())), PluginSource$.MODULE$.LOCAL());
                return BoxedUnit.UNIT;
            });
            this.pluginRepository.updateAllPluginsStatusTo(PluginStatus$.MODULE$.INSTALLED());
            return;
        }
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Skipping plugin synchronization, database is not ready yet.");
    }

    private void syncPlugins(List<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins, Enumeration.Value pluginSource) {
        Enumeration.Value value = this.sourceOfTruth;
        Enumeration.Value value2 = SourceOfTruth$.MODULE$.FILE_SYSTEM();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.syncUsingFsAsSourceOfTruth(fsPlugins, dbPlugins, pluginSource);
            return;
        }
        Enumeration.Value value4 = SourceOfTruth$.MODULE$.DATABASE();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            this.syncUsingDbAsSourceOfTruth(fsPlugins, dbPlugins);
            return;
        }
        throw new MatchError((Object)value);
    }

    public void syncUsingDbAsSourceOfTruth(List<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins) {
        fsPlugins.filter((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)FilePlugin$FilePluginOps$.MODULE$.doesntExistIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins))).foreach((Function1 & Serializable)fsPlugin -> {
            this.cleanupFromFilesystem(fsPlugin);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)dbPlugins.filter((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)DbPlugin$DbPluginOps$.MODULE$.doesntExistIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPlugins)))).foreach((Function1 & Serializable)dbPlugin -> {
            this.writeToFilesystem(dbPlugin);
            return BoxedUnit.UNIT;
        });
        Seq mismatchedDbPlugins = (Seq)dbPlugins.filter((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)DbPlugin$DbPluginOps$.MODULE$.hasDifferentContentOrVersionThanANameMatchIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPlugins)));
        List mismatchedFsPlugins = fsPlugins.filter((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)FilePlugin$FilePluginOps$.MODULE$.hasDifferentContentAndVersionThanAMatchIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins)));
        mismatchedFsPlugins.foreach((Function1 & Serializable)fsPlugin -> {
            this.cleanupFromFilesystem(fsPlugin);
            return BoxedUnit.UNIT;
        });
        mismatchedDbPlugins.foreach((Function1 & Serializable)dbPlugin -> {
            this.writeToFilesystem(dbPlugin);
            return BoxedUnit.UNIT;
        });
    }

    public void syncUsingFsAsSourceOfTruth(List<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins, Enumeration.Value pluginSource) {
        ((IterableOnceOps)dbPlugins.filter((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)DbPlugin$DbPluginOps$.MODULE$.doesntExistIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPlugins)))).foreach((Function1 & Serializable)dbPlugin -> {
            this.cleanupFromDatabase(dbPlugin);
            return BoxedUnit.UNIT;
        });
        fsPlugins.filter((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)FilePlugin$FilePluginOps$.MODULE$.doesntExistIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins))).foreach((Function1 & Serializable)fsPlugin -> {
            this.writeToDatabase(fsPlugin, pluginSource);
            return BoxedUnit.UNIT;
        });
        Seq mismatchedDbPlugins = (Seq)dbPlugins.filter((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)DbPlugin$DbPluginOps$.MODULE$.hasDifferentContentOrVersionThanANameMatchIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPlugins)));
        List mismatchedFsPlugins = fsPlugins.filter((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)FilePlugin$FilePluginOps$.MODULE$.hasDifferentContentAndVersionThanAMatchIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins)));
        mismatchedDbPlugins.foreach((Function1 & Serializable)dbPlugin -> {
            this.cleanupFromDatabase(dbPlugin);
            return BoxedUnit.UNIT;
        });
        mismatchedFsPlugins.foreach((Function1 & Serializable)fsPlugin -> {
            this.writeToDatabase(fsPlugin, pluginSource);
            return BoxedUnit.UNIT;
        });
    }

    private void writeToFilesystem(DbPlugin dbPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Copying plugin " + dbPlugin.name() + " from database to filesystem");
        String fileName = dbPlugin.name() + (dbPlugin.version().isEmpty() ? "" : "-" + dbPlugin.version().get()) + "." + dbPlugin.extension();
        File targetFile = new File(this.pluginsDir + File.separator + dbPlugin.source() + File.separator + fileName);
        FileUtils.writeByteArrayToFile((File)targetFile, (byte[])((byte[])dbPlugin.bytes().get()));
    }

    private void cleanupFromFilesystem(FilePlugin fsPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Removing plugin " + fsPlugin.name() + " from filesystem");
        FileUtils.forceDelete((File)PathSugar$.MODULE$.path2File(fsPlugin.filePath()));
    }

    private void cleanupFromDatabase(DbPlugin dbPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Removing plugin " + dbPlugin.name() + " from database");
        this.pluginRepository.delete(dbPlugin);
    }

    private void writeToDatabase(FilePlugin plugin, Enumeration.Value pluginSource) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Inserting plugin " + plugin.name() + " into database");
        Enumeration.Value value = pluginSource;
        Enumeration.Value value2 = PluginSource$.MODULE$.LOCAL();
        Enumeration.Value value3 = value;
        DbPlugin dbPlugin = !(value2 != null ? !value2.equals(value3) : value3 != null) ? FilePlugin$FilePluginOps$.MODULE$.toLocalDbPlugin$extension(FilePlugin$.MODULE$.FilePluginOps(plugin)) : FilePlugin$FilePluginOps$.MODULE$.toOfficialDbPlugin$extension(FilePlugin$.MODULE$.FilePluginOps(plugin), this.xlProduct());
        this.pluginRepository.insert(dbPlugin);
    }

    private void initProductSpecifics(XLProduct product) {
        ConfigWrapper$.MODULE$.initWith(product);
    }

    public PluginSynchronizer(SqlPluginRepository pluginRepository, String product, Path pluginsDir, Enumeration.Value sourceOfTruth) {
        this.pluginRepository = pluginRepository;
        this.pluginsDir = pluginsDir;
        this.sourceOfTruth = sourceOfTruth;
        Logging.$init$((Logging)this);
        this.xlProduct = XLProduct$.MODULE$.fromString(product);
        this.initProductSpecifics(this.xlProduct());
    }

    public PluginSynchronizer(SqlPluginRepository pluginRepository, String product, Enumeration.Value sourceOfTruth) {
        this(pluginRepository, product, Paths.get("plugins", new String[0]), sourceOfTruth);
    }
}

