/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oslogin.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PosixAccountName
implements ResourceName {
    private static final PathTemplate USER_PROJECT = PathTemplate.createWithoutUrlEncoding((String)"users/{user}/projects/{project}");
    private volatile Map<String, String> fieldValuesMap;
    private final String user;
    private final String project;

    @Deprecated
    protected PosixAccountName() {
        this.user = null;
        this.project = null;
    }

    private PosixAccountName(Builder builder) {
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public String getUser() {
        return this.user;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PosixAccountName of(String user, String project) {
        return PosixAccountName.newBuilder().setUser(user).setProject(project).build();
    }

    public static String format(String user, String project) {
        return PosixAccountName.newBuilder().setUser(user).setProject(project).build().toString();
    }

    public static PosixAccountName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = USER_PROJECT.validatedMatch(formattedString, "PosixAccountName.parse: formattedString not in valid format");
        return PosixAccountName.of((String)matchMap.get("user"), (String)matchMap.get("project"));
    }

    public static List<PosixAccountName> parseList(List<String> formattedStrings) {
        ArrayList<PosixAccountName> list = new ArrayList<PosixAccountName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PosixAccountName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PosixAccountName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PosixAccountName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return USER_PROJECT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PosixAccountName posixAccountName = this;
            synchronized (posixAccountName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.user != null) {
                        fieldMapBuilder.put((Object)"user", (Object)this.user);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return USER_PROJECT.instantiate(new String[]{"user", this.user, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PosixAccountName that = (PosixAccountName)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.user);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class Builder {
        private String user;
        private String project;

        protected Builder() {
        }

        public String getUser() {
            return this.user;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder(PosixAccountName posixAccountName) {
            this.user = posixAccountName.user;
            this.project = posixAccountName.project;
        }

        public PosixAccountName build() {
            return new PosixAccountName(this);
        }
    }
}

