/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.UnwrappingEmbeddedCacheManager;
import org.infinispan.security.Security;

@Scope(value=Scopes.NONE)
public class ReplicableManagerFunctionCommand
implements ReplicableCommand {
    public static final byte COMMAND_ID = 60;
    private Function<? super EmbeddedCacheManager, ?> function;
    private Subject subject;
    @Inject
    EmbeddedCacheManager manager;

    public ReplicableManagerFunctionCommand() {
    }

    public ReplicableManagerFunctionCommand(Function<? super EmbeddedCacheManager, ?> function, Subject subject) {
        this.function = function;
        this.subject = subject;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        if (this.subject == null) {
            return CompletableFuture.completedFuture(this.function.apply(new UnwrappingEmbeddedCacheManager(this.manager)));
        }
        return CompletableFuture.completedFuture(Security.doAs(this.subject, this.function, new UnwrappingEmbeddedCacheManager(this.manager)));
    }

    @Override
    public byte getCommandId() {
        return 60;
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.function = (Function)input.readObject();
        this.subject = (Subject)input.readObject();
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.function);
        output.writeObject(this.subject);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }
}

