/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.http.apache;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.HttpConnectionFactory2;
import org.eclipse.jgit.transport.http.NoCheckX509TrustManager;
import org.eclipse.jgit.transport.http.apache.HttpClientConnection;
import org.eclipse.jgit.transport.http.apache.internal.HttpApacheText;
import org.eclipse.jgit.util.HttpSupport;

public class HttpClientConnectionFactory
implements HttpConnectionFactory2 {
    public HttpConnection create(URL url) throws IOException {
        return new HttpClientConnection(url.toString());
    }

    public HttpConnection create(URL url, Proxy proxy) throws IOException {
        return new HttpClientConnection(url.toString(), proxy);
    }

    public HttpConnectionFactory2.GitSession newSession() {
        return new HttpClientSession();
    }

    private static class HttpClientSession
    implements HttpConnectionFactory2.GitSession {
        private SSLContext securityContext;
        private SSLConnectionSocketFactory socketFactory;
        private boolean isDefault;

        private HttpClientSession() {
        }

        public HttpClientConnection configure(HttpConnection connection, boolean sslVerify) throws IOException, GeneralSecurityException {
            if (!(connection instanceof HttpClientConnection)) {
                throw new IllegalArgumentException(MessageFormat.format(HttpApacheText.get().httpWrongConnectionType, HttpClientConnection.class.getName(), connection.getClass().getName()));
            }
            HttpClientConnection conn = (HttpClientConnection)connection;
            String scheme = conn.getURL().getProtocol();
            if (!"https".equals(scheme)) {
                return conn;
            }
            if (this.securityContext == null || this.isDefault != sslVerify) {
                HostnameVerifier verifier;
                this.isDefault = sslVerify;
                if (sslVerify) {
                    this.securityContext = SSLContext.getDefault();
                    verifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
                } else {
                    this.securityContext = SSLContext.getInstance("TLS");
                    TrustManager[] trustAllCerts = new TrustManager[]{new NoCheckX509TrustManager()};
                    this.securityContext.init(null, trustAllCerts, null);
                    verifier = (name, session) -> true;
                }
                this.socketFactory = new SSLConnectionSocketFactory(this.securityContext, verifier){

                    protected void prepareSocket(SSLSocket socket) throws IOException {
                        super.prepareSocket(socket);
                        HttpSupport.configureTLS((SSLSocket)socket);
                    }
                };
            }
            conn.setSSLSocketFactory(this.socketFactory, this.isDefault);
            return conn;
        }

        public void close() {
            this.securityContext = null;
            this.socketFactory = null;
        }
    }
}

