/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.diag.DiagUtil;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.vti.VTITemplate;

public class ErrorLogReader
extends VTITemplate {
    private boolean gotFile;
    private InputStreamReader inputFileStreamReader;
    private InputStream inputStream;
    private BufferedReader bufferedReader;
    private String inputFileName;
    private String line;
    private int endTimestampIndex;
    private int threadIndex;
    private int xidIndex;
    private int lccidIndex;
    private int databaseIndex;
    private int drdaidIndex;
    private static final String END_TIMESTAMP = " Thread";
    private static final String PARAMETERS_STRING = "Parameters:";
    private static final String BEGIN_THREAD_STRING = "[";
    private static final String END_THREAD_STRING = "]";
    private static final String BEGIN_XID_STRING = "= ";
    private static final String END_XID_STRING = ")";
    private static final String BEGIN_DATABASE_STRING = "(DATABASE =";
    private static final String END_DATABASE_STRING = ")";
    private static final String BEGIN_DRDAID_STRING = "(DRDAID =";
    private static final String END_DRDAID_STRING = ")";
    private static final String BEGIN_EXECUTING_STRING = "Executing prepared";
    private static final String END_EXECUTING_STRING = " :End prepared";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("TS", 12, false, 29), EmbedResultSetMetaData.getResultColumnDescriptor("THREADID", 12, false, 40), EmbedResultSetMetaData.getResultColumnDescriptor("XID", 12, false, 15), EmbedResultSetMetaData.getResultColumnDescriptor("LCCID", 12, false, 15), EmbedResultSetMetaData.getResultColumnDescriptor("DATABASE", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("DRDAID", 12, true, 50), EmbedResultSetMetaData.getResultColumnDescriptor("LOGTEXT", 12, false, 32672)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public ErrorLogReader() throws StandardException {
        DiagUtil.checkAccess();
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("derby.system.home");
            }
        });
        this.inputFileName = "derby.log";
        if (string != null) {
            this.inputFileName = string + "/" + this.inputFileName;
        }
    }

    public ErrorLogReader(String string) throws StandardException {
        DiagUtil.checkAccess();
        this.inputFileName = string;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.gotFile) {
            this.gotFile = true;
            try {
                this.inputFileStreamReader = new InputStreamReader(new FileInputStream(this.inputFileName));
                this.bufferedReader = new BufferedReader(this.inputFileStreamReader, 32768);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new SQLException(fileNotFoundException.getMessage());
            }
        }
        do {
            try {
                this.line = this.bufferedReader.readLine();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            if (this.line == null) {
                return false;
            }
            this.endTimestampIndex = this.line.indexOf(END_TIMESTAMP);
            this.threadIndex = this.line.indexOf(BEGIN_THREAD_STRING);
            this.xidIndex = this.line.indexOf(BEGIN_XID_STRING);
            this.lccidIndex = this.line.indexOf(BEGIN_XID_STRING, this.xidIndex + 1);
            this.databaseIndex = this.line.indexOf(BEGIN_DATABASE_STRING, this.lccidIndex + 1);
            this.drdaidIndex = this.line.indexOf(BEGIN_DRDAID_STRING, this.databaseIndex + 1);
        } while (this.line.indexOf(PARAMETERS_STRING) != -1 || this.endTimestampIndex == -1 || this.threadIndex == -1 || this.xidIndex == -1 || this.databaseIndex == -1);
        return true;
    }

    @Override
    public void close() {
        if (this.bufferedReader != null) {
            try {
                this.bufferedReader.close();
                this.inputFileStreamReader.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.bufferedReader = null;
                this.inputFileStreamReader = null;
            }
        }
    }

    @Override
    public String getString(int n) throws SQLException {
        switch (n) {
            case 1: {
                return this.line.substring(0, this.endTimestampIndex);
            }
            case 2: {
                return this.line.substring(this.threadIndex + 1, this.line.indexOf(END_THREAD_STRING));
            }
            case 3: {
                return this.line.substring(this.xidIndex + 2, this.line.indexOf(")", this.xidIndex));
            }
            case 4: {
                return this.line.substring(this.lccidIndex + 2, this.line.indexOf(")", this.lccidIndex));
            }
            case 5: {
                return this.line.substring(this.databaseIndex + BEGIN_DATABASE_STRING.length(), this.line.indexOf(")", this.databaseIndex));
            }
            case 6: {
                return this.line.substring(this.drdaidIndex + BEGIN_DRDAID_STRING.length(), this.line.indexOf(")", this.drdaidIndex));
            }
            case 7: {
                StringBuffer stringBuffer = new StringBuffer(64);
                if (this.line.indexOf(BEGIN_EXECUTING_STRING) == -1) {
                    stringBuffer.append(this.line.substring(this.line.indexOf(")", this.drdaidIndex) + 3));
                } else {
                    int n2 = this.line.indexOf(END_EXECUTING_STRING, this.drdaidIndex);
                    if (n2 == -1) {
                        stringBuffer.append(this.line.substring(this.line.indexOf(")", this.drdaidIndex) + 3));
                    } else {
                        stringBuffer.append(this.line.substring(this.line.indexOf(")", this.drdaidIndex) + 3, n2));
                    }
                    while (n2 == -1) {
                        try {
                            this.line = this.bufferedReader.readLine();
                        }
                        catch (IOException iOException) {
                            throw new SQLException("Error reading file " + iOException);
                        }
                        n2 = this.line.indexOf(END_EXECUTING_STRING);
                        if (n2 == -1) {
                            stringBuffer.append(this.line);
                            continue;
                        }
                        stringBuffer.append(this.line.substring(0, n2));
                    }
                }
                return StringUtil.truncate(stringBuffer.toString(), 32672);
            }
        }
        return "";
    }

    @Override
    public boolean wasNull() {
        return false;
    }
}

