/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.metadata;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavassistHelper {
    private static final Logger logger = LoggerFactory.getLogger(JavassistHelper.class);

    public static ClassFile readFile(TFile file) {
        try {
            TFileInputStream tFileInputStream = new TFileInputStream((File)file);
            return JavassistHelper.readFromInputStream((InputStream)tFileInputStream);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not find file: " + file, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read file: " + file, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFile readFromInputStream(InputStream is) throws IOException {
        ClassFile classFile;
        if (is == null) {
            throw new IllegalArgumentException("Cannot read from a null inputstream");
        }
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(is));
            classFile = new ClassFile(in);
        }
        catch (Throwable throwable) {
            JavassistHelper.closeQuietly(in);
            throw throwable;
        }
        JavassistHelper.closeQuietly(in);
        return classFile;
    }

    public static List<String> getTypeAnnotations(ClassFile file) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)file.getAttribute("RuntimeVisibleAnnotations");
        return JavassistHelper.readAnnotations(attribute);
    }

    private static List<String> readAnnotations(AnnotationsAttribute attribute) {
        if (attribute == null) {
            return new ArrayList<String>();
        }
        Annotation[] annotations = attribute.getAnnotations();
        ArrayList<String> anns = new ArrayList<String>();
        for (Annotation annotation : annotations) {
            anns.add(annotation.getTypeName());
        }
        return anns;
    }

    public static List<String> getMethodAnnotations(MethodInfo method) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)method.getAttribute("RuntimeVisibleAnnotations");
        return JavassistHelper.readAnnotations(attribute);
    }

    public static List<String> getFieldAnnotations(FieldInfo field) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)field.getAttribute("RuntimeVisibleAnnotations");
        return JavassistHelper.readAnnotations(attribute);
    }

    public static void closeQuietly(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            logger.warn("IOException when closing Closeable", (Throwable)e);
        }
    }
}

