/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.validator;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.security.User;
import com.xebialabs.xlplatform.security.dto.PasswordValidationResult;
import com.xebialabs.xlplatform.security.validator.Invalid;
import com.xebialabs.xlplatform.security.validator.StringValidator;
import com.xebialabs.xlplatform.security.validator.Valid;
import com.xebialabs.xlplatform.security.validator.ValidationResult;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Component
@ScalaSignature(bytes="\u0006\u0005]4A!\u0003\u0006\u0001+!AA\u0004\u0001BC\u0002\u0013\u0005Q\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003\u001f\u0011\u00159\u0003\u0001\"\u0001)\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015q\u0005\u0001\"\u0001R\u0011\u0015y\u0006\u0001\"\u0001a\u00055)6/\u001a:WC2LG-\u0019;pe*\u00111\u0002D\u0001\nm\u0006d\u0017\u000eZ1u_JT!!\u0004\b\u0002\u0011M,7-\u001e:jifT!a\u0004\t\u0002\u0011\u0011,\u0007\u000f\\8zSRT!!\u0005\n\u0002\u0013a,'-[1mC\n\u001c(\"A\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-A\tqCN\u001cxo\u001c:e-\u0006d\u0017\u000eZ1u_J,\u0012A\b\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003\u0017\u0005R!!\u0004\u0012\u000b\u0005\r\u0002\u0012A\u0003=ma2\fGOZ8s[&\u0011Q\u0005\t\u0002\u0010'R\u0014\u0018N\\4WC2LG-\u0019;pe\u0006\u0011\u0002/Y:to>\u0014HMV1mS\u0012\fGo\u001c:!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011f\u000b\t\u0003U\u0001i\u0011A\u0003\u0005\u00069\r\u0001\rA\b\u0015\u0003\u00075\u0002\"AL\u001d\u000e\u0003=R!\u0001M\u0019\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u00023g\u00059a-Y2u_JL(B\u0001\u001b6\u0003\u0015\u0011W-\u00198t\u0015\t1t'A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005A\u0014aA8sO&\u0011!h\f\u0002\n\u0003V$xn^5sK\u0012\fQa\u00195fG.$\"!\u0010!\u0011\u0005]q\u0014BA \u0019\u0005\u0011)f.\u001b;\t\u000b\u0005#\u0001\u0019\u0001\"\u0002\tU\u001cXM\u001d\t\u0003\u0007&k\u0011\u0001\u0012\u0006\u0003\u001b\u0015S!AR$\u0002\u0007\u0005\u0004\u0018N\u0003\u0002I\u001d\u00051QM\\4j]\u0016L!A\u0013#\u0003\tU\u001bXM]\u0001\u000eG\",7m[+tKJt\u0015-\\3\u0015\u0005uj\u0005\"B!\u0006\u0001\u0004\u0011\u0015!D2iK\u000e\\\u0007+Y:to>\u0014H\r\u0006\u0002>!\")\u0011I\u0002a\u0001\u0005R\u0011QH\u0015\u0005\u0006'\u001e\u0001\r\u0001V\u0001\ta\u0006\u001c8o^8sIB\u0011Q\u000b\u0018\b\u0003-j\u0003\"a\u0016\r\u000e\u0003aS!!\u0017\u000b\u0002\rq\u0012xn\u001c;?\u0013\tY\u0006$\u0001\u0004Qe\u0016$WMZ\u0005\u0003;z\u0013aa\u0015;sS:<'BA.\u0019\u0003A1\u0018\r\\5eCR,\u0007+Y:to>\u0014H\r\u0006\u0002b_B\u0019!mZ5\u000e\u0003\rT!\u0001Z3\u0002\tU$\u0018\u000e\u001c\u0006\u0002M\u0006!!.\u0019<b\u0013\tA7M\u0001\u0003MSN$\bC\u00016n\u001b\u0005Y'B\u00017\"\u0003\r!Go\\\u0005\u0003].\u0014\u0001\u0004U1tg^|'\u000f\u001a,bY&$\u0017\r^5p]J+7/\u001e7u\u0011\u0015\u0019\u0006\u00021\u0001UQ\t\u0001\u0011\u000f\u0005\u0002sk6\t1O\u0003\u0002uk\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\u0005Y\u001c(!C\"p[B|g.\u001a8u\u0001")
public class UserValidator {
    private final StringValidator passwordValidator;

    public StringValidator passwordValidator() {
        return this.passwordValidator;
    }

    public void check(User user) {
        Checks.checkNotNull((Object)user, (String)"User can not be null.", (Object[])new Object[]{""});
        this.checkUserName(user);
        this.checkPassword(user);
    }

    public void checkUserName(User user) {
        Checks.checkArgument((!StringUtils.isBlank((String)user.getUsername()) ? 1 : 0) != 0, (String)"User name cannot be empty.", (Object[])new Object[0]);
        Pattern pattern = Pattern.compile("^(?![\\.\\-_])(?!.*[\\.\\-_]{2})[\\w\\.\\-_]*[^\\W_]$", 256);
        Matcher matcher = pattern.matcher(user.getUsername());
        Checks.checkArgument((boolean)matcher.matches(), (String)"All the alphanumeric characters and the special characters dash (-), underscore (_), and dot (.) are allowed. The special characters cannot be repeated more than once in a row. The username must not start or end with a special character.", (Object[])new Object[0]);
    }

    public void checkPassword(User user) {
        Checks.checkArgument((!StringUtils.isBlank((String)user.getPassword()) ? 1 : 0) != 0, (String)"Password is required when creating a user.", (Object[])new Object[0]);
        this.checkPassword(user.getPassword());
    }

    public void checkPassword(String password) {
        List invalids = this.passwordValidator().validate(password).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UserValidator.$anonfun$checkPassword$1(x$1)));
        if (invalids.nonEmpty()) {
            throw new Checks.IncorrectArgumentException(((IterableOnceOps)((IterableOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Password needs to meet following requirements:"}))).$plus$plus((IterableOnce)invalids.map((Function1 & Serializable)x$2 -> x$2.message()))).mkString(System.lineSeparator() + "\t"), new Object[0]);
        }
    }

    public java.util.List<PasswordValidationResult> validatePassword(String password) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.passwordValidator().validate(password).map((Function1 & Serializable)vr -> new PasswordValidationResult(vr instanceof Valid, vr.message())).sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isValid()), Ordering.Boolean$.MODULE$.reverse())).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$checkPassword$1(ValidationResult x$1) {
        return x$1 instanceof Invalid;
    }

    @Autowired
    public UserValidator(StringValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }
}

