/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.repository.sql;

import com.xebialabs.plugin.manager.repository.sql.CommonDialect;
import com.xebialabs.plugin.manager.repository.sql.CommonDialect$;
import com.xebialabs.plugin.manager.repository.sql.Db2Dialect;
import com.xebialabs.plugin.manager.repository.sql.DerbyDialect;
import com.xebialabs.plugin.manager.repository.sql.Dialect;
import com.xebialabs.plugin.manager.repository.sql.MsSqlDialect;
import com.xebialabs.plugin.manager.repository.sql.MySqlDialect;
import com.xebialabs.plugin.manager.repository.sql.OracleDialect;
import com.xebialabs.plugin.manager.repository.sql.PostgresDialect;
import java.io.Serializable;
import org.springframework.jdbc.core.JdbcTemplate;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

public final class Dialect$ {
    public static final Dialect$ MODULE$ = new Dialect$();
    private static final UnanchoredRegex Oracle = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(oracle)")).unanchored();
    private static final UnanchoredRegex MySQL = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(mysql)")).unanchored();
    private static final UnanchoredRegex PostgreSQL = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(postgresql)")).unanchored();
    private static final UnanchoredRegex DB2 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(db2)")).unanchored();
    private static final UnanchoredRegex MSSQL = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(sql server)")).unanchored();
    private static final UnanchoredRegex H2 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(h2)")).unanchored();
    private static final UnanchoredRegex Derby = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(derby)")).unanchored();

    public UnanchoredRegex Oracle() {
        return Oracle;
    }

    public UnanchoredRegex MySQL() {
        return MySQL;
    }

    public UnanchoredRegex PostgreSQL() {
        return PostgreSQL;
    }

    public UnanchoredRegex DB2() {
        return DB2;
    }

    public UnanchoredRegex MSSQL() {
        return MSSQL;
    }

    public UnanchoredRegex H2() {
        return H2;
    }

    public UnanchoredRegex Derby() {
        return Derby;
    }

    public Dialect apply(JdbcTemplate jdbcTemplate) {
        return (Dialect)Using$.MODULE$.apply((Function0 & Serializable)() -> jdbcTemplate.getDataSource().getConnection(), (Function1 & Serializable)connection -> {
            Option option;
            Option option2;
            Option option3;
            Option option4;
            Option option5;
            Option option6;
            CommonDialect commonDialect;
            Option option7;
            String productName = connection.getMetaData().getDatabaseProductName().toLowerCase();
            String string = productName;
            if (string != null && !(option7 = ((Regex)MODULE$.PostgreSQL()).unapplySeq((CharSequence)string)).isEmpty() && option7.get() != null && ((List)option7.get()).lengthCompare(1) == 0) {
                commonDialect = new PostgresDialect();
            } else if (string != null && !(option6 = ((Regex)MODULE$.MSSQL()).unapplySeq((CharSequence)string)).isEmpty() && option6.get() != null && ((List)option6.get()).lengthCompare(1) == 0) {
                commonDialect = new MsSqlDialect();
            } else if (string != null && !(option5 = ((Regex)MODULE$.MySQL()).unapplySeq((CharSequence)string)).isEmpty() && option5.get() != null && ((List)option5.get()).lengthCompare(1) == 0) {
                commonDialect = new MySqlDialect();
            } else if (string != null && !(option4 = ((Regex)MODULE$.DB2()).unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(1) == 0) {
                commonDialect = new Db2Dialect();
            } else if (string != null && !(option3 = ((Regex)MODULE$.Oracle()).unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(1) == 0) {
                commonDialect = new OracleDialect();
            } else if (string != null && !(option2 = ((Regex)MODULE$.Derby()).unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
                commonDialect = new DerbyDialect();
            } else if (string != null && !(option = ((Regex)MODULE$.H2()).unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                commonDialect = new CommonDialect(CommonDialect$.MODULE$.$lessinit$greater$default$1());
            } else {
                throw new IllegalArgumentException("Could not determine the correct dialect for product name: " + productName);
            }
            return commonDialect;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).get();
    }

    private Dialect$() {
    }
}

