/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.OpenSshServerKeyDatabase;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.transport.sshd.JGitKeyCache;
import org.eclipse.jgit.transport.sshd.KeyCache;
import org.eclipse.jgit.transport.sshd.ProxyData;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;
import org.springframework.cloud.config.server.ssh.KeyPairUtils;
import org.springframework.util.StringUtils;

public class PropertyBasedSshSessionFactory
extends SshdSessionFactory {
    private static final String STRICT_HOST_KEY_CHECKING = "StrictHostKeyChecking";
    private static final String PREFERRED_AUTHENTICATIONS = "PreferredAuthentications";
    private static final String YES_OPTION = "yes";
    private static final String NO_OPTION = "no";
    private final Map<String, JGitEnvironmentProperties> sshKeysByHostname;

    public PropertyBasedSshSessionFactory(Map<String, JGitEnvironmentProperties> sshKeysByHostname) {
        super((KeyCache)new JGitKeyCache(), (ProxyDataFactory)new HttpProxyDataFactory(sshKeysByHostname));
        this.sshKeysByHostname = sshKeysByHostname;
        assert (this.sshKeysByHostname.entrySet().size() > 0);
    }

    protected SshConfigStore createSshConfigStore(File homeDir, File configFile, String localUserName) {
        return new SshConfigStore(){

            public SshConfigStore.HostConfig lookup(@NonNull String hostName, int port, String userName) {
                OpenSshConfigFile.HostEntry hostEntry = new OpenSshConfigFile.HostEntry();
                return this.updateIfNeeded(hostEntry, hostName);
            }

            private OpenSshConfigFile.HostEntry updateIfNeeded(OpenSshConfigFile.HostEntry hostEntry, String hostName) {
                JGitEnvironmentProperties sshProperties = (JGitEnvironmentProperties)PropertyBasedSshSessionFactory.this.sshKeysByHostname.get(hostName);
                if (sshProperties == null) {
                    return hostEntry;
                }
                if (sshProperties.getHostKey() == null || !sshProperties.isStrictHostKeyChecking()) {
                    hostEntry.setValue(PropertyBasedSshSessionFactory.STRICT_HOST_KEY_CHECKING, PropertyBasedSshSessionFactory.NO_OPTION);
                } else {
                    hostEntry.setValue(PropertyBasedSshSessionFactory.STRICT_HOST_KEY_CHECKING, PropertyBasedSshSessionFactory.YES_OPTION);
                }
                String preferredAuthentications = sshProperties.getPreferredAuthentications();
                if (preferredAuthentications != null) {
                    hostEntry.setValue(PropertyBasedSshSessionFactory.PREFERRED_AUTHENTICATIONS, preferredAuthentications);
                }
                return hostEntry;
            }
        };
    }

    protected File getSshConfig(File dir) {
        return null;
    }

    protected ServerKeyDatabase getServerKeyDatabase(File homeDir, File dir) {
        return new ServerKeyDatabase(){

            public List<PublicKey> lookup(String connectAddress, InetSocketAddress remoteAddress, ServerKeyDatabase.Configuration config) {
                JGitEnvironmentProperties sshProperties = (JGitEnvironmentProperties)PropertyBasedSshSessionFactory.this.sshKeysByHostname.get(remoteAddress.getHostName());
                if (sshProperties == null) {
                    return Collections.emptyList();
                }
                List<Path> knownHostFiles = this.getKnownHostFiles(sshProperties);
                List publicKeys = new OpenSshServerKeyDatabase(false, knownHostFiles).lookup(connectAddress, remoteAddress, config);
                PublicKey publicKey = this.getHostKey(sshProperties);
                if (publicKey != null) {
                    publicKeys.add(publicKey);
                }
                return publicKeys;
            }

            public boolean accept(String connectAddress, InetSocketAddress remoteAddress, PublicKey serverKey, ServerKeyDatabase.Configuration config, CredentialsProvider provider) {
                if (this.isNotStrictHostKeyChecking(remoteAddress.getHostName())) {
                    return true;
                }
                List<PublicKey> knownServerKeys = this.lookup(connectAddress, remoteAddress, config);
                return KeyUtils.findMatchingKey((PublicKey)serverKey, knownServerKeys) != null;
            }

            private boolean isNotStrictHostKeyChecking(String hostName) {
                JGitEnvironmentProperties sshProperties = (JGitEnvironmentProperties)PropertyBasedSshSessionFactory.this.sshKeysByHostname.get(hostName);
                if (sshProperties == null) {
                    return false;
                }
                return !sshProperties.isStrictHostKeyChecking();
            }

            private PublicKey getHostKey(JGitEnvironmentProperties sshProperties) {
                String hostKey = sshProperties.getHostKey();
                String hostKeyAlgorithm = sshProperties.getHostKeyAlgorithm();
                if (!StringUtils.hasText((String)hostKey) || !StringUtils.hasText((String)hostKeyAlgorithm)) {
                    return null;
                }
                try {
                    return AuthorizedKeyEntry.parseAuthorizedKeyEntry((String)(hostKeyAlgorithm + " " + hostKey)).resolvePublicKey(null, null);
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            }

            private List<Path> getKnownHostFiles(JGitEnvironmentProperties sshProperties) {
                if (sshProperties.getKnownHostsFile() == null) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(Paths.get(sshProperties.getKnownHostsFile(), new String[0]));
            }
        };
    }

    protected Iterable<KeyPair> getDefaultKeys(File dir) {
        return new SingleKeyIdentityProvider(this.sshKeysByHostname);
    }

    private static final class HttpProxyDataFactory
    implements ProxyDataFactory {
        private final Map<String, JGitEnvironmentProperties> sshKeysByHostname;

        private HttpProxyDataFactory(Map<String, JGitEnvironmentProperties> sshKeysByHostname) {
            this.sshKeysByHostname = sshKeysByHostname;
        }

        public ProxyData get(InetSocketAddress remoteAddress) {
            JGitEnvironmentProperties sshProperties = this.sshKeysByHostname.get(remoteAddress.getHostName());
            ProxyHostProperties proxyHostProperties = sshProperties.getProxy().get((Object)ProxyHostProperties.ProxyForScheme.HTTP);
            if (proxyHostProperties == null || !proxyHostProperties.connectionInformationProvided()) {
                return null;
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHostProperties.getHost(), proxyHostProperties.getPort()));
            return new ProxyData(proxy, proxyHostProperties.getUsername(), proxyHostProperties.getPassword().toCharArray());
        }
    }

    private static final class SingleKeyIdentityProvider
    implements KeyIdentityProvider,
    Iterable<KeyPair> {
        private final Map<String, JGitEnvironmentProperties> sshKeysByHostname;

        private SingleKeyIdentityProvider(Map<String, JGitEnvironmentProperties> sshKeysByHostname) {
            this.sshKeysByHostname = sshKeysByHostname;
        }

        @Override
        public Iterator<KeyPair> iterator() {
            throw new UnsupportedOperationException("Should not be called");
        }

        public Iterable<KeyPair> loadKeys(SessionContext session) throws IOException, GeneralSecurityException {
            SshdSocketAddress remoteAddress = SshdSocketAddress.toSshdSocketAddress((SocketAddress)session.getRemoteAddress());
            JGitEnvironmentProperties sshProperties = this.sshKeysByHostname.get(remoteAddress.getHostName());
            return sshProperties == null ? Collections.emptyList() : KeyPairUtils.load(session, sshProperties.getPrivateKey());
        }
    }
}

