/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.audit;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.engine.spi.event.LoginEvent;
import com.xebialabs.deployit.engine.spi.event.LogoutEvent;
import com.xebialabs.deployit.engine.spi.event.UnsuccessfulLoginEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.LogoutSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationEventListener
implements ApplicationListener<AbstractAuthenticationEvent> {
    public void onApplicationEvent(AbstractAuthenticationEvent event) {
        Authentication authentication = event.getAuthentication();
        if (null != authentication && Strings.isNotEmpty((String)authentication.getName())) {
            String username = event.getAuthentication().getName();
            if (event instanceof AuthenticationFailureBadCredentialsEvent) {
                EventBusHolder.publish((Object)new UnsuccessfulLoginEvent(username));
            } else if (event instanceof AuthenticationSuccessEvent) {
                EventBusHolder.publish((Object)new LoginEvent(username));
            } else if (event instanceof LogoutSuccessEvent) {
                EventBusHolder.publish((Object)new LogoutEvent(username));
            }
        }
    }
}

