/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym.change;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.DropSynonymStatement;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class DropSynonymGenerator
extends AbstractSqlGenerator<DropSynonymStatement> {
    @Override
    public boolean supports(DropSynonymStatement dropSynonymStatement, Database database) {
        return (database instanceof OracleDatabase || database instanceof AbstractDb2Database || database instanceof MSSQLDatabase || database instanceof EnterpriseDBDatabase) && super.supports(dropSynonymStatement, database);
    }

    @Override
    public ValidationErrors validate(DropSynonymStatement dropSynonymStatement, Database database, SqlGeneratorChain object) {
        object = new ValidationErrors();
        ((ValidationErrors)object).checkRequiredField("synonymName", dropSynonymStatement.getSynonymName());
        ((ValidationErrors)object).checkDisallowedField("synonymCatalogName", dropSynonymStatement.getSynonymCatalogName(), database, MSSQLDatabase.class);
        if (!(dropSynonymStatement.isPrivate() != null && dropSynonymStatement.isPrivate().booleanValue() || database instanceof MSSQLDatabase || dropSynonymStatement.getSynonymCatalogName() == null && dropSynonymStatement.getSynonymSchemaName() == null)) {
            ((ValidationErrors)object).addError("Cannot specify schema name for non-private synonyms");
        }
        if (database instanceof DB2Database) {
            ((ValidationErrors)object).checkRequiredField("objectType", dropSynonymStatement.getObjectType());
        }
        return object;
    }

    @Override
    public Warnings warn(DropSynonymStatement dropSynonymStatement, Database database, SqlGeneratorChain object) {
        object = super.warn(dropSynonymStatement, database, object);
        if (database instanceof MSSQLDatabase && dropSynonymStatement.isPrivate() != null && dropSynonymStatement.isPrivate().booleanValue()) {
            ((Warnings)object).addWarning("MSSQL does not support public synonyms. Dropping private synonym " + dropSynonymStatement.getSynonymName());
        }
        return object;
    }

    @Override
    public Sql[] generateSql(DropSynonymStatement object, Database sqlArray, SqlGeneratorChain object2) {
        object2 = sqlArray instanceof MSSQLDatabase ? sqlArray.escapeObjectName(null, ((DropSynonymStatement)object).getSynonymSchemaName(), ((DropSynonymStatement)object).getSynonymName(), Synonym.class) : (((DropSynonymStatement)object).isPrivate() == null || ((DropSynonymStatement)object).isPrivate() == false ? sqlArray.escapeObjectName(((DropSynonymStatement)object).getSynonymName(), Synonym.class) : sqlArray.escapeObjectName(((DropSynonymStatement)object).getSynonymCatalogName(), ((DropSynonymStatement)object).getSynonymSchemaName(), ((DropSynonymStatement)object).getSynonymName(), Synonym.class));
        StringBuilder stringBuilder = new StringBuilder("DROP ");
        if (!(!(sqlArray instanceof OracleDatabase) && !(sqlArray instanceof AbstractDb2Database) || ((DropSynonymStatement)object).isPrivate() != null && ((DropSynonymStatement)object).isPrivate().booleanValue())) {
            stringBuilder.append("PUBLIC ");
        }
        if (sqlArray instanceof AbstractDb2Database) {
            stringBuilder.append("ALIAS ");
        } else {
            stringBuilder.append("SYNONYM ");
        }
        stringBuilder.append((String)object2);
        object = new ArrayList<UnparsedSql>();
        object.add(new UnparsedSql(stringBuilder.toString(), new DatabaseObject[0]));
        sqlArray = new Sql[object.size()];
        return object.toArray(sqlArray);
    }
}

