/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.util.Map;
import java.util.concurrent.Callable;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.boot.internal.LegacyModifiedColumnNamingStrategy;
import org.hibernate.envers.boot.spi.ModifiedColumnNamingStrategy;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class GlobalConfiguration {
    private final EnversService enversService;
    private final boolean generateRevisionsForCollections;
    private final boolean doNotAuditOptimisticLockingField;
    private final boolean storeDataAtDelete;
    private final String defaultSchemaName;
    private final String defaultCatalogName;
    private boolean trackEntitiesChangedInRevision;
    private final Class<? extends RevisionListener> revisionListenerClass;
    private boolean globalWithModifiedFlag;
    private boolean hasGlobalSettingForWithModifiedFlag;
    private String modifiedFlagSuffix;
    private final boolean useRevisionEntityWithNativeId;
    private final boolean cascadeDeleteRevision;
    private final boolean allowIdentifierReuse;
    private final boolean findByRevisionExactMatch;
    private final String correlatedSubqueryOperator;
    private final ModifiedColumnNamingStrategy modifiedColumnNamingStrategy;

    public GlobalConfiguration(EnversService enversService, Map properties) {
        this.enversService = enversService;
        final StrategySelector strategySelector = (StrategySelector)enversService.getServiceRegistry().getService(StrategySelector.class);
        this.generateRevisionsForCollections = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.revision_on_collection_change", (Map)properties, (boolean)true);
        this.doNotAuditOptimisticLockingField = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.do_not_audit_optimistic_locking_field", (Map)properties, (boolean)true);
        this.storeDataAtDelete = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.store_data_at_delete", (Map)properties, (boolean)false);
        this.defaultSchemaName = (String)properties.get("org.hibernate.envers.default_schema");
        this.defaultCatalogName = (String)properties.get("org.hibernate.envers.default_catalog");
        this.correlatedSubqueryOperator = HSQLDialect.class.getName().equals(properties.get("hibernate.dialect")) ? "in" : "=";
        this.trackEntitiesChangedInRevision = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.track_entities_changed_in_revision", (Map)properties, (boolean)false);
        this.cascadeDeleteRevision = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.cascade_delete_revision", (Map)properties, (boolean)false);
        this.useRevisionEntityWithNativeId = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.use_revision_entity_with_native_id", (Map)properties, (boolean)true);
        this.hasGlobalSettingForWithModifiedFlag = properties.get("org.hibernate.envers.global_with_modified_flag") != null;
        this.globalWithModifiedFlag = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.global_with_modified_flag", (Map)properties, (boolean)false);
        this.modifiedFlagSuffix = ConfigurationHelper.getString((String)"org.hibernate.envers.modified_flag_suffix", (Map)properties, (String)"_MOD");
        String revisionListenerClassName = (String)properties.get("org.hibernate.envers.revision_listener");
        if (revisionListenerClassName != null) {
            try {
                this.revisionListenerClass = ReflectionTools.loadClass(revisionListenerClassName, enversService.getClassLoaderService());
            }
            catch (ClassLoadingException e) {
                throw new MappingException("Revision listener class not found: " + revisionListenerClassName + ".", (Throwable)e);
            }
        } else {
            this.revisionListenerClass = null;
        }
        this.modifiedColumnNamingStrategy = (ModifiedColumnNamingStrategy)strategySelector.resolveDefaultableStrategy(ModifiedColumnNamingStrategy.class, properties.get("org.hibernate.envers.modified_column_naming_strategy"), (Callable)new Callable<ModifiedColumnNamingStrategy>(){

            @Override
            public ModifiedColumnNamingStrategy call() throws Exception {
                return (ModifiedColumnNamingStrategy)strategySelector.resolveDefaultableStrategy(ModifiedColumnNamingStrategy.class, (Object)"default", (Object)new LegacyModifiedColumnNamingStrategy());
            }
        });
        this.allowIdentifierReuse = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.allow_identifier_reuse", (Map)properties, (boolean)false);
        this.findByRevisionExactMatch = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.find_by_revision_exact_match", (Map)properties, (boolean)false);
    }

    public EnversService getEnversService() {
        return this.enversService;
    }

    public boolean isGenerateRevisionsForCollections() {
        return this.generateRevisionsForCollections;
    }

    public boolean isDoNotAuditOptimisticLockingField() {
        return this.doNotAuditOptimisticLockingField;
    }

    public String getCorrelatedSubqueryOperator() {
        return this.correlatedSubqueryOperator;
    }

    public boolean isStoreDataAtDelete() {
        return this.storeDataAtDelete;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    public boolean isTrackEntitiesChangedInRevision() {
        return this.trackEntitiesChangedInRevision;
    }

    public void setTrackEntitiesChangedInRevision(boolean trackEntitiesChangedInRevision) {
        this.trackEntitiesChangedInRevision = trackEntitiesChangedInRevision;
    }

    public Class<? extends RevisionListener> getRevisionListenerClass() {
        return this.revisionListenerClass;
    }

    public boolean hasSettingForUsingModifiedFlag() {
        return this.hasGlobalSettingForWithModifiedFlag;
    }

    public boolean isGlobalWithModifiedFlag() {
        return this.globalWithModifiedFlag;
    }

    public String getModifiedFlagSuffix() {
        return this.modifiedFlagSuffix;
    }

    public boolean isUseRevisionEntityWithNativeId() {
        return this.useRevisionEntityWithNativeId;
    }

    public boolean isCascadeDeleteRevision() {
        return this.cascadeDeleteRevision;
    }

    public boolean isAllowIdentifierReuse() {
        return this.allowIdentifierReuse;
    }

    public boolean isAuditReaderFindAtRevisionExactMatch() {
        return this.findByRevisionExactMatch;
    }

    public ModifiedColumnNamingStrategy getModifiedColumnNamingStrategy() {
        return this.modifiedColumnNamingStrategy;
    }
}

