/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Fetch;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Limit;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Offset;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectBody;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperation;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithIsolation;

public class SetOperationList
implements SelectBody {
    private List<SelectBody> selects;
    private List<Boolean> brackets;
    private List<SetOperation> operations;
    private List<OrderByElement> orderByElements;
    private Limit limit;
    private Offset offset;
    private Fetch fetch;
    private WithIsolation withIsolation;

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public List<SelectBody> getSelects() {
        return this.selects;
    }

    public void setSelects(List<SelectBody> list) {
        this.selects = list;
    }

    public void setOperations(List<SetOperation> list) {
        this.operations = list;
    }

    public List<SetOperation> getOperations() {
        return this.operations;
    }

    public List<Boolean> getBrackets() {
        return this.brackets;
    }

    public void setBrackets(List<Boolean> list) {
        this.brackets = list;
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public void setBracketsOpsAndSelects(List<Boolean> list, List<SelectBody> list2, List<SetOperation> list3) {
        this.selects = list2;
        this.operations = list3;
        this.brackets = list;
        if (list2.size() - 1 != list3.size() || list2.size() != list.size()) {
            throw new IllegalArgumentException("list sizes are not valid");
        }
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public WithIsolation getWithIsolation() {
        return this.withIsolation;
    }

    public void setWithIsolation(WithIsolation withIsolation) {
        this.withIsolation = withIsolation;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.selects.size(); ++i2) {
            if (i2 != 0) {
                stringBuilder.append(" ").append(this.operations.get(i2 - 1).toString()).append(" ");
            }
            if (this.brackets == null || this.brackets.get(i2).booleanValue()) {
                stringBuilder.append("(").append(this.selects.get(i2).toString()).append(")");
                continue;
            }
            stringBuilder.append(this.selects.get(i2).toString());
        }
        if (this.orderByElements != null) {
            stringBuilder.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            stringBuilder.append(this.limit.toString());
        }
        if (this.offset != null) {
            stringBuilder.append(this.offset.toString());
        }
        if (this.fetch != null) {
            stringBuilder.append(this.fetch.toString());
        }
        if (this.withIsolation != null) {
            stringBuilder.append(this.withIsolation.toString());
        }
        return stringBuilder.toString();
    }

    public SetOperationList withOperations(List<SetOperation> list) {
        this.setOperations(list);
        return this;
    }

    public SetOperationList withSelects(List<SelectBody> list) {
        this.setSelects(list);
        return this;
    }

    public SetOperationList withBrackets(List<Boolean> list) {
        this.setBrackets(list);
        return this;
    }

    public SetOperationList withOrderByElements(List<OrderByElement> list) {
        this.setOrderByElements(list);
        return this;
    }

    public SetOperationList withLimit(Limit limit) {
        this.setLimit(limit);
        return this;
    }

    public SetOperationList withOffset(Offset offset) {
        this.setOffset(offset);
        return this;
    }

    public SetOperationList withFetch(Fetch fetch) {
        this.setFetch(fetch);
        return this;
    }

    public SetOperationList addSelects(SelectBody ... selectBodyArray) {
        List list = Optional.ofNullable(this.getSelects()).orElseGet(ArrayList::new);
        Collections.addAll(list, selectBodyArray);
        return this.withSelects(list);
    }

    public SetOperationList addSelects(Collection<? extends SelectBody> collection) {
        List list = Optional.ofNullable(this.getSelects()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withSelects(list);
    }

    public SetOperationList addOperations(SetOperation ... setOperationArray) {
        List list = Optional.ofNullable(this.getOperations()).orElseGet(ArrayList::new);
        Collections.addAll(list, setOperationArray);
        return this.withOperations(list);
    }

    public SetOperationList addOperations(Collection<? extends SetOperation> collection) {
        List list = Optional.ofNullable(this.getOperations()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withOperations(list);
    }

    public SetOperationList addBrackets(Boolean ... booleanArray) {
        List list = Optional.ofNullable(this.getBrackets()).orElseGet(ArrayList::new);
        Collections.addAll(list, booleanArray);
        return this.withBrackets(list);
    }

    public SetOperationList addBrackets(Collection<Boolean> collection) {
        List list = Optional.ofNullable(this.getBrackets()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withBrackets(list);
    }

    public SetOperationList addOrderByElements(OrderByElement ... orderByElementArray) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(list, orderByElementArray);
        return this.withOrderByElements(list);
    }

    public SetOperationList addOrderByElements(Collection<? extends OrderByElement> collection) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withOrderByElements(list);
    }
}

