/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.spring;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.AbstractResourceAccessor;
import liquibase.resource.InputStreamList;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;

public class SpringResourceAccessor
extends AbstractResourceAccessor {
    private final ResourceLoader resourceLoader;
    private final DefaultResourceLoader fallbackResourceLoader;

    public SpringResourceAccessor(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.fallbackResourceLoader = resourceLoader == null ? new DefaultResourceLoader(Thread.currentThread().getContextClassLoader()) : new DefaultResourceLoader(resourceLoader.getClassLoader());
    }

    @Override
    public SortedSet<String> list(String relativeTo, String path, boolean recursive, boolean includeFiles, boolean includeDirectories) throws IOException {
        String searchPath = this.getCompletePath(relativeTo, path);
        searchPath = recursive ? searchPath + "/**" : searchPath + "/*";
        searchPath = this.finalizeSearchPath(searchPath);
        Resource[] resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources(searchPath);
        TreeSet<String> returnSet = new TreeSet<String>();
        for (Resource resource : resources) {
            boolean isFile = this.resourceIsFile(resource);
            if (isFile && includeFiles) {
                returnSet.add(this.getResourcePath(resource));
            }
            if (isFile || !includeDirectories) continue;
            returnSet.add(this.getResourcePath(resource));
        }
        return returnSet;
    }

    @Override
    public SortedSet<String> describeLocations() {
        TreeSet<String> returnSet = new TreeSet<String>();
        ClassLoader classLoader = this.resourceLoader.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                returnSet.add(url.toExternalForm());
            }
        } else {
            returnSet.add("Spring resources");
        }
        return returnSet;
    }

    @Override
    public InputStreamList openStreams(String relativeTo, String streamPath) throws IOException {
        String searchPath = this.getCompletePath(relativeTo, streamPath);
        searchPath = this.finalizeSearchPath(searchPath);
        Resource[] resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources(searchPath);
        InputStreamList returnList = new InputStreamList();
        for (Resource foundResource : resources) {
            try {
                returnList.add(foundResource.getURI(), foundResource.getInputStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return returnList;
    }

    protected String getResourcePath(Resource resource) {
        if (resource instanceof ContextResource) {
            return ((ContextResource)resource).getPathWithinContext();
        }
        if (resource instanceof ClassPathResource) {
            return ((ClassPathResource)resource).getPath();
        }
        try {
            String url = resource.getURL().toExternalForm();
            if (url.contains("!")) {
                return url.replaceFirst(".*!", "");
            }
            while (!this.getResource("classpath:" + url).exists()) {
                String newUrl = url.replaceFirst("^/?.*?/", "");
                if (newUrl.equals(url)) {
                    throw new UnexpectedLiquibaseException("Could determine path for " + resource.getURL().toExternalForm());
                }
                url = newUrl;
            }
            return url;
        }
        catch (IOException e2) {
            throw new UnexpectedLiquibaseException("Cannot determine resource path for " + resource.getDescription());
        }
    }

    protected String getCompletePath(String relativeTo, String path) throws IOException {
        Resource rootResource;
        boolean relativeIsFile;
        path = path.replace("\\", "/");
        String searchPath = relativeTo == null ? path : ((relativeIsFile = this.resourceIsFile(rootResource = this.getResource(relativeTo = relativeTo.replace("\\", "/")))) ? relativeTo.replaceFirst("/[^/]+$", "") + "/" + path : relativeTo + "/" + path);
        return searchPath;
    }

    protected Resource getResource(String resourcePath) {
        Resource defaultLoaderResource = this.fallbackResourceLoader.getResource(resourcePath);
        if (defaultLoaderResource.exists()) {
            return defaultLoaderResource;
        }
        return this.resourceLoader.getResource(resourcePath);
    }

    protected boolean resourceIsFile(Resource resource) throws IOException {
        if (resource.exists() && resource.isFile()) {
            return resource.getFile().isFile();
        }
        String filename = resource.getFilename();
        return filename != null && filename.contains(".");
    }

    protected String finalizeSearchPath(String searchPath) {
        searchPath = searchPath.replace("\\", "/");
        searchPath = searchPath.replaceAll("classpath\\*?:", "");
        searchPath = "/" + searchPath;
        searchPath = searchPath.replaceAll("//+", "/");
        searchPath = "classpath*:" + searchPath;
        return searchPath;
    }
}

