/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.vmplugin;

import java.math.BigDecimal;
import java.security.AccessController;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.groovy.util.Maps;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.vmplugin.VMPlugin;

public class VMPluginFactory {
    private static final Logger LOGGER = Logger.getLogger(VMPluginFactory.class.getName());
    private static final Map<BigDecimal, String> PLUGIN_MAP = Maps.of((Object)new BigDecimal("16"), (Object)"org.codehaus.groovy.vmplugin.v16.Java16", (Object)new BigDecimal("10"), (Object)"org.codehaus.groovy.vmplugin.v10.Java10", (Object)new BigDecimal("9"), (Object)"org.codehaus.groovy.vmplugin.v9.Java9", (Object)new BigDecimal("1.8"), (Object)"org.codehaus.groovy.vmplugin.v8.Java8");
    private static final VMPlugin PLUGIN = VMPluginFactory.createPlugin();

    public static VMPlugin getPlugin() {
        return PLUGIN;
    }

    private static VMPlugin createPlugin() {
        return AccessController.doPrivileged(() -> {
            BigDecimal specVer = new BigDecimal(VMPlugin.getJavaVersion());
            ClassLoader loader = VMPluginFactory.class.getClassLoader();
            for (Map.Entry<BigDecimal, String> entry : PLUGIN_MAP.entrySet()) {
                if (!DefaultGroovyMethods.isAtLeast(specVer, entry.getKey()).booleanValue()) continue;
                String pluginName = entry.getValue();
                try {
                    return (VMPlugin)loader.loadClass(pluginName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Trying to create VM plugin `" + pluginName + "`, but failed:\n" + DefaultGroovyMethods.asString(t));
                    }
                    return null;
                }
            }
            return null;
        });
    }
}

