/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.io.File;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQAddressExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQClusterSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQDeleteAddressException;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQDivertDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateMetaDataException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQIncompatibleClientServerException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidQueueConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached;
import org.apache.activemq.artemis.api.core.ActiveMQRedirectedException;
import org.apache.activemq.artemis.api.core.ActiveMQRemoteDisconnectException;
import org.apache.activemq.artemis.api.core.ActiveMQReplicationTimeooutException;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException;
import org.apache.activemq.artemis.api.core.ActiveMQUnexpectedRoutingTypeForAddress;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;

public class ActiveMQMessageBundle_$bundle
implements ActiveMQMessageBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQMessageBundle_$bundle INSTANCE = new ActiveMQMessageBundle_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected ActiveMQMessageBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String activationForServer$str() {
        return "AMQ229000: Activation for server {0}";
    }

    @Override
    public final String activationForServer(ActiveMQServer server) {
        return this._formatMessage(this.activationForServer$str(), server);
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String generatingThreadDump$str() {
        return "AMQ229001: Generating thread dump";
    }

    @Override
    public final String generatingThreadDump() {
        return this.generatingThreadDump$str();
    }

    protected String threadDump$str() {
        return "AMQ229002: Thread {0} name = {1} id = {2} group = {3}";
    }

    @Override
    public final String threadDump(Thread key, String name, Long id, ThreadGroup threadGroup) {
        return this._formatMessage(this.threadDump$str(), key, name, id, threadGroup);
    }

    protected String endThreadDump$str() {
        return "AMQ229003: End Thread dump";
    }

    @Override
    public final String endThreadDump() {
        return String.format(this.getLoggingLocale(), this.endThreadDump$str(), new Object[0]);
    }

    protected String serverDescribe$str() {
        return "AMQ229004: Information about server {0}\nCluster Connection:{1}";
    }

    @Override
    public final String serverDescribe(String identity, String describe) {
        return this._formatMessage(this.serverDescribe$str(), identity, describe);
    }

    protected String connectionsClosedByManagement$str() {
        return "AMQ229005: connections for {0} closed by management";
    }

    @Override
    public final ActiveMQInternalErrorException connectionsClosedByManagement(String ipAddress) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.connectionsClosedByManagement$str(), ipAddress));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String notJournalImpl$str() {
        return "AMQ229006: journals are not JournalImpl. You can''t set a replicator!";
    }

    @Override
    public final ActiveMQInternalErrorException notJournalImpl() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.notJournalImpl$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String replicationUnhandledError$str() {
        return "AMQ229007: unhandled error during replication";
    }

    @Override
    public final ActiveMQInternalErrorException replicationUnhandledError(Exception e) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.replicationUnhandledError$str(), new Object[0]), e);
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String replicationTooManyJournals$str() {
        return "AMQ229008: Live Node contains more journals than the backup node. Probably a version match error";
    }

    @Override
    public final ActiveMQInternalErrorException replicationTooManyJournals() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.replicationTooManyJournals$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String replicationUnhandledFileType$str() {
        return "AMQ229009: Unhandled file type {0}";
    }

    @Override
    public final ActiveMQInternalErrorException replicationUnhandledFileType(ReplicationSyncFileMessage.FileType fileType) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.replicationUnhandledFileType$str(), new Object[]{fileType}));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String replicationBackupUpToDate$str() {
        return "AMQ229010: Remote Backup can not be up-to-date!";
    }

    @Override
    public final ActiveMQInternalErrorException replicationBackupUpToDate() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.replicationBackupUpToDate$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String replicationUnhandledDataType$str() {
        return "AMQ229011: unhandled data type!";
    }

    @Override
    public final ActiveMQInternalErrorException replicationUnhandledDataType() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.replicationUnhandledDataType$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noBindingForDivert$str() {
        return "AMQ229012: No binding for divert {0}";
    }

    @Override
    public final ActiveMQInternalErrorException noBindingForDivert(SimpleString name) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.noBindingForDivert$str(), name));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String bindingNotDivert$str() {
        return "AMQ229013: Binding {0} is not a divert";
    }

    @Override
    public final ActiveMQInternalErrorException bindingNotDivert(SimpleString name) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.bindingNotDivert$str(), name));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String clientExited$str() {
        return "AMQ229014: Did not receive data from {0} within the {1}ms connection TTL. The connection will now be closed.";
    }

    @Override
    public final ActiveMQConnectionTimedOutException clientExited(String remoteAddress, long ttl) {
        ActiveMQConnectionTimedOutException result = new ActiveMQConnectionTimedOutException(this._formatMessage(this.clientExited$str(), remoteAddress, ttl));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String divertWithNoName$str() {
        return "AMQ229015: Must specify a name for each divert. This one will not be deployed.";
    }

    @Override
    public final ActiveMQInternalErrorException divertWithNoName() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this.divertWithNoName$str());
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noSuchQueue$str() {
        return "AMQ229017: Queue {0} does not exist";
    }

    @Override
    public final ActiveMQNonExistentQueueException noSuchQueue(SimpleString queueName) {
        ActiveMQNonExistentQueueException result = new ActiveMQNonExistentQueueException(this._formatMessage(this.noSuchQueue$str(), queueName));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String bindingAlreadyExists1$str() {
        return "AMQ229018: Binding already exists {0}";
    }

    @Override
    public final ActiveMQQueueExistsException bindingAlreadyExists(Binding binding) {
        ActiveMQQueueExistsException result = new ActiveMQQueueExistsException(this._formatMessage(this.bindingAlreadyExists1$str(), binding));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String queueAlreadyExists$str() {
        return "AMQ229019: Queue {0} already exists on address {1}";
    }

    @Override
    public final ActiveMQQueueExistsException queueAlreadyExists(SimpleString queueName, SimpleString addressName) {
        ActiveMQQueueExistsException result = new ActiveMQQueueExistsException(this._formatMessage(this.queueAlreadyExists$str(), queueName, addressName));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFilter$str() {
        return "AMQ229020: Invalid filter: {0}";
    }

    @Override
    public final ActiveMQInvalidFilterExpressionException invalidFilter(Throwable e, SimpleString filter) {
        ActiveMQInvalidFilterExpressionException result = new ActiveMQInvalidFilterExpressionException(this._formatMessage(this.invalidFilter$str(), filter));
        result.initCause(e);
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String messageIdNotAssigned$str() {
        return "AMQ229021: MessageId was not assigned to Message";
    }

    @Override
    public final ActiveMQIllegalStateException messageIdNotAssigned() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.messageIdNotAssigned$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String journalsNotInSync$str() {
        return "AMQ229022: Cannot compare journals if not in sync!";
    }

    @Override
    public final ActiveMQIllegalStateException journalsNotInSync() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.journalsNotInSync$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String serverNotBackupServer$str() {
        return "AMQ229023: Connected server is not a backup server";
    }

    @Override
    public final ActiveMQIllegalStateException serverNotBackupServer() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.serverNotBackupServer$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String alreadyHaveReplicationServer$str() {
        return "AMQ229024: Backup replication server is already connected to another server";
    }

    @Override
    public final ActiveMQIllegalStateException alreadyHaveReplicationServer() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.alreadyHaveReplicationServer$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotDeleteQueueWithConsumers$str() {
        return "AMQ229025: Cannot delete queue {0} on binding {1} - it has consumers = {2}";
    }

    @Override
    public final ActiveMQIllegalStateException cannotDeleteQueueWithConsumers(SimpleString name, SimpleString queueName, String s) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.cannotDeleteQueueWithConsumers$str(), name, queueName, s));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String backupServerNotInSync$str() {
        return "AMQ229026: Backup Server was not yet in sync with live";
    }

    @Override
    public final ActiveMQIllegalStateException backupServerNotInSync() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.backupServerNotInSync$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String consumerNoReference$str() {
        return "AMQ229027: Could not find reference on consumer ID={0}, messageId = {1} queue = {2}";
    }

    @Override
    public final ActiveMQIllegalStateException consumerNoReference(Long id, Long messageID, SimpleString name) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.consumerNoReference$str(), id, messageID, name));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String consumerDoesntExist$str() {
        return "AMQ229028: Consumer {0} doesn''t exist on the server";
    }

    @Override
    public final ActiveMQIllegalStateException consumerDoesntExist(long consumerID) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.consumerDoesntExist$str(), consumerID));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noAddress$str() {
        return "AMQ229029: No address configured on the Server''s Session";
    }

    @Override
    public final ActiveMQIllegalStateException noAddress() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.noAddress$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String largeMessageNotInitialised$str() {
        return "AMQ229030: large-message not initialized on server";
    }

    @Override
    public final ActiveMQIllegalStateException largeMessageNotInitialised() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.largeMessageNotInitialised$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToValidateUser$str() {
        return "AMQ229031: Unable to validate user from {0}. Username: {1}; SSL certificate subject DN: {2}";
    }

    @Override
    public final ActiveMQSecurityException unableToValidateUser(String remoteAddress, String user, String certMessage) {
        ActiveMQSecurityException result = new ActiveMQSecurityException(this._formatMessage(this.unableToValidateUser$str(), remoteAddress, user, certMessage));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String userNoPermissions$str() {
        return "AMQ229032: User: {0} does not have permission=''{1}'' on address {2}";
    }

    @Override
    public final ActiveMQSecurityException userNoPermissions(String username, CheckType checkType, SimpleString address) {
        ActiveMQSecurityException result = new ActiveMQSecurityException(this._formatMessage(this.userNoPermissions$str(), new Object[]{username, checkType, address}));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompatibleClientServer$str() {
        return "AMQ229033: Server and client versions incompatible";
    }

    @Override
    public final ActiveMQIncompatibleClientServerException incompatibleClientServer() {
        ActiveMQIncompatibleClientServerException result = new ActiveMQIncompatibleClientServerException(String.format(this.getLoggingLocale(), this.incompatibleClientServer$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String serverNotStarted$str() {
        return "AMQ229034: Server not started";
    }

    @Override
    public final ActiveMQSessionCreationException serverNotStarted() {
        ActiveMQSessionCreationException result = new ActiveMQSessionCreationException(String.format(this.getLoggingLocale(), this.serverNotStarted$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateMetadata$str() {
        return "AMQ229035: Metadata {0}={1} had been set already";
    }

    @Override
    public final ActiveMQDuplicateMetaDataException duplicateMetadata(String key, String data) {
        ActiveMQDuplicateMetaDataException result = new ActiveMQDuplicateMetaDataException(this._formatMessage(this.duplicateMetadata$str(), key, data));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidType$str() {
        return "AMQ229036: Invalid type: {0}";
    }

    @Override
    public final IllegalArgumentException invalidType(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidType$str(), type));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String emptyOrNull$str() {
        return "AMQ229038: {0} must neither be null nor empty";
    }

    @Override
    public final IllegalArgumentException emptyOrNull(String name) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.emptyOrNull$str(), name));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String greaterThanZero2$str() {
        return "AMQ229039: {0}  must be greater than 0 (actual value: {1})";
    }

    @Override
    public final IllegalArgumentException greaterThanZero(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.greaterThanZero2$str(), name, val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notPercent$str() {
        return "AMQ229040: {0} must be a valid percentual value between 0 and 100 (actual value: {1})";
    }

    @Override
    public final IllegalArgumentException notPercent(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.notPercent$str(), name, val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String greaterThanMinusOne$str() {
        return "AMQ229041: {0}  must be equals to -1 or greater than 0 (actual value: {1})";
    }

    @Override
    public final IllegalArgumentException greaterThanMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.greaterThanMinusOne$str(), name, val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String greaterThanZeroOrMinusOne$str() {
        return "AMQ229042: {0}  must be equals to -1 or greater or equals to 0 (actual value: {1})";
    }

    @Override
    public final IllegalArgumentException greaterThanZeroOrMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.greaterThanZeroOrMinusOne$str(), name, val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustbeBetween$str() {
        return "AMQ229043: {0} must be between {1} and {2} inclusive (actual value: {3})";
    }

    @Override
    public final IllegalArgumentException mustbeBetween(String name, Integer minPriority, Integer maxPriority, Object value) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.mustbeBetween$str(), name, minPriority, maxPriority, value));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidJournalType$str() {
        return "AMQ229044: Invalid journal type {0}";
    }

    @Override
    public final IllegalArgumentException invalidJournalType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidJournalType$str(), val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAddressFullPolicyType$str() {
        return "AMQ229045: Invalid address full message policy type {0}";
    }

    @Override
    public final IllegalArgumentException invalidAddressFullPolicyType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidAddressFullPolicyType$str(), val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String greaterThanZero1$str() {
        return "AMQ229046: invalid value: {0} count must be greater than 0";
    }

    @Override
    public final IllegalArgumentException greaterThanZero(Integer count) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.greaterThanZero1$str(), count));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String periodMustGreaterThanZero$str() {
        return "AMQ229047: invalid value: {0} sample period must be greater than 0";
    }

    @Override
    public final IllegalArgumentException periodMustGreaterThanZero(Long newPeriod) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.periodMustGreaterThanZero$str(), newPeriod));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidNewPriority$str() {
        return "AMQ229048: invalid new Priority value: {0}. It must be between 0 and 9 (both included)";
    }

    @Override
    public final IllegalArgumentException invalidNewPriority(Integer period) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidNewPriority$str(), period));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noQueueFound$str() {
        return "AMQ229049: No queue found for {0}";
    }

    @Override
    public final IllegalArgumentException noQueueFound(String otherQueueName) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.noQueueFound$str(), otherQueueName));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidJournal$str() {
        return "AMQ229050: Only NIO and AsyncIO are supported journals";
    }

    @Override
    public final IllegalArgumentException invalidJournal() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidJournal$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidJournalType2$str() {
        return "AMQ229051: Invalid journal type {0}";
    }

    @Override
    public final IllegalArgumentException invalidJournalType2(JournalType journalType) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidJournalType2$str(), new Object[]{journalType}));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateDir$str() {
        return "AMQ229052: Directory {0} does not exist and cannot be created";
    }

    @Override
    public final IllegalArgumentException cannotCreateDir(String dir) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.cannotCreateDir$str(), dir));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotConvertToInt$str() {
        return "AMQ229054: Cannot convert to int";
    }

    @Override
    public final IllegalArgumentException cannotConvertToInt() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotConvertToInt$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String routeNameIsNull$str() {
        return "AMQ229055: Routing name is null";
    }

    @Override
    public final IllegalArgumentException routeNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.routeNameIsNull$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String clusterNameIsNull$str() {
        return "AMQ229056: Cluster name is null";
    }

    @Override
    public final IllegalArgumentException clusterNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.clusterNameIsNull$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String addressIsNull$str() {
        return "AMQ229057: Address is null";
    }

    @Override
    public final IllegalArgumentException addressIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.addressIsNull$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bindingTypeNotSpecified$str() {
        return "AMQ229058: Binding type not specified";
    }

    @Override
    public final IllegalArgumentException bindingTypeNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.bindingTypeNotSpecified$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bindingIdNotSpecified$str() {
        return "AMQ229059: Binding ID is null";
    }

    @Override
    public final IllegalArgumentException bindingIdNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.bindingIdNotSpecified$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String distancenotSpecified$str() {
        return "AMQ229060: Distance is null";
    }

    @Override
    public final IllegalArgumentException distancenotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.distancenotSpecified$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectionExists$str() {
        return "AMQ229061: Connection already exists with id {0}";
    }

    @Override
    public final IllegalArgumentException connectionExists(Object id) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.connectionExists$str(), id));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String acceptorExists$str() {
        return "AMQ229062: Acceptor with id {0} already registered";
    }

    @Override
    public final IllegalArgumentException acceptorExists(Integer id) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.acceptorExists$str(), id));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String acceptorNotExists$str() {
        return "AMQ229063: Acceptor with id {0} not registered";
    }

    @Override
    public final IllegalArgumentException acceptorNotExists(Integer id) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.acceptorNotExists$str(), id));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownProtocol$str() {
        return "AMQ229064: Unknown protocol {0}";
    }

    @Override
    public final IllegalArgumentException unknownProtocol(String protocol) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.unknownProtocol$str(), protocol));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nodeIdNull$str() {
        return "AMQ229065: node id is null";
    }

    @Override
    public final IllegalArgumentException nodeIdNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nodeIdNull$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String queueNameIsNull$str() {
        return "AMQ229066: Queue name is null";
    }

    @Override
    public final IllegalArgumentException queueNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.queueNameIsNull$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotFindResource$str() {
        return "AMQ229067: Cannot find resource with name {0}";
    }

    @Override
    public final IllegalArgumentException cannotFindResource(String resourceName) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.cannotFindResource$str(), resourceName));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noGetterMethod$str() {
        return "AMQ229068: no getter method for {0}";
    }

    @Override
    public final IllegalArgumentException noGetterMethod(String resourceName) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.noGetterMethod$str(), resourceName));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noOperation$str() {
        return "AMQ229069: no operation {0}/{1}";
    }

    @Override
    public final IllegalArgumentException noOperation(String operation, Integer length) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.noOperation$str(), operation, length));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullMatch$str() {
        return "AMQ229070: match can not be null";
    }

    @Override
    public final IllegalArgumentException nullMatch() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullMatch$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMatch$str() {
        return "AMQ229071: # can only be at end of match";
    }

    @Override
    public final IllegalArgumentException invalidMatch() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidMatch$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullUser$str() {
        return "AMQ229072: User cannot be null";
    }

    @Override
    public final IllegalArgumentException nullUser() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullUser$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullPassword$str() {
        return "AMQ229073: Password cannot be null";
    }

    @Override
    public final IllegalArgumentException nullPassword() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullPassword$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorCreatingTransformerClass$str() {
        return "AMQ229074: Error instantiating transformer class {0}";
    }

    @Override
    public final IllegalArgumentException errorCreatingTransformerClass(Exception e, String transformerClassName) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.errorCreatingTransformerClass$str(), transformerClassName), e);
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String autoConvertError$str() {
        return "AMQ229075: method autoEncode doesn''t know how to convert {0} yet";
    }

    public final IllegalArgumentException autoConvertError(Class<?> aClass) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.autoConvertError$str(), aClass));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String destroyConnectionWithSessionMetadataHeader$str() {
        return "AMQ229076: Executing destroyConnection with {0}={1} through management''s request";
    }

    @Override
    public final String destroyConnectionWithSessionMetadataHeader(String key, String value) {
        return this._formatMessage(this.destroyConnectionWithSessionMetadataHeader$str(), key, value);
    }

    protected String destroyConnectionWithSessionMetadataClosingConnection$str() {
        return "AMQ229077: Closing connection {0}";
    }

    @Override
    public final String destroyConnectionWithSessionMetadataClosingConnection(String serverSessionString) {
        return this._formatMessage(this.destroyConnectionWithSessionMetadataClosingConnection$str(), serverSessionString);
    }

    protected String destroyConnectionWithSessionMetadataSendException$str() {
        return "AMQ229078: Disconnected per admin''s request on {0}={1}";
    }

    @Override
    public final ActiveMQDisconnectedException destroyConnectionWithSessionMetadataSendException(String key, String value) {
        ActiveMQDisconnectedException result = new ActiveMQDisconnectedException(this._formatMessage(this.destroyConnectionWithSessionMetadataSendException$str(), key, value));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String destroyConnectionWithSessionMetadataNoSessionFound$str() {
        return "AMQ229079: No session found with {0}={1}";
    }

    @Override
    public final String destroyConnectionWithSessionMetadataNoSessionFound(String key, String value) {
        return this._formatMessage(this.destroyConnectionWithSessionMetadataNoSessionFound$str(), key, value);
    }

    protected String invalidPageIO$str() {
        return "AMQ229080: Invalid Page IO, PagingManager was stopped or closed";
    }

    @Override
    public final ActiveMQIllegalStateException invalidPageIO() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.invalidPageIO$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noDiscoveryGroupFound$str() {
        return "AMQ229081: No Discovery Group configuration named {0} found";
    }

    @Override
    public final ActiveMQException noDiscoveryGroupFound(DiscoveryGroupConfiguration dg) {
        ActiveMQException result = new ActiveMQException(this._formatMessage(this.noDiscoveryGroupFound$str(), dg));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String queueSubscriptionBelongsToDifferentAddress$str() {
        return "AMQ229082: Queue {0} already exists on another subscription";
    }

    @Override
    public final ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentAddress(SimpleString queueName) {
        ActiveMQInvalidTransientQueueUseException result = new ActiveMQInvalidTransientQueueUseException(this._formatMessage(this.queueSubscriptionBelongsToDifferentAddress$str(), queueName));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String queueSubscriptionBelongsToDifferentFilter$str() {
        return "AMQ229083: Queue {0} has a different filter than requested";
    }

    @Override
    public final ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentFilter(SimpleString queueName) {
        ActiveMQInvalidTransientQueueUseException result = new ActiveMQInvalidTransientQueueUseException(this._formatMessage(this.queueSubscriptionBelongsToDifferentFilter$str(), queueName));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToValidateClusterUser$str() {
        return "AMQ229099: Unable to authenticate cluster user: {0}";
    }

    @Override
    public final ActiveMQClusterSecurityException unableToValidateClusterUser(String user) {
        ActiveMQClusterSecurityException result = new ActiveMQClusterSecurityException(this._formatMessage(this.unableToValidateClusterUser$str(), user));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String journalDirIsFile$str() {
        return "AMQ229100: Trying to move a journal file that refers to a file instead of a directory: {0}";
    }

    @Override
    public final IllegalStateException journalDirIsFile(File fDir) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.journalDirIsFile$str(), fDir));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotMoveJournal$str() {
        return "AMQ229101: error trying to backup journal files at directory: {0}";
    }

    @Override
    public final IllegalStateException couldNotMoveJournal(File dir) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.couldNotMoveJournal$str(), dir));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String addressIsFull$str() {
        return "AMQ229102: Address \"{0}\" is full.";
    }

    @Override
    public final ActiveMQAddressFullException addressIsFull(String addressName) {
        ActiveMQAddressFullException result = new ActiveMQAddressFullException(this._formatMessage(this.addressIsFull$str(), addressName));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noConfigurationFoundForScaleDown$str() {
        return "AMQ229103: No Connectors or Discovery Groups configured for Scale Down";
    }

    @Override
    public final ActiveMQException noConfigurationFoundForScaleDown() {
        ActiveMQException result = new ActiveMQException(String.format(this.getLoggingLocale(), this.noConfigurationFoundForScaleDown$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String groupWhileStopping$str() {
        return "AMQ229104: Server is stopping. Message grouping not allowed";
    }

    @Override
    public final ActiveMQException groupWhileStopping() {
        ActiveMQException result = new ActiveMQException(String.format(this.getLoggingLocale(), this.groupWhileStopping$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSlowConsumerPolicyType$str() {
        return "AMQ229106: Invalid slow consumer policy type {0}";
    }

    @Override
    public final IllegalArgumentException invalidSlowConsumerPolicyType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidSlowConsumerPolicyType$str(), val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String consumerConnectionsClosedByManagement$str() {
        return "AMQ229107: consumer connections for address {0} closed by management";
    }

    @Override
    public final ActiveMQInternalErrorException consumerConnectionsClosedByManagement(String address) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.consumerConnectionsClosedByManagement$str(), address));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String connectionsForUserClosedByManagement$str() {
        return "AMQ229108: connections for user {0} closed by management";
    }

    @Override
    public final ActiveMQInternalErrorException connectionsForUserClosedByManagement(String userName) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.connectionsForUserClosedByManagement$str(), userName));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedHAPolicyConfiguration$str() {
        return "AMQ229109: unsupported HA Policy Configuration {0}";
    }

    @Override
    public final ActiveMQIllegalStateException unsupportedHAPolicyConfiguration(Object o) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.unsupportedHAPolicyConfiguration$str(), o));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String sessionLimitReached$str() {
        return "AMQ229110: Too many sessions for user ''{0}''. Sessions allowed: {1}.";
    }

    @Override
    public final ActiveMQSessionCreationException sessionLimitReached(String username, int limit) {
        ActiveMQSessionCreationException result = new ActiveMQSessionCreationException(this._formatMessage(this.sessionLimitReached$str(), username, limit));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String queueLimitReached$str() {
        return "AMQ229111: Too many queues created by user ''{0}''. Queues allowed: {1}.";
    }

    @Override
    public final ActiveMQSecurityException queueLimitReached(String username, int limit) {
        ActiveMQSecurityException result = new ActiveMQSecurityException(this._formatMessage(this.queueLimitReached$str(), username, limit));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotSetMBeanserver$str() {
        return "AMQ229112: Cannot set MBeanServer during startup or while started";
    }

    @Override
    public final IllegalStateException cannotSetMBeanserver() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotSetMBeanserver$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMessageLoadBalancingType$str() {
        return "AMQ229113: Invalid message load balancing type {0}";
    }

    @Override
    public final IllegalArgumentException invalidMessageLoadBalancingType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidMessageLoadBalancingType$str(), val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String replicationSynchronizationTimeout$str() {
        return "AMQ229114: Replication synchronization process timed out after waiting {0} milliseconds";
    }

    @Override
    public final ActiveMQReplicationTimeooutException replicationSynchronizationTimeout(long timeout) {
        ActiveMQReplicationTimeooutException result = new ActiveMQReplicationTimeooutException(this._formatMessage(this.replicationSynchronizationTimeout$str(), timeout));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String liveBackupMismatch$str() {
        return "AMQ229115: Colocated Policy hasn''t different type live and backup";
    }

    @Override
    public final ActiveMQIllegalStateException liveBackupMismatch() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this.liveBackupMismatch$str());
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String acceptorUnavailable$str() {
        return "AMQ229116: Netty Acceptor unavailable";
    }

    @Override
    public final IllegalStateException acceptorUnavailable() {
        IllegalStateException result = new IllegalStateException(this.acceptorUnavailable$str());
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String replicatorIsNull$str() {
        return "AMQ229117: Replicator is null. Replication was likely terminated.";
    }

    @Override
    public final ActiveMQIllegalStateException replicatorIsNull() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.replicatorIsNull$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String methodNotApplicable$str() {
        return "AMQ229118: Management method not applicable for current server configuration";
    }

    @Override
    public final IllegalStateException methodNotApplicable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.methodNotApplicable$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String diskBeyondLimit$str() {
        return "AMQ229119: Free storage space is at {0} of {1} total. Usage rate is {2} which is beyond the configured <max-disk-usage>. System will start blocking producers.";
    }

    @Override
    public final ActiveMQIOErrorException diskBeyondLimit(String usableSpace, String totalSpace, String usage) {
        ActiveMQIOErrorException result = new ActiveMQIOErrorException(this._formatMessage(this.diskBeyondLimit$str(), usableSpace, totalSpace, usage));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectionWithIDClosedByManagement$str() {
        return "AMQ229120: connection with ID {0} closed by management";
    }

    @Override
    public final ActiveMQInternalErrorException connectionWithIDClosedByManagement(String ID) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.connectionWithIDClosedByManagement$str(), ID));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String maxConsumerLimitReachedForQueue$str() {
        return "AMQ229200: Maximum Consumer Limit Reached on Queue:(address={0},queue={1})";
    }

    @Override
    public final ActiveMQQueueMaxConsumerLimitReached maxConsumerLimitReachedForQueue(SimpleString address, SimpleString queueName) {
        ActiveMQQueueMaxConsumerLimitReached result = new ActiveMQQueueMaxConsumerLimitReached(this._formatMessage(this.maxConsumerLimitReachedForQueue$str(), address, queueName));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedRoutingTypeForAddress$str() {
        return "AMQ229201: Expected Routing Type {1} but found {2} for address {0}";
    }

    @Override
    public final ActiveMQUnexpectedRoutingTypeForAddress unexpectedRoutingTypeForAddress(SimpleString address, RoutingType expectedRoutingType, Set<RoutingType> supportedRoutingTypes) {
        ActiveMQUnexpectedRoutingTypeForAddress result = new ActiveMQUnexpectedRoutingTypeForAddress(this._formatMessage(this.unexpectedRoutingTypeForAddress$str(), address, expectedRoutingType, supportedRoutingTypes));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidQueueConfiguration$str() {
        return "AMQ229202: Invalid Queue Configuration for Queue {0}, Address {1}.  Expected {2} to be {3} but was {4}";
    }

    @Override
    public final ActiveMQInvalidQueueConfiguration invalidQueueConfiguration(SimpleString address, SimpleString queueName, String queuePropertyName, Object expectedValue, Object actualValue) {
        ActiveMQInvalidQueueConfiguration result = new ActiveMQInvalidQueueConfiguration(this._formatMessage(this.invalidQueueConfiguration$str(), address, queueName, queuePropertyName, expectedValue, actualValue));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String addressDoesNotExist$str() {
        return "AMQ229203: Address Does Not Exist: {0}";
    }

    @Override
    public final ActiveMQAddressDoesNotExistException addressDoesNotExist(SimpleString address) {
        ActiveMQAddressDoesNotExistException result = new ActiveMQAddressDoesNotExistException(this._formatMessage(this.addressDoesNotExist$str(), address));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String addressAlreadyExists$str() {
        return "AMQ229204: Address already exists: {0}";
    }

    @Override
    public final ActiveMQAddressExistsException addressAlreadyExists(SimpleString address) {
        ActiveMQAddressExistsException result = new ActiveMQAddressExistsException(this._formatMessage(this.addressAlreadyExists$str(), address));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String addressHasBindings$str() {
        return "AMQ229205: Address {0} has bindings";
    }

    @Override
    public final ActiveMQDeleteAddressException addressHasBindings(SimpleString address) {
        ActiveMQDeleteAddressException result = new ActiveMQDeleteAddressException(this._formatMessage(this.addressHasBindings$str(), address));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidMaxConsumers$str() {
        return "AMQ229206: Queue {0} has invalid max consumer setting: {1}";
    }

    @Override
    public final IllegalArgumentException invalidMaxConsumers(String queueName, int value) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidMaxConsumers$str(), queueName, value));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRoutingTypeForAddress$str() {
        return "AMQ229207: Can not create queue with routing type: {0}, Supported routing types for address: {1} are {2}";
    }

    @Override
    public final IllegalArgumentException invalidRoutingTypeForAddress(RoutingType routingType, String address, Set<RoutingType> supportedRoutingTypes) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidRoutingTypeForAddress$str(), routingType, address, supportedRoutingTypes));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRoutingType$str() {
        return "AMQ229208: Invalid routing type {0}";
    }

    @Override
    public final IllegalArgumentException invalidRoutingType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidRoutingType$str(), val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRoutingTypeDelete$str() {
        return "AMQ229209: Can''t remove routing type {0}, queues exists for address: {1}. Please delete queues before removing this routing type.";
    }

    @Override
    public final IllegalStateException invalidRoutingTypeDelete(RoutingType routingType, String address) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.invalidRoutingTypeDelete$str(), routingType, address));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMaxConsumersUpdate$str() {
        return "AMQ229210: Can''t update queue {0} with maxConsumers: {1}. Current consumers are {2}.";
    }

    @Override
    public final IllegalStateException invalidMaxConsumersUpdate(String queueName, int maxConsumers, int consumers) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.invalidMaxConsumersUpdate$str(), queueName, maxConsumers, consumers));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRoutingTypeUpdate$str() {
        return "AMQ229211: Can''t update queue {0} with routing type: {1}, Supported routing types for address: {2} are {3}";
    }

    @Override
    public final IllegalStateException invalidRoutingTypeUpdate(String queueName, RoutingType routingType, String address, Set<RoutingType> supportedRoutingTypes) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.invalidRoutingTypeUpdate$str(), queueName, routingType, address, supportedRoutingTypes));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidDeletionPolicyType$str() {
        return "AMQ229212: Invalid deletion policy type {0}";
    }

    @Override
    public final IllegalArgumentException invalidDeletionPolicyType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidDeletionPolicyType$str(), val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String userNoPermissionsQueue$str() {
        return "AMQ229213: User: {0} does not have permission=''{1}'' for queue {2} on address {3}";
    }

    @Override
    public final ActiveMQSecurityException userNoPermissionsQueue(String username, CheckType checkType, SimpleString queue, SimpleString address) {
        ActiveMQSecurityException result = new ActiveMQSecurityException(this._formatMessage(this.userNoPermissionsQueue$str(), new Object[]{username, checkType, queue, address}));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notPercentOrMinusOne$str() {
        return "AMQ229214: {0} must be a valid percentage value between 0 and 100 or -1 (actual value: {1})";
    }

    @Override
    public final IllegalArgumentException notPercentOrMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.notPercentOrMinusOne$str(), name, val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotDeleteQueueWithMessages$str() {
        return "AMQ229215: Cannot delete queue {0} on binding {1} - it has {2} messages";
    }

    @Override
    public final ActiveMQIllegalStateException cannotDeleteQueueWithMessages(SimpleString name, SimpleString queueName, long messageCount) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.cannotDeleteQueueWithMessages$str(), name, queueName, messageCount));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidQueueName$str() {
        return "AMQ229216: Invalid queue name: {0}";
    }

    @Override
    public final ActiveMQIllegalStateException invalidQueueName(SimpleString queueName) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.invalidQueueName$str(), queueName));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotWriteToClosedFile$str() {
        return "AMQ119217: Cannot write to closed file: {0}";
    }

    @Override
    public final ActiveMQIOErrorException cannotWriteToClosedFile(SequentialFile file) {
        ActiveMQIOErrorException result = new ActiveMQIOErrorException(this._formatMessage(this.cannotWriteToClosedFile$str(), file));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLocateConfigURL$str() {
        return "AMQ229218: Failed to locate broker configuration URL";
    }

    @Override
    public final ActiveMQIllegalStateException failedToLocateConfigURL() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.failedToLocateConfigURL$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToLoadSecurityConfig$str() {
        return "AMQ229219: Failed to load security configuration";
    }

    @Override
    public final ActiveMQIllegalStateException failedToLoadSecurityConfig() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.failedToLoadSecurityConfig$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToLoadUserFile$str() {
        return "AMQ229220: Failed to load user file: {0}";
    }

    @Override
    public final ActiveMQIllegalStateException failedToLoadUserFile(String path) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.failedToLoadUserFile$str(), path));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToLoadRoleFile$str() {
        return "AMQ229221: Failed to load role file: {0}";
    }

    @Override
    public final ActiveMQIllegalStateException failedToLoadRoleFile(String path) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.failedToLoadRoleFile$str(), path));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToFindLoginModuleEntry$str() {
        return "AMQ229222: Failed to find login module entry {0} from JAAS configuration";
    }

    @Override
    public final ActiveMQIllegalStateException failedToFindLoginModuleEntry(String entry) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.failedToFindLoginModuleEntry$str(), entry));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String userAlreadyExists$str() {
        return "AMQ229223: User {0} already exists";
    }

    @Override
    public final IllegalArgumentException userAlreadyExists(String user) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.userAlreadyExists$str(), user));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String userDoesNotExist$str() {
        return "AMQ229224: User {0} does not exist";
    }

    @Override
    public final IllegalArgumentException userDoesNotExist(String user) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.userDoesNotExist$str(), user));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rejectEmptyValidatedUser$str() {
        return "AMQ229225: Validated User is not set";
    }

    @Override
    public final ActiveMQIllegalStateException rejectEmptyValidatedUser() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this.rejectEmptyValidatedUser$str());
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String inRangeOfPositiveInt$str() {
        return "AMQ229226: {0}  must be greater than 0 and less than or equal to Integer.MAX_VALUE (actual value: {1})";
    }

    @Override
    public final IllegalArgumentException inRangeOfPositiveInt(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.inRangeOfPositiveInt$str(), name, val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inRangeOfPositiveIntThanMinusOne$str() {
        return "AMQ229227: {0}  must be equals to -1 or greater than 0 and less than or equal to Integer.MAX_VALUE (actual value: {1})";
    }

    @Override
    public final IllegalArgumentException inRangeOfPositiveIntThanMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.inRangeOfPositiveIntThanMinusOne$str(), name, val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String lessThanOrEqualToOne$str() {
        return "AMQ229228: {0} must be less than or equal to 1 (actual value: {1})";
    }

    @Override
    public final IllegalArgumentException lessThanOrEqualToOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.lessThanOrEqualToOne$str(), name, val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToParseJson$str() {
        return "AMQ229229: Failed to parse JSON queue configuration: {0}";
    }

    @Override
    public final IllegalArgumentException failedToParseJson(String json) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.failedToParseJson$str(), json));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToBind$str() {
        return "AMQ229230: Failed to bind acceptor {0} to {1}";
    }

    @Override
    public final IllegalStateException failedToBind(String acceptor, String hostPort, Exception e) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.failedToBind$str(), acceptor, hostPort), e);
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String divertDoesNotExist$str() {
        return "AMQ229231: Divert Does Not Exist: {0}";
    }

    @Override
    public final ActiveMQDivertDoesNotExistException divertDoesNotExist(String divert) {
        ActiveMQDivertDoesNotExistException result = new ActiveMQDivertDoesNotExistException(this._formatMessage(this.divertDoesNotExist$str(), divert));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotCreateConsumerOnClosedSession$str() {
        return "AMQ229232: Cannot create consumer on {0}. Session is closed.";
    }

    @Override
    public final ActiveMQIllegalStateException cannotCreateConsumerOnClosedSession(SimpleString queueName) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.cannotCreateConsumerOnClosedSession$str(), queueName));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotSetSecurityManager$str() {
        return "AMQ229233: Cannot set ActiveMQSecurityManager during startup or while started";
    }

    @Override
    public final IllegalStateException cannotSetSecurityManager() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotSetSecurityManager$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSlowConsumerThresholdMeasurementUnit$str() {
        return "AMQ229234: Invalid slow consumer threshold measurement unit {0}";
    }

    @Override
    public final IllegalArgumentException invalidSlowConsumerThresholdMeasurementUnit(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidSlowConsumerThresholdMeasurementUnit$str(), val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bindingAlreadyExists2$str() {
        return "AMQ229235: Incompatible binding with name {0} already exists: {1}";
    }

    @Override
    public final ActiveMQIllegalStateException bindingAlreadyExists(String name, String binding) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.bindingAlreadyExists2$str(), name, binding));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidTargetKey$str() {
        return "AMQ229236: Invalid target key {0}";
    }

    @Override
    public final IllegalArgumentException invalidTargetKey(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidTargetKey$str(), val));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String redirectConnection$str() {
        return "AMQ229237: Connection redirected to {0}";
    }

    @Override
    public final ActiveMQRedirectedException redirectConnection(TransportConfiguration connector) {
        ActiveMQRedirectedException result = new ActiveMQRedirectedException(this._formatMessage(this.redirectConnection$str(), connector));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotRedirect$str() {
        return "AMQ229238: No target to redirect the connection";
    }

    @Override
    public final ActiveMQRedirectedException cannotRedirect() {
        ActiveMQRedirectedException result = new ActiveMQRedirectedException(String.format(this.getLoggingLocale(), this.cannotRedirect$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noRetention$str() {
        return "AMQ229239: There is no retention configured. In order to use the replay method you must specify journal-retention-directory element on the broker.xml";
    }

    @Override
    public final IllegalArgumentException noRetention() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noRetention$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String balancerReject$str() {
        return "AMQ229240: Balancer rejected the connection";
    }

    @Override
    public final ActiveMQRemoteDisconnectException balancerReject() {
        ActiveMQRemoteDisconnectException result = new ActiveMQRemoteDisconnectException(String.format(this.getLoggingLocale(), this.balancerReject$str(), new Object[0]));
        ActiveMQMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

