/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.diff.compare;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.diff.compare.core.DefaultDatabaseObjectComparator;
import liquibase.structure.DatabaseObject;

public class SynonymComparator
implements DatabaseObjectComparator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (Synonym.class.isAssignableFrom(clazz)) {
            return 5;
        }
        return -1;
    }

    @Override
    public String[] hash(DatabaseObject object, Database database, DatabaseObjectComparatorChain databaseObjectComparatorChain) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(databaseObjectComparatorChain.hash((DatabaseObject)object, database)));
        object = ((Synonym)object).isPrivate() ? "private" : "public";
        arrayList.add(object);
        ArrayList<Object> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    @Override
    public boolean isSameObject(DatabaseObject databaseObject, DatabaseObject databaseObject2, Database database, DatabaseObjectComparatorChain databaseObjectComparatorChain) {
        if (!(databaseObject instanceof Synonym) || !(databaseObject2 instanceof Synonym)) {
            return false;
        }
        if (((Synonym)databaseObject).isPrivate() != ((Synonym)databaseObject2).isPrivate()) {
            return false;
        }
        if (!DefaultDatabaseObjectComparator.nameMatches(databaseObject, databaseObject2, database)) {
            return false;
        }
        return DatabaseObjectComparatorFactory.getInstance().isSameObject(databaseObject.getSchema(), databaseObject2.getSchema(), databaseObjectComparatorChain.getSchemaComparisons(), database);
    }

    @Override
    public ObjectDifferences findDifferences(DatabaseObject databaseObject, DatabaseObject databaseObject2, Database database, CompareControl compareControl, DatabaseObjectComparatorChain databaseObjectComparatorChain, Set<String> set) {
        set.add("objectSchema");
        set.add("_actualObjectCatalogName");
        return databaseObjectComparatorChain.findDifferences(databaseObject, databaseObject2, database, compareControl, set);
    }
}

