/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import okhttp3.OkHttpClient;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientFactory;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientFactory;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class HttpClientConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"spring.cloud.httpclientfactories.ok.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={OkHttpClient.class})
    static class OkHttpClientConfiguration {
        OkHttpClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public OkHttpClientConnectionPoolFactory connPoolFactory() {
            return new DefaultOkHttpClientConnectionPoolFactory();
        }

        @Bean
        @ConditionalOnMissingBean
        public OkHttpClient.Builder okHttpClientBuilder() {
            return new OkHttpClient.Builder();
        }

        @Bean
        @ConditionalOnMissingBean
        public OkHttpClientFactory okHttpClientFactory(OkHttpClient.Builder builder) {
            return new DefaultOkHttpClientFactory(builder);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"spring.cloud.httpclientfactories.apache.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={HttpClient.class})
    static class ApacheHttpClientConfiguration {
        ApacheHttpClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ApacheHttpClientConnectionManagerFactory connManFactory() {
            return new DefaultApacheHttpClientConnectionManagerFactory();
        }

        @Bean
        @ConditionalOnMissingBean
        public HttpClientBuilder apacheHttpClientBuilder() {
            return HttpClientBuilder.create();
        }

        @Bean
        @ConditionalOnMissingBean
        public ApacheHttpClientFactory apacheHttpClientFactory(HttpClientBuilder builder) {
            return new DefaultApacheHttpClientFactory(builder);
        }
    }
}

