/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.Rules;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.LiquibaseChangeSetCheckResult;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.QualityChecksRulesEngine;
import com.datical.liquibase.ext.rules.core.QualityChecksRulesEngine$RuleCombination;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.ChangeLogParseException;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;

public class ChecksRunCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "run"};
    public static final CommandArgumentDefinition<String> CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SCOPE_ARG;

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        int n2;
        Object object = commandResultsBuilder.getCommandScope();
        Object object2 = ((CommandScope)object).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksRunCommandStep.checkFileArgExistence((String)object2, "checks settings", false);
        Object object3 = new CheckSettingsConfigHelper((String)object2);
        object = ((CommandScope)object).getConfiguredValue(CHANGELOG_FILE_ARG).getValue();
        ChecksRunCommandStep.checkFileArgExistence((String)object, "changelog", true);
        this.sendMessageToUi("Executing Quality Checks against " + (String)object + System.lineSeparator());
        LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> linkedHashMap = Scope.getCurrentScope().getResourceAccessor();
        Object object4 = ChangeLogParserFactory.getInstance().getParser((String)object, (ResourceAccessor)((Object)linkedHashMap));
        try {
            linkedHashMap = object4.parse((String)object, new ChangeLogParameters(), (ResourceAccessor)((Object)linkedHashMap));
        }
        catch (ChangeLogParseException changeLogParseException) {
            object = String.format("\nThe changelog file %s cannot be found or is not a valid changelog: %s\nCorrect this issue and try to run checks again.", object, changeLogParseException.getMessage());
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object);
            Scope.getCurrentScope().getUI().sendMessage((String)object);
            return;
        }
        object4 = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService();
        int n3 = object4.daysTilExpiration();
        boolean bl2 = LicenseServiceUtils.isProLicenseValid();
        if (n3 > 0) {
            if (bl2) {
                this.sendMessageToUi("Executing all checks because a valid Liquibase Pro license was found!" + System.lineSeparator());
            } else {
                this.sendMessageToUi("No valid Liquibase Pro license key detected!" + System.lineSeparator() + "Unlock unlimited checks with a free Pro license Key from https://liquibase.com/protrial" + System.lineSeparator() + "Execution limited to 5 checks." + System.lineSeparator());
            }
        } else {
            LocalDate localDate = LocalDate.now().plusDays(n3);
            this.sendMessageToUi("Pro license expired on " + localDate.format(DateTimeFormatter.ofPattern("yyyy-MMM-dd")) + "." + System.lineSeparator() + "Unlock unlimited checks with a free Pro license Key from https://liquibase.com/protrial" + System.lineSeparator() + "Execution limited to 5 checks." + System.lineSeparator());
        }
        Object object5 = ChecksRunCommandStep.listAllRules();
        try {
            object3 = ((CheckSettingsConfigHelper)object3).read((List<AbstractLiquibaseRule>)object5);
        }
        catch (Exception exception) {
            object2 = String.format("\nUnable to read checks settings file '%s': %s\nCorrect this issue and try to run checks again.", object2, exception.getMessage());
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object2);
            Scope.getCurrentScope().getUI().sendMessage((String)object2);
            return;
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        object2 = new LinkedHashSet();
        linkedHashMap = this.runChecks((List<AbstractLiquibaseRule>)object5, ((DatabaseChangeLog)((Object)linkedHashMap)).getChangeSets(), (CheckSettingsConfig)object3);
        linkedHashMap.forEach((arg_0, arg_1) -> ChecksRunCommandStep.lambda$run$1(linkedHashSet, (Set)object2, arg_0, arg_1));
        if (linkedHashSet.isEmpty()) {
            object5 = "\nWarning:  No checks were executed\nChangesets Validated:  None\nChecks run against each changeset:  None\n\n";
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object5);
            Scope.getCurrentScope().getUI().sendMessage((String)object5);
            return;
        }
        object5 = SeverityEnum.INFO;
        if (!linkedHashMap.isEmpty()) {
            Object object6;
            n2 = 0;
            for (Map.Entry<ChangeSet, LiquibaseChangeSetCheckResult> entry : linkedHashMap.entrySet()) {
                object6 = entry.getKey();
                for (Object object7 : entry.getValue().getRuleResults()) {
                    if (((LiquibaseRuleResult)object7).hasRuleSucceeded()) continue;
                    if (n2 == 0) {
                        this.sendMessage(commandResultsBuilder, "Checks completed validation of the changelog and found the following issues:" + System.lineSeparator() + System.lineSeparator());
                        n2 = 1;
                    }
                    for (RuleIteration ruleIteration : ((LiquibaseRuleResult)object7).getExecutions()) {
                        String string2;
                        Object object8 = ((LiquibaseRuleResult)object7).getDynamicRule();
                        if (object8 != null) {
                            string2 = ((DynamicRule)object8).getShortName();
                            object8 = ((AbstractConfigurableRule)object8).getSeverity();
                        } else {
                            string2 = ((LiquibaseRuleResult)object7).getRule().getShortName();
                            object8 = ((LiquibaseRuleResult)object7).getRule().getSeverity();
                        }
                        if (((SeverityEnum)((Object)object8)).getValue() > ((SeverityEnum)((Object)object5)).getValue()) {
                            object5 = object8;
                        }
                        if (StringUtil.isNotEmpty(string2)) {
                            string2 = " (" + string2 + ")";
                        }
                        String string3 = StringUtil.wrap(StringUtil.join(ruleIteration.getMessages(), ";"), 60, 20);
                        string2 = ((LiquibaseRuleResult)object7).getRule().getName() + string2 + System.lineSeparator();
                        String string4 = "Changeset ID:       " + ((ChangeSet)object6).getId() + System.lineSeparator() + "Changeset Filepath: " + ((ChangeSet)object6).getFilePath() + System.lineSeparator() + "Check Name:         " + string2 + "Check Severity:     " + object8 + " (Return code: " + ((SeverityEnum)((Object)object8)).getExitValue() + ")" + System.lineSeparator() + "Message:            " + string3;
                        this.sendMessage(commandResultsBuilder, string4 + System.lineSeparator() + System.lineSeparator());
                    }
                }
            }
            StringBuilder stringBuilder = new StringBuilder(System.lineSeparator() + "Changesets Validated:");
            stringBuilder.append(System.lineSeparator());
            Iterator<Map.Entry<ChangeSet, LiquibaseChangeSetCheckResult>> iterator = linkedHashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object7;
                object7 = iterator.next().getKey();
                stringBuilder.append("  ID: ");
                stringBuilder.append(((ChangeSet)object7).getId());
                stringBuilder.append("; Author: ");
                stringBuilder.append(((ChangeSet)object7).getAuthor());
                stringBuilder.append("; File path: ");
                stringBuilder.append(((ChangeSet)object7).getFilePath());
                stringBuilder.append(System.lineSeparator());
            }
            this.sendMessage(commandResultsBuilder, stringBuilder + System.lineSeparator());
            StringBuilder stringBuilder2 = new StringBuilder("Checks run against each changeset:");
            stringBuilder2.append(System.lineSeparator());
            linkedHashSet.forEach(string -> stringBuilder2.append((String)string).append(System.lineSeparator()));
            this.sendMessage(commandResultsBuilder, stringBuilder2 + System.lineSeparator());
            this.printChangeSetsWithSkippedChecks(commandResultsBuilder, linkedHashMap);
            if (!object2.isEmpty()) {
                object6 = new StringBuilder("Checks Skipped Due to Community Limit of 5 Checks:");
                ((StringBuilder)object6).append(System.lineSeparator());
                object2.forEach(arg_0 -> ChecksRunCommandStep.lambda$run$3((StringBuilder)object6, arg_0));
                this.sendMessage(commandResultsBuilder, object6 + System.lineSeparator());
            }
            if (n3 < 0) {
                this.sendMessageToUi(object4.getLicenseInfo());
            }
        }
        this.sendMessage(commandResultsBuilder, ((CheckSettingsConfig)object3).getUnrecognizedRulesWarningMessage());
        commandResultsBuilder.getOutputStream().flush();
        n2 = ((SeverityEnum)((Object)object5)).getExitValue();
        if (n2 != 0) {
            commandResultsBuilder.addResult("statusCode", (Object)n2);
            throw commandResultsBuilder.commandFailed("Checks run command exited with an error code of ".concat(String.valueOf(n2)), n2);
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    private void printChangeSetsWithSkippedChecks(CommandResultsBuilder commandResultsBuilder, LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> linkedHashMap) {
        StringBuilder stringBuilder = new StringBuilder("Changeset SQL not parsed by the following checks (please review them directly):").append(System.lineSeparator());
        if (linkedHashMap.entrySet().stream().filter(entry -> ((LiquibaseChangeSetCheckResult)entry.getValue()).getSkippedBecauseOfExceptionRuleNames().size() > 0).peek(entry -> this.appendChangeSetWithSkippedChecks(stringBuilder, (Map.Entry<ChangeSet, LiquibaseChangeSetCheckResult>)entry)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).size() > 0) {
            stringBuilder.append(System.lineSeparator());
            this.sendMessage(commandResultsBuilder, stringBuilder.toString());
        }
    }

    private void appendChangeSetWithSkippedChecks(StringBuilder stringBuilder, Map.Entry<ChangeSet, LiquibaseChangeSetCheckResult> object) {
        ChangeSet changeSet = object.getKey();
        stringBuilder.append("  ID: ");
        stringBuilder.append(changeSet.getId());
        stringBuilder.append("; Author: ");
        stringBuilder.append(changeSet.getAuthor());
        stringBuilder.append("; File path: ");
        stringBuilder.append(changeSet.getFilePath());
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("    Skipped by: ");
        object = String.join((CharSequence)", ", object.getValue().getSkippedBecauseOfExceptionRuleNames());
        stringBuilder.append((String)object);
        stringBuilder.append(System.lineSeparator());
    }

    private void sendMessageToUi(String string) {
        Scope.getCurrentScope().getUI().sendMessage(string);
    }

    private void sendMessage(CommandResultsBuilder commandResultsBuilder, String string) {
        commandResultsBuilder.getOutputStream().write(string.getBytes());
    }

    private static boolean validChecksScope(String string) {
        return "changelog".equalsIgnoreCase(string);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Check the changelog for issues");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    private LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> runChecks(List<AbstractLiquibaseRule> list, List<ChangeSet> object, CheckSettingsConfig checkSettingsConfig) {
        if (checkSettingsConfig != null) {
            LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> linkedHashMap = new LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult>(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                ChangeSet changeSet = (ChangeSet)object.next();
                linkedHashMap.put(changeSet, this.runCheck(list, changeSet, checkSettingsConfig));
            }
            return linkedHashMap;
        }
        return new LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult>();
    }

    private LiquibaseChangeSetCheckResult runCheck(List<AbstractLiquibaseRule> iterable, ChangeSet object, CheckSettingsConfig object2) {
        Facts facts = new Facts();
        facts.put(FactEnum.CHANGESET.toString(), object);
        iterable = new Rules(iterable.toArray());
        object = new QualityChecksRulesEngine((CheckSettingsConfig)object2);
        ((QualityChecksRulesEngine)object).fire((Rules)iterable, facts);
        iterable = ((QualityChecksRulesEngine)object).getExecutedRules().stream().map(ChecksRunCommandStep::getRuleNames).collect(Collectors.toList());
        object2 = ((QualityChecksRulesEngine)object).getSkippedRules().stream().map(ChecksRunCommandStep::getRuleNames).collect(Collectors.toList());
        return new LiquibaseChangeSetCheckResult(((QualityChecksRulesEngine)object).getResults(), ((QualityChecksRulesEngine)object).getSkippedBecauseOfExceptionRuleNames(), (List<String>)iterable, (List<String>)object2);
    }

    private static String getRuleNames(QualityChecksRulesEngine$RuleCombination qualityChecksRulesEngine$RuleCombination) {
        StringBuilder stringBuilder = new StringBuilder("  ").append(qualityChecksRulesEngine$RuleCombination.rule.getName());
        if (qualityChecksRulesEngine$RuleCombination.configurableRule instanceof DynamicRule && ((DynamicRule)qualityChecksRulesEngine$RuleCombination.configurableRule).isCopy()) {
            stringBuilder.append(" (Short Name: ").append(((DynamicRule)qualityChecksRulesEngine$RuleCombination.configurableRule).getShortName()).append(")");
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ void lambda$run$3(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append(System.lineSeparator());
    }

    private static /* synthetic */ void lambda$run$1(Set set, Set set2, ChangeSet changeSet, LiquibaseChangeSetCheckResult liquibaseChangeSetCheckResult) {
        set.addAll(liquibaseChangeSetCheckResult.getExecutedRuleNames());
        set2.addAll(liquibaseChangeSetCheckResult.getSkippedBecauseOfLicenceRuleNames());
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHANGELOG_FILE_ARG = commandBuilder.argument("changelogFile", String.class).required().description("Relative or fully qualified path to a Liquibase changelog file").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_SCOPE_ARG = commandBuilder.argument("checksScope", String.class).defaultValue("changelog").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (!ChecksRunCommandStep.validChecksScope((String)(object = (String)object))) {
                object = "\nWARNING:  Check scope value '" + (String)object + "' is not valid.  Valid check scope values include: changelog";
                throw new IllegalArgumentException((String)object);
            }
            return object;
        }).description("The Liquibase component to run checks against").build();
    }
}

