/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl;

import akka.annotation.InternalApi;
import akka.stream.Attributes;
import akka.stream.RateExceededException;
import akka.stream.ThrottleMode;
import akka.stream.ThrottleMode$Enforcing$;
import akka.stream.ThrottleMode$Shaping$;
import akka.stream.impl.Throttle$;
import akka.stream.impl.fusing.GraphStages;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogic;
import akka.util.NanoTimeTokenBucket;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005esAB\r\u001b\u0011\u0003q\u0002E\u0002\u0004#5!\u0005ad\t\u0005\u0006U\u0005!\t\u0001\f\u0005\b[\u0005\u0011\r\u0011\"\u0002/\u0011\u0019\t\u0014\u0001)A\u0007_\u0019)!E\u0007\u0001\u001fu!A1,\u0002BC\u0002\u0013\u0005A\f\u0003\u0005a\u000b\t\u0005\t\u0015!\u0003^\u0011!\tWA!b\u0001\n\u0003\u0011\u0007\u0002C6\u0006\u0005\u0003\u0005\u000b\u0011B2\t\u00111,!Q1A\u0005\u0002qC\u0001\"\\\u0003\u0003\u0002\u0003\u0006I!\u0018\u0005\t]\u0016\u0011)\u0019!C\u0001_\"A1/\u0002B\u0001B\u0003%\u0001\u000f\u0003\u0005u\u000b\t\u0015\r\u0011\"\u0001v\u0011!QXA!A!\u0002\u00131\b\"\u0002\u0016\u0006\t\u0003Y\b\"CA\u0003\u000b\t\u0007I\u0011BA\u0004\u0011!\ty!\u0002Q\u0001\n\u0005%\u0001\"CA\t\u000b\t\u0007I\u0011AA\u0004\u0011!\t\u0019\"\u0002Q\u0001\n\u0005%\u0001\"CA\u000b\u000b\t\u0007I\u0011BA\f\u0011!\tI#\u0002Q\u0001\n\u0005e\u0001bBA\u0016\u000b\u0011\u0005\u0013Q\u0006\u0005\b\u0003\u000b*A\u0011IA$\u0003!!\u0006N]8ui2,'BA\u000e\u001d\u0003\u0011IW\u000e\u001d7\u000b\u0005uq\u0012AB:ue\u0016\fWNC\u0001 \u0003\u0011\t7n[1\u0011\u0005\u0005\nQ\"\u0001\u000e\u0003\u0011QC'o\u001c;uY\u0016\u001c\"!\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0011\u0002+\u0005+Ho\\7bi&\u001cW*\u0019=j[Vl')\u001e:tiV\tqfD\u00011;\u0005y AF!vi>l\u0017\r^5d\u001b\u0006D\u0018.\\;n\u0005V\u00148\u000f\u001e\u0011)\u0005\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u001f\u0003)\tgN\\8uCRLwN\\\u0005\u0003qU\u00121\"\u00138uKJt\u0017\r\\!qS\"\u0012\u0001aM\u000b\u0003wI\u001b\"!\u0002\u001f\u0011\u0007uj\u0005K\u0004\u0002?\u0015:\u0011q\b\u0013\b\u0003\u0001\u001es!!\u0011$\u000f\u0005\t+U\"A\"\u000b\u0005\u0011[\u0013A\u0002\u001fs_>$h(C\u0001 \u0013\tib$\u0003\u0002\u001c9%\u0011\u0011JG\u0001\u0007MV\u001c\u0018N\\4\n\u0005-c\u0015aC$sCBD7\u000b^1hKNT!!\u0013\u000e\n\u00059{%AF*j[BdW\rT5oK\u0006\u0014xI]1qQN#\u0018mZ3\u000b\u0005-c\u0005CA)S\u0019\u0001!QaU\u0003C\u0002Q\u0013\u0011\u0001V\t\u0003+b\u0003\"!\n,\n\u0005]3#a\u0002(pi\"Lgn\u001a\t\u0003KeK!A\u0017\u0014\u0003\u0007\u0005s\u00170\u0001\u0003d_N$X#A/\u0011\u0005\u0015r\u0016BA0'\u0005\rIe\u000e^\u0001\u0006G>\u001cH\u000fI\u0001\u0004a\u0016\u0014X#A2\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005!4\u0013AC2p]\u000e,(O]3oi&\u0011!.\u001a\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003\u0011\u0001XM\u001d\u0011\u0002\u00195\f\u00070[7v[\n+(o\u001d;\u0002\u001b5\f\u00070[7v[\n+(o\u001d;!\u0003=\u0019wn\u001d;DC2\u001cW\u000f\\1uS>tW#\u00019\u0011\t\u0015\n\b+X\u0005\u0003e\u001a\u0012\u0011BR;oGRLwN\\\u0019\u0002!\r|7\u000f^\"bY\u000e,H.\u0019;j_:\u0004\u0013\u0001B7pI\u0016,\u0012A\u001e\t\u0003obl\u0011\u0001H\u0005\u0003sr\u0011A\u0002\u00165s_R$H.Z'pI\u0016\fQ!\\8eK\u0002\"\u0002\u0002`?\u007f\u007f\u0006\u0005\u00111\u0001\t\u0004C\u0015\u0001\u0006\"B.\u0011\u0001\u0004i\u0006\"B1\u0011\u0001\u0004\u0019\u0007\"\u00027\u0011\u0001\u0004i\u0006\"\u00028\u0011\u0001\u0004\u0001\b\"\u0002;\u0011\u0001\u00041\u0018A\u00058b]>\u001c()\u001a;xK\u0016tGk\\6f]N,\"!!\u0003\u0011\u0007\u0015\nY!C\u0002\u0002\u000e\u0019\u0012A\u0001T8oO\u0006\u0019b.\u00198pg\n+Go^3f]R{7.\u001a8tA\u0005)RM\u001a4fGRLg/Z'bq&lW/\u001c\"veN$\u0018AF3gM\u0016\u001cG/\u001b<f\u001b\u0006D\u0018.\\;n\u0005V\u00148\u000f\u001e\u0011\u0002\u0013QLW.\u001a:OC6,WCAA\r!\u0011\tY\"a\t\u000f\t\u0005u\u0011q\u0004\t\u0003\u0005\u001aJ1!!\t'\u0003\u0019\u0001&/\u001a3fM&!\u0011QEA\u0014\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0005\u0014\u0002\u0015QLW.\u001a:OC6,\u0007%A\u0006de\u0016\fG/\u001a'pO&\u001cG\u0003BA\u0018\u0003w\u0001B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003ka\u0012!B:uC\u001e,\u0017\u0002BA\u001d\u0003g\u0011qb\u0012:ba\"\u001cF/Y4f\u0019><\u0017n\u0019\u0005\b\u0003{9\u0002\u0019AA \u0003MIg\u000e[3sSR,G-\u0011;ue&\u0014W\u000f^3t!\r9\u0018\u0011I\u0005\u0004\u0003\u0007b\"AC!uiJL'-\u001e;fg\u0006AAo\\*ue&tw\r\u0006\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013\u0001\u00027b]\u001eT!!a\u0015\u0002\t)\fg/Y\u0005\u0005\u0003K\ti\u0005\u000b\u0002\u0006g\u0001")
@InternalApi
public class Throttle<T>
extends GraphStages.SimpleLinearGraphStage<T> {
    private final int cost;
    private final FiniteDuration per;
    private final int maximumBurst;
    private final Function1<T, Object> costCalculation;
    private final ThrottleMode mode;
    private final long akka$stream$impl$Throttle$$nanosBetweenTokens;
    private final long effectiveMaximumBurst;
    private final String akka$stream$impl$Throttle$$timerName;

    public static int AutomaticMaximumBurst() {
        return Throttle$.MODULE$.AutomaticMaximumBurst();
    }

    public int cost() {
        return this.cost;
    }

    public FiniteDuration per() {
        return this.per;
    }

    public int maximumBurst() {
        return this.maximumBurst;
    }

    public Function1<T, Object> costCalculation() {
        return this.costCalculation;
    }

    public ThrottleMode mode() {
        return this.mode;
    }

    public long akka$stream$impl$Throttle$$nanosBetweenTokens() {
        return this.akka$stream$impl$Throttle$$nanosBetweenTokens;
    }

    public long effectiveMaximumBurst() {
        return this.effectiveMaximumBurst;
    }

    public String akka$stream$impl$Throttle$$timerName() {
        return this.akka$stream$impl$Throttle$$timerName;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new TimerGraphStageLogic(this){
            private final NanoTimeTokenBucket akka$stream$impl$Throttle$$anon$$tokenBucket;
            private boolean akka$stream$impl$Throttle$$anon$$willStop;
            private T akka$stream$impl$Throttle$$anon$$currentElement;
            private final boolean akka$stream$impl$Throttle$$anon$$enforcing;
            private final /* synthetic */ Throttle $outer;

            public NanoTimeTokenBucket akka$stream$impl$Throttle$$anon$$tokenBucket() {
                return this.akka$stream$impl$Throttle$$anon$$tokenBucket;
            }

            private boolean willStop() {
                return this.akka$stream$impl$Throttle$$anon$$willStop;
            }

            public void akka$stream$impl$Throttle$$anon$$willStop_$eq(boolean x$1) {
                this.akka$stream$impl$Throttle$$anon$$willStop = x$1;
            }

            private T currentElement() {
                return this.akka$stream$impl$Throttle$$anon$$currentElement;
            }

            public void akka$stream$impl$Throttle$$anon$$currentElement_$eq(T x$1) {
                this.akka$stream$impl$Throttle$$anon$$currentElement = x$1;
            }

            public boolean akka$stream$impl$Throttle$$anon$$enforcing() {
                return this.akka$stream$impl$Throttle$$anon$$enforcing;
            }

            public void preStart() {
                this.akka$stream$impl$Throttle$$anon$$tokenBucket().init();
            }

            public void onTimer(Object key) {
                block0: {
                    this.push(this.$outer.out(), this.currentElement());
                    this.akka$stream$impl$Throttle$$anon$$currentElement_$eq(null);
                    if (!this.willStop()) break block0;
                    this.completeStage();
                }
            }

            public /* synthetic */ Throttle akka$stream$impl$Throttle$$anon$$$outer() {
                return this.$outer;
            }
            {
                boolean bl;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                this.akka$stream$impl$Throttle$$anon$$tokenBucket = new NanoTimeTokenBucket($outer.effectiveMaximumBurst(), $outer.akka$stream$impl$Throttle$$nanosBetweenTokens());
                this.akka$stream$impl$Throttle$$anon$$willStop = false;
                ThrottleMode throttleMode = $outer.mode();
                if (ThrottleMode$Enforcing$.MODULE$.equals(throttleMode)) {
                    bl = true;
                } else if (ThrottleMode$Shaping$.MODULE$.equals(throttleMode)) {
                    bl = false;
                } else {
                    throw new MatchError((Object)throttleMode);
                }
                this.akka$stream$impl$Throttle$$anon$$enforcing = bl;
                InHandler handler = new InHandler(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$(this);
                    }

                    public void onDownstreamFinish(Throwable cause) throws Exception {
                        OutHandler.onDownstreamFinish$(this, cause);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$(this, ex);
                    }

                    public void onUpstreamFinish() {
                        if (this.$outer.isAvailable(this.$outer.akka$stream$impl$Throttle$$anon$$$outer().out()) && this.$outer.isTimerActive(this.$outer.akka$stream$impl$Throttle$$anon$$$outer().akka$stream$impl$Throttle$$timerName())) {
                            this.$outer.akka$stream$impl$Throttle$$anon$$willStop_$eq(true);
                        } else {
                            this.$outer.completeStage();
                        }
                    }

                    public void onPush() {
                        T elem = this.$outer.grab(this.$outer.akka$stream$impl$Throttle$$anon$$$outer().in());
                        int cost = BoxesRunTime.unboxToInt((Object)this.$outer.akka$stream$impl$Throttle$$anon$$$outer().costCalculation().apply(elem));
                        long delayNanos = this.$outer.akka$stream$impl$Throttle$$anon$$tokenBucket().offer((long)cost);
                        if (delayNanos == 0L) {
                            this.$outer.push(this.$outer.akka$stream$impl$Throttle$$anon$$$outer().out(), elem);
                        } else if (this.$outer.akka$stream$impl$Throttle$$anon$$enforcing()) {
                            this.$outer.failStage(new RateExceededException("Maximum throttle throughput exceeded."));
                        } else {
                            this.$outer.akka$stream$impl$Throttle$$anon$$currentElement_$eq(elem);
                            this.$outer.scheduleOnce((Object)this.$outer.akka$stream$impl$Throttle$$anon$$$outer().akka$stream$impl$Throttle$$timerName(), new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(delayNanos)).nanos());
                        }
                    }

                    public void onPull() {
                        this.$outer.pull(this.$outer.akka$stream$impl$Throttle$$anon$$$outer().in());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        InHandler.$init$(this);
                        OutHandler.$init$(this);
                    }
                };
                this.setHandlers($outer.in(), $outer.out(), handler);
            }
        };
    }

    public String toString() {
        return "Throttle";
    }

    public Throttle(int cost, FiniteDuration per, int maximumBurst, Function1<T, Object> costCalculation, ThrottleMode mode) {
        this.cost = cost;
        this.per = per;
        this.maximumBurst = maximumBurst;
        this.costCalculation = costCalculation;
        this.mode = mode;
        Predef$.MODULE$.require(cost > 0, (Function0 & Serializable)() -> "cost must be > 0");
        Predef$.MODULE$.require(per.toNanos() > 0L, (Function0 & Serializable)() -> "per time must be > 0");
        Predef$.MODULE$.require(per.toNanos() >= (long)cost, (Function0 & Serializable)() -> "Rates larger than 1 unit / nanosecond are not supported");
        this.akka$stream$impl$Throttle$$nanosBetweenTokens = per.toNanos() / (long)cost;
        this.effectiveMaximumBurst = maximumBurst == -1 ? package$.MODULE$.max(1L, 100000000L / this.akka$stream$impl$Throttle$$nanosBetweenTokens()) : (long)maximumBurst;
        ThrottleMode throttleMode = mode;
        ThrottleMode$Enforcing$ throttleMode$Enforcing$ = ThrottleMode$Enforcing$.MODULE$;
        Predef$.MODULE$.require((throttleMode != null ? !throttleMode.equals(throttleMode$Enforcing$) : throttleMode$Enforcing$ != null) || this.effectiveMaximumBurst() >= 0L, (Function0 & Serializable)() -> "maximumBurst must be > 0 in Enforcing mode");
        this.akka$stream$impl$Throttle$$timerName = "ThrottleTimer";
    }
}

