/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.OffsetOrderVisitor;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public class ConstraintDefinitionNode
extends TableElementNode {
    private TableName constraintName;
    protected int constraintType;
    protected Properties properties;
    ProviderList apl;
    UUIDFactory uuidFactory;
    String backingIndexName;
    UUID backingIndexUUID;
    ResultColumnList columnList;
    String constraintText;
    ValueNode checkCondition;
    private int behavior;
    private int verifyType;
    public static final boolean DEFERRABLE_DEFAULT = false;
    public static final boolean INITIALLY_DEFERRED_DEFAULT = false;
    public static final boolean ENFORCED_DEFAULT = true;
    private boolean[] characteristics;

    ConstraintDefinitionNode(TableName tableName, int n, ResultColumnList resultColumnList, Properties properties, ValueNode valueNode, String string, int n2, int n3, ContextManager contextManager) {
        super(null, contextManager);
        this.constraintName = tableName;
        if (this.constraintName != null) {
            this.name = this.constraintName.getTableName();
        }
        this.constraintType = n;
        this.properties = properties;
        this.columnList = resultColumnList;
        this.checkCondition = valueNode;
        this.constraintText = string;
        this.behavior = n2;
        this.verifyType = n3;
    }

    void setCharacteristics(boolean[] blArray) {
        this.characteristics = (boolean[])blArray.clone();
    }

    boolean[] getCharacteristics() {
        if (this.characteristics == null) {
            this.characteristics = new boolean[]{false, false, true};
        }
        return (boolean[])this.characteristics.clone();
    }

    @Override
    public String toString() {
        return "";
    }

    void bind(DDLStatementNode dDLStatementNode, DataDictionary dataDictionary) throws StandardException {
        if (this.constraintType == 5) {
            return;
        }
        if (this.constraintName != null) {
            String string = this.constraintName.getSchemaName();
            if (string != null) {
                TableName tableName = dDLStatementNode.getObjectName();
                String string2 = tableName.getSchemaName();
                if (string2 == null) {
                    string2 = this.getSchemaDescriptor(null).getSchemaName();
                    tableName.setSchemaName(string2);
                }
                if (!string.equals(string2)) {
                    throw StandardException.newException((String)"42X85", (Object[])new Object[]{this.constraintName, tableName});
                }
            }
        } else {
            this.name = this.getBackingIndexName(dataDictionary);
        }
    }

    String getConstraintMoniker() {
        return this.name;
    }

    String getDropSchemaName() {
        if (this.constraintName != null) {
            return this.constraintName.getSchemaName();
        }
        return null;
    }

    UUID getBackingIndexUUID() {
        if (this.backingIndexUUID == null) {
            this.backingIndexUUID = this.getUUIDFactory().createUUID();
        }
        return this.backingIndexUUID;
    }

    String getBackingIndexName(DataDictionary dataDictionary) {
        if (this.backingIndexName == null) {
            this.backingIndexName = dataDictionary.getSystemSQLName();
        }
        return this.backingIndexName;
    }

    void setAuxiliaryProviderList(ProviderList providerList) {
        this.apl = providerList;
    }

    ProviderList getAuxiliaryProviderList() {
        return this.apl;
    }

    @Override
    boolean hasPrimaryKeyConstraint() {
        return this.constraintType == 2;
    }

    @Override
    boolean hasUniqueKeyConstraint() {
        return this.constraintType == 3;
    }

    @Override
    boolean hasForeignKeyConstraint() {
        return this.constraintType == 6;
    }

    @Override
    boolean hasCheckConstraint() {
        return this.constraintType == 4;
    }

    @Override
    boolean hasConstraint() {
        return true;
    }

    boolean requiresBackingIndex() {
        switch (this.constraintType) {
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    boolean requiresUniqueIndex() {
        switch (this.constraintType) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    int getConstraintType() {
        return this.constraintType;
    }

    void setProperties(Properties properties) {
        this.properties = properties;
    }

    Properties getProperties() {
        return this.properties;
    }

    boolean isReferenced() {
        return false;
    }

    int getReferenceCount() {
        return 0;
    }

    boolean isEnabled() {
        return true;
    }

    ResultColumnList getColumnList() {
        return this.columnList;
    }

    void setColumnList(ResultColumnList resultColumnList) {
        this.columnList = resultColumnList;
    }

    ValueNode getCheckCondition() {
        return this.checkCondition;
    }

    void setCheckCondition(ValueNode valueNode) {
        this.checkCondition = valueNode;
    }

    String getConstraintText() {
        return this.constraintText;
    }

    int getDropBehavior() {
        return this.behavior;
    }

    int getVerifyType() {
        return this.verifyType;
    }

    private UUIDFactory getUUIDFactory() {
        if (this.uuidFactory == null) {
            this.uuidFactory = ConstraintDefinitionNode.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.constraintName != null) {
            this.constraintName = (TableName)this.constraintName.accept(visitor);
        }
    }

    void qualifyNames() throws StandardException {
        OffsetOrderVisitor<TableName> offsetOrderVisitor = new OffsetOrderVisitor<TableName>(TableName.class, this.checkCondition.getBeginOffset(), this.checkCondition.getEndOffset() + 1);
        this.checkCondition.accept(offsetOrderVisitor);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = this.checkCondition.getBeginOffset();
        for (TableName tableName : offsetOrderVisitor.getNodes()) {
            stringBuilder.append(this.constraintText, n, tableName.getBeginOffset() - n2);
            stringBuilder.append(tableName.getFullSQLName());
            n = tableName.getEndOffset() + 1 - n2;
        }
        stringBuilder.append(this.constraintText, n, this.constraintText.length());
        this.constraintText = stringBuilder.toString();
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

