/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.InputStreamList;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;

public class ChangelogRewriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChangeLogRewriterResult removeChangeLogId(String changeLogFile, String changeLogId, DatabaseChangeLog databaseChangeLog) {
        Object object;
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        InputStreamList list = null;
        try {
            list = resourceAccessor.openStreams("", changeLogFile);
            List<URI> uris = list.getURIs();
            InputStream is2 = list.iterator().next();
            String encoding = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
            String changeLogString = StreamUtil.readStreamAsString(is2, encoding);
            if (changeLogFile.toLowerCase().endsWith(".xml")) {
                String changeLogIdString = " changeLogId=\"" + changeLogId + "\"";
                String editedString = changeLogString.replaceFirst(changeLogIdString, "");
                if (editedString.equals(changeLogString)) {
                    ChangeLogRewriterResult changeLogRewriterResult = new ChangeLogRewriterResult("Unable to update changeLogId in changelog file '" + changeLogFile + "'", false);
                    return changeLogRewriterResult;
                }
                changeLogString = editedString;
            } else if (changeLogFile.toLowerCase().endsWith(".sql")) {
                String newChangeLogString = changeLogString.replaceFirst("--(\\s*)liquibase formatted sql changeLogId:(\\s*)" + changeLogId, "-- liquibase formatted sql");
                if (newChangeLogString.equals(changeLogString)) {
                    ChangeLogRewriterResult editedString = new ChangeLogRewriterResult("Unable to update changeLogId in changelog file '" + changeLogFile + "'", false);
                    return editedString;
                }
                changeLogString = newChangeLogString;
            } else if (changeLogFile.toLowerCase().endsWith(".json")) {
                changeLogString = changeLogString.replaceFirst("\"changeLogId\":\"" + changeLogId + "\",", "\n");
            } else if (changeLogFile.toLowerCase().endsWith(".yml") || changeLogFile.toLowerCase().endsWith(".yaml")) {
                changeLogString = changeLogString.replaceFirst("- changeLogId: " + changeLogId, "");
            } else {
                ChangeLogRewriterResult newChangeLogString = new ChangeLogRewriterResult("Changelog file '" + changeLogFile + "' is not a supported format", false);
                return newChangeLogString;
            }
            File f2 = new File(uris.get(0).getPath());
            RandomAccessFile randomAccessFile = new RandomAccessFile(f2, "rw");
            object = null;
            try {
                randomAccessFile.setLength(0L);
                randomAccessFile.write(changeLogString.getBytes(encoding));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (randomAccessFile != null) {
                    if (object != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        randomAccessFile.close();
                    }
                }
            }
            if (databaseChangeLog != null) {
                databaseChangeLog.setChangeLogId(null);
            }
            String message = "The changeLogId has been removed from changelog '" + changeLogFile + "'.";
            Scope.getCurrentScope().getLog(ChangelogRewriter.class).info(message);
            object = new ChangeLogRewriterResult(message, true);
        }
        catch (IOException ioe) {
            String errorMessage = "Changelog file '" + changeLogFile + "' with changelog ID '" + changeLogId + "' was not deactivated due to an error: " + ioe.getMessage();
            Scope.getCurrentScope().getLog(ChangelogRewriter.class).warning(errorMessage);
            ChangeLogRewriterResult changeLogRewriterResult = new ChangeLogRewriterResult(errorMessage, false);
            return changeLogRewriterResult;
        }
        finally {
            try {
                if (list != null) {
                    list.close();
                }
            }
            catch (IOException iOException) {}
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChangeLogRewriterResult addChangeLogId(String changeLogFile, String changeLogId, DatabaseChangeLog databaseChangeLog) {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        InputStreamList list = null;
        try {
            list = resourceAccessor.openStreams("", changeLogFile);
            List<URI> uris = list.getURIs();
            InputStream is2 = list.iterator().next();
            String encoding = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
            String changeLogString = StreamUtil.readStreamAsString(is2, encoding);
            if (changeLogFile.toLowerCase().endsWith(".xml")) {
                String patternString = "(?ms).*<databaseChangeLog[^>]*>";
                Pattern pattern = Pattern.compile(patternString);
                Matcher matcher = pattern.matcher(changeLogString);
                if (matcher.find()) {
                    String header = changeLogString.substring(matcher.start(), matcher.end() - 1);
                    String xsdPatternString = "([dbchangelog|liquibase-pro])-3.[0-9]?[0-9]?.xsd";
                    Pattern xsdPattern = Pattern.compile(xsdPatternString);
                    Matcher xsdMatcher = xsdPattern.matcher(header);
                    String editedString = xsdMatcher.replaceAll("$1-" + XMLChangeLogSAXParser.getSchemaVersion() + ".xsd");
                    String outputChangeLogString = " changeLogId=\"" + changeLogId + "\"";
                    if (changeLogString.trim().endsWith("/>")) {
                        changeLogString = changeLogString.replaceFirst("/>", outputChangeLogString + "/>");
                    } else {
                        String outputHeader = editedString + outputChangeLogString + ">";
                        changeLogString = changeLogString.replaceFirst(patternString, outputHeader);
                    }
                }
            } else if (changeLogFile.toLowerCase().endsWith(".sql")) {
                String newChangeLogString = changeLogString.replaceFirst("--(\\s*)liquibase formatted sql", "-- liquibase formatted sql changeLogId:" + changeLogId);
                if (newChangeLogString.equals(changeLogString)) {
                    ChangeLogRewriterResult pattern = new ChangeLogRewriterResult("Unable to update changeLogId in changelog file '" + changeLogFile + "'", false);
                    return pattern;
                }
                changeLogString = newChangeLogString;
            } else if (changeLogFile.toLowerCase().endsWith(".json")) {
                changeLogString = changeLogString.replaceFirst("\\[", "\\[\n\"changeLogId\":\"" + changeLogId + "\",\n");
            } else if (changeLogFile.toLowerCase().endsWith(".yml") || changeLogFile.toLowerCase().endsWith(".yaml")) {
                changeLogString = changeLogString.replaceFirst("^databaseChangeLog:(\\s*)\n", "databaseChangeLog:$1\n- changeLogId: " + changeLogId + "$1\n");
            } else {
                ChangeLogRewriterResult newChangeLogString = new ChangeLogRewriterResult("Changelog file '" + changeLogFile + "' is not a supported format", false);
                return newChangeLogString;
            }
            File f2 = new File(uris.get(0).getPath());
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(f2, "rw");){
                randomAccessFile.write(changeLogString.getBytes(encoding));
            }
            if (databaseChangeLog != null) {
                databaseChangeLog.setChangeLogId(changeLogId);
            }
        }
        catch (IOException ioe) {
            ChangeLogRewriterResult changeLogRewriterResult = new ChangeLogRewriterResult("* Changelog file '" + changeLogFile + "' with changelog ID '" + changeLogId + "' was not registered due to an error: " + ioe.getMessage(), false);
            return changeLogRewriterResult;
        }
        finally {
            try {
                if (list != null) {
                    list.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new ChangeLogRewriterResult("* Changelog file '" + changeLogFile + "' has been updated with changelog ID '" + changeLogId + "'.", true);
    }

    public static class ChangeLogRewriterResult {
        public String message;
        public boolean success;

        public ChangeLogRewriterResult(String message, boolean success) {
            this.message = message;
            this.success = success;
        }
    }
}

