/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.NativeJpaQuery;
import org.springframework.data.jpa.repository.query.SimpleJpaQuery;
import org.springframework.data.jpa.repository.query.StoredProcedureJpaQuery;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;

enum JpaQueryFactory {
    INSTANCE;

    private static final SpelExpressionParser PARSER;

    AbstractJpaQuery fromMethodWithQueryString(JpaQueryMethod method, EntityManager em, String queryString, @Nullable String countQueryString, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return method.isNativeQuery() ? new NativeJpaQuery(method, em, queryString, countQueryString, evaluationContextProvider, PARSER) : new SimpleJpaQuery(method, em, queryString, countQueryString, evaluationContextProvider, PARSER);
    }

    public StoredProcedureJpaQuery fromProcedureAnnotation(JpaQueryMethod method, EntityManager em) {
        return new StoredProcedureJpaQuery(method, em);
    }

    static {
        PARSER = new SpelExpressionParser();
    }
}

