/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;

public class CheckForSpecificPatternsInSQL
extends AbstractLiquibaseDynamicForecastRule {
    public CheckForSpecificPatternsInSQL() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        Object object = dynamicRule.getParameter(DynamicRuleParameterEnum.SEARCH_STRING);
        Object object2 = dynamicRule.getParameter(DynamicRuleParameterEnum.MESSAGE);
        Objects.requireNonNull(object);
        Objects.requireNonNull(object2);
        object = Pattern.compile((String)((DynamicRuleParameter)object).getValue());
        object2 = (String)((DynamicRuleParameter)object2).getValue();
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof AbstractSQLChange) || !this.doCheck((AbstractSQLChange)change, (Pattern)object)) continue;
            CheckForSpecificPatternsInSQL checkForSpecificPatternsInSQL = this;
            checkForSpecificPatternsInSQL.addFailureRuleIteration(checkForSpecificPatternsInSQL.getFailureMessage((String)object2, (Pattern)object, changeSet), dynamicRule);
        }
        return this.returnAtEndOfRule(dynamicRule);
    }

    private boolean doCheck(AbstractSQLChange abstractSQLChange, Pattern pattern) {
        return pattern.matcher(abstractSQLChange.getSql()).find();
    }

    private String getFailureMessage(String string, Pattern pattern, ChangeSet changeSet) {
        return string.replace("<" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + ">", pattern.pattern()).replace("<CHANGESET>", changeSet.getId());
    }

    @Override
    public String getDescription() {
        return "This check scans raw SQL for the presence of specific patterns and warns the user when they are found.";
    }

    @Override
    public String getShortName() {
        return "SqlUserDefinedPatternCheck";
    }

    @Override
    public int getPriority() {
        return 60;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.SEARCH_STRING), new RuleParameter(DynamicRuleParameterEnum.MESSAGE));
    }
}

