/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import java.util.List;
import org.springframework.cloud.config.server.composite.CompositeEnvironmentBeanFactoryPostProcessor;
import org.springframework.cloud.config.server.composite.ConditionalOnMissingSearchPathLocator;
import org.springframework.cloud.config.server.composite.ConditionalOnSearchPathLocator;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.CompositeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathCompositeEnvironmentRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@Profile(value={"composite"})
class CompositeRepositoryConfiguration {
    CompositeRepositoryConfiguration() {
    }

    @Bean
    public static CompositeEnvironmentBeanFactoryPostProcessor compositeEnvironmentRepositoryBeanFactoryPostProcessor(Environment environment) {
        return new CompositeEnvironmentBeanFactoryPostProcessor(environment);
    }

    @Primary
    @Bean
    @ConditionalOnSearchPathLocator
    public SearchPathCompositeEnvironmentRepository searchPathCompositeEnvironmentRepository(List<EnvironmentRepository> environmentRepositories, ConfigServerProperties properties) {
        return new SearchPathCompositeEnvironmentRepository(environmentRepositories, properties.isFailOnCompositeError());
    }

    @Primary
    @Bean
    @ConditionalOnMissingSearchPathLocator
    public CompositeEnvironmentRepository compositeEnvironmentRepository(List<EnvironmentRepository> environmentRepositories, ConfigServerProperties properties) {
        return new CompositeEnvironmentRepository(environmentRepositories, properties.isFailOnCompositeError());
    }
}

