/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.callback.ServerCallbackProxy;
import org.rzo.netty.ahessian.rpc.message.FlushRequestMessage;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;
import org.rzo.netty.ahessian.rpc.server.HessianSkeleton;
import org.rzo.netty.ahessian.utils.MyReentrantLock;
import org.rzo.netty.ahessian.utils.TimedBlockingPriorityQueue;

@ChannelHandler.Sharable
public class HessianRPCServiceHandler
extends ChannelInboundHandlerAdapter
implements Constants {
    private Map<String, HessianSkeleton> _services = new HashMap<String, HessianSkeleton>();
    private TimedBlockingPriorityQueue<HessianRPCReplyMessage> _pendingReplies;
    private TimedBlockingPriorityQueue<HessianRPCCallMessage> _pendingCalls;
    private LinkedBlockingQueue<HessianRPCReplyMessage> _repliesRetry;
    private Executor _executor;
    private boolean _stop = false;
    final AtomicLong _openCounter = new AtomicLong(0L);
    final Lock _lock = new MyReentrantLock();
    final Condition _channelOpen = this._lock.newCondition();
    boolean _inverseServer = false;
    ConnectListener _connectListener;
    ConnectListener _disconnectListener;

    public HessianRPCServiceHandler(Executor executor) {
        this(executor, null, null, false);
    }

    public HessianRPCServiceHandler(Executor executor, boolean inverseServer) {
        this(executor, null, null, inverseServer);
    }

    public HessianRPCServiceHandler(Executor executor, Map<String, Object> options, Timer timer) {
        this(executor, options, timer, false);
    }

    public void setConnectListener(ConnectListener listener) {
        this._connectListener = listener;
    }

    public void setDisconnectListener(ConnectListener listener) {
        this._disconnectListener = listener;
    }

    public HessianRPCServiceHandler(Executor executor, Map<String, Object> options, Timer timer, boolean inverseServer) {
        this._inverseServer = inverseServer;
        this._executor = executor;
        this._pendingReplies = options == null || timer == null ? new TimedBlockingPriorityQueue("HessianRPCServiceHandler-PendingReplies") : new TimedBlockingPriorityQueue(options, null, "HessianRPCServiceHandler-PendingReplies");
        this._pendingCalls = options == null || timer == null ? new TimedBlockingPriorityQueue("HessianRPCServiceHandler-PendingCalls") : new TimedBlockingPriorityQueue(options, null, "HessianRPCServiceHandler-PendingCalls");
        this._repliesRetry = new LinkedBlockingQueue();
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("HessianRPCServiceHandler-Call-Rx");
                HessianRPCCallMessage message = null;
                while (!HessianRPCServiceHandler.this._stop) {
                    try {
                        message = (HessianRPCCallMessage)HessianRPCServiceHandler.this._pendingCalls.take();
                        HessianSkeleton service = HessianRPCServiceHandler.this.getService(message);
                        service.messageReceived(message);
                    }
                    catch (Exception ex) {
                        Constants.ahessianLogger.warn("", (Throwable)ex);
                    }
                }
            }
        });
    }

    protected void sendMessage(HessianRPCReplyMessage message) {
        Channel ch = message.getChannel();
        if (ch != null) {
            boolean i = false;
            while (!ch.isWritable() && ch.isActive()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ch.write((Object)message);
            if (this._inverseServer) {
                ch.write((Object)new FlushRequestMessage());
            }
        } else {
            ahessianLogger.warn("message channel null -> ignored: #" + message.getCallId());
        }
    }

    public void addService(String name, HessianSkeleton service) {
        this._services.put(name, service);
    }

    public void removeService(String name) {
        this._services.remove(name);
    }

    public void channelRead(ChannelHandlerContext ctx, Object obj) throws Exception {
        if (obj instanceof HessianRPCCallMessage) {
            HessianRPCCallMessage message = (HessianRPCCallMessage)obj;
            Long callbackCallId = (Long)message.getHeaders().get(Constants.CALLBACK_CALL_ID_HEADER_KEY);
            if (callbackCallId == null) {
                Integer group = (Integer)message.getHeaders().get(Constants.GROUP_HEADER_KEY);
                this._pendingCalls.put(message, group);
            } else {
                this.handleCallbackReply(message);
            }
        } else {
            throw new RuntimeException("unexpected message type: " + obj.getClass());
        }
        ctx.fireChannelReadComplete();
    }

    private void handleCallbackReply(HessianRPCCallMessage message) {
        ServerCallbackProxy.setCallbackResult(message);
    }

    private HessianSkeleton getService(HessianRPCCallMessage message) {
        String id = (String)message.getHeaders().get(SERVICE_ID_HEADER_KEY);
        if (id == null) {
            id = "default";
        }
        return this._services.get(id);
    }

    public void writeResult(HessianRPCReplyMessage message) {
        this.sendMessage(message);
    }

    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        ahessianLogger.warn(ctx.channel() + " connected");
        if (this._openCounter.incrementAndGet() == 1L) {
            this._lock.lock();
            try {
                this._channelOpen.signal();
            }
            catch (Exception exception) {
            }
            finally {
                this._lock.unlock();
            }
        }
        super.channelActive(ctx);
        if (this._connectListener != null) {
            this._executor.execute(new Runnable(){

                @Override
                public void run() {
                    HessianRPCServiceHandler.this._connectListener.run(ctx.channel());
                }
            });
        }
    }

    public void channelInactive(final ChannelHandlerContext ctx) throws Exception {
        ahessianLogger.warn(ctx.channel() + " disconnected");
        this._openCounter.decrementAndGet();
        ctx.fireChannelInactive();
        if (this._disconnectListener != null) {
            this._executor.execute(new Runnable(){

                @Override
                public void run() {
                    HessianRPCServiceHandler.this._disconnectListener.run(ctx.channel());
                }
            });
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        e.printStackTrace();
        ahessianLogger.warn(ctx.channel() + " exception " + e.getCause());
    }

    public void stop() {
        this._stop = true;
    }

    public static interface ConnectListener
    extends Runnable {
        public void run(Channel var1);
    }
}

