/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage;

public class CreateSessionMessage_V2
extends CreateSessionMessage {
    private String clientID = null;

    public CreateSessionMessage_V2(String name, long sessionChannelID, int version, String username, String password, int minLargeMessageSize, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int windowSize, String defaultAddress, String clientID) {
        super((byte)-18, name, sessionChannelID, version, username, password, minLargeMessageSize, xa, autoCommitSends, autoCommitAcks, preAcknowledge, windowSize, defaultAddress);
        this.clientID = clientID;
    }

    public CreateSessionMessage_V2() {
        super((byte)-18);
    }

    public String getClientID() {
        return this.clientID;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeNullableString(this.clientID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.clientID = buffer.readNullableString();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(this.getParentString());
        buf.append(", metadata=" + this.clientID);
        buf.append("]");
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.clientID == null ? 0 : this.clientID.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateSessionMessage_V2)) {
            return false;
        }
        CreateSessionMessage_V2 other = (CreateSessionMessage_V2)obj;
        return !(this.clientID == null ? other.clientID != null : !this.clientID.equals(other.clientID));
    }
}

