/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.bzip2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.bzip2.Bzip2FileSystem;
import org.apache.commons.vfs2.provider.compressed.CompressedFileFileObject;
import org.apache.commons.vfs2.provider.compressed.CompressedFileFileSystem;

public class Bzip2FileObject
extends CompressedFileFileObject<Bzip2FileSystem> {
    @Deprecated
    protected Bzip2FileObject(AbstractFileName name, FileObject container, CompressedFileFileSystem fs) {
        super(name, container, Bzip2FileObject.cast(fs));
    }

    protected Bzip2FileObject(AbstractFileName name, FileObject container, Bzip2FileSystem fs) {
        super(name, container, fs);
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        InputStream is = this.getContainer().getContent().getInputStream();
        return Bzip2FileObject.wrapInputStream(this.getName().getURI(), is);
    }

    public static InputStream wrapInputStream(String name, InputStream is) throws IOException {
        return new BZip2CompressorInputStream(is);
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        OutputStream os = this.getContainer().getContent().getOutputStream(false);
        return new BZip2CompressorOutputStream(os);
    }

    private static Bzip2FileSystem cast(CompressedFileFileSystem fs) {
        if (fs instanceof Bzip2FileSystem) {
            return (Bzip2FileSystem)fs;
        }
        throw new IllegalArgumentException("Bzip2FileObject requires a Bzip2FileSystem implementation");
    }
}

