/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycleValidator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.cloud.client.loadbalancer.RetryableRequestContext;
import org.springframework.cloud.client.loadbalancer.reactive.ExchangeFilterFunctionUtils;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancedExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryContext;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryPolicy;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.RetryableStatusCodeException;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetrySpec;

public class RetryableLoadBalancerExchangeFilterFunction
implements LoadBalancedExchangeFilterFunction {
    private static final Log LOG = LogFactory.getLog(RetryableLoadBalancerExchangeFilterFunction.class);
    private static final List<Class<? extends Throwable>> exceptions = Arrays.asList(IOException.class, TimeoutException.class, RetryableStatusCodeException.class);
    private final LoadBalancerRetryPolicy retryPolicy;
    private final LoadBalancerProperties properties;
    private final ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory;

    public RetryableLoadBalancerExchangeFilterFunction(LoadBalancerRetryPolicy retryPolicy, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory, LoadBalancerProperties properties) {
        this.retryPolicy = retryPolicy;
        this.loadBalancerFactory = loadBalancerFactory;
        this.properties = properties;
    }

    public Mono<ClientResponse> filter(ClientRequest clientRequest, ExchangeFunction next) {
        LoadBalancerRetryContext loadBalancerRetryContext = new LoadBalancerRetryContext(clientRequest);
        Retry exchangeRetry = this.buildRetrySpec(this.properties.getRetry().getMaxRetriesOnSameServiceInstance(), true);
        Retry filterRetry = this.buildRetrySpec(this.properties.getRetry().getMaxRetriesOnNextServiceInstance(), false);
        URI originalUrl = clientRequest.url();
        String serviceId = originalUrl.getHost();
        if (serviceId == null) {
            String message = String.format("Request URI does not contain a valid hostname: %s", originalUrl.toString());
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)message);
            }
            return Mono.just((Object)ClientResponse.create((HttpStatus)HttpStatus.BAD_REQUEST).body(message).build());
        }
        Set<LoadBalancerLifecycle> supportedLifecycleProcessors = LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors(this.loadBalancerFactory.getInstances(serviceId, LoadBalancerLifecycle.class), RetryableRequestContext.class, ResponseData.class, ServiceInstance.class);
        String hint = ExchangeFilterFunctionUtils.getHint(serviceId, this.properties.getHint());
        RequestData requestData = new RequestData(clientRequest);
        DefaultRequest<RetryableRequestContext> lbRequest = new DefaultRequest<RetryableRequestContext>(new RetryableRequestContext(null, requestData, hint));
        supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStart(lbRequest));
        return Mono.defer(() -> this.choose(serviceId, lbRequest).flatMap(lbResponse -> {
            ServiceInstance instance = (ServiceInstance)lbResponse.getServer();
            lbRequest.setContext(new RetryableRequestContext(instance, requestData, hint));
            if (instance == null) {
                String message = ExchangeFilterFunctionUtils.serviceInstanceUnavailableMessage(serviceId);
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)message);
                }
                supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.DISCARD, lbRequest, lbResponse)));
                return Mono.just((Object)ClientResponse.create((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).body(ExchangeFilterFunctionUtils.serviceInstanceUnavailableMessage(serviceId)).build());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("LoadBalancer has retrieved the instance for service %s: %s", serviceId, instance.getUri()));
            }
            LoadBalancerProperties.StickySession stickySessionProperties = this.properties.getStickySession();
            ClientRequest newRequest = ExchangeFilterFunctionUtils.buildClientRequest(clientRequest, instance, stickySessionProperties.getInstanceIdCookieName(), stickySessionProperties.isAddServiceInstanceCookie());
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStartRequest(lbRequest, lbResponse));
            return next.exchange(newRequest).doOnError(throwable -> supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.FAILED, (Throwable)throwable, lbRequest, lbResponse)))).doOnSuccess(clientResponse -> supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.SUCCESS, lbRequest, lbResponse, new ResponseData((ClientResponse)clientResponse, requestData))))).map(clientResponse -> {
                loadBalancerRetryContext.setClientResponse((ClientResponse)clientResponse);
                if (this.shouldRetrySameServiceInstance(loadBalancerRetryContext)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Retrying on status code: %d", clientResponse.statusCode().value()));
                    }
                    throw new RetryableStatusCodeException();
                }
                return clientResponse;
            });
        }).map(clientResponse -> {
            loadBalancerRetryContext.setClientResponse((ClientResponse)clientResponse);
            if (this.shouldRetryNextServiceInstance(loadBalancerRetryContext)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Retrying on status code: %d", clientResponse.statusCode().value()));
                }
                throw new RetryableStatusCodeException();
            }
            return clientResponse;
        }).retryWhen(exchangeRetry)).retryWhen(filterRetry);
    }

    private Retry buildRetrySpec(int max, boolean transientErrors) {
        LoadBalancerProperties.Retry.Backoff backoffProperties = this.properties.getRetry().getBackoff();
        if (backoffProperties.isEnabled()) {
            return RetrySpec.backoff((long)max, (Duration)backoffProperties.getMinBackoff()).filter(this::isRetryException).maxBackoff(backoffProperties.getMaxBackoff()).jitter(backoffProperties.getJitter()).transientErrors(transientErrors);
        }
        return RetrySpec.max((long)max).filter(this::isRetryException).transientErrors(transientErrors);
    }

    private boolean shouldRetrySameServiceInstance(LoadBalancerRetryContext loadBalancerRetryContext) {
        boolean shouldRetry;
        boolean bl = shouldRetry = this.retryPolicy.retryableStatusCode(loadBalancerRetryContext.getResponseStatusCode()) && this.retryPolicy.canRetryOnMethod(loadBalancerRetryContext.getRequestMethod()) && this.retryPolicy.canRetrySameServiceInstance(loadBalancerRetryContext);
        if (shouldRetry) {
            loadBalancerRetryContext.incrementRetriesSameServiceInstance();
        }
        return shouldRetry;
    }

    private boolean shouldRetryNextServiceInstance(LoadBalancerRetryContext loadBalancerRetryContext) {
        boolean shouldRetry;
        boolean bl = shouldRetry = this.retryPolicy.retryableStatusCode(loadBalancerRetryContext.getResponseStatusCode()) && this.retryPolicy.canRetryOnMethod(loadBalancerRetryContext.getRequestMethod()) && this.retryPolicy.canRetryNextServiceInstance(loadBalancerRetryContext);
        if (shouldRetry) {
            loadBalancerRetryContext.incrementRetriesNextServiceInstance();
            loadBalancerRetryContext.resetRetriesSameServiceInstance();
        }
        return shouldRetry;
    }

    private boolean isRetryException(Throwable throwable) {
        return exceptions.stream().anyMatch(exception -> exception.isInstance(throwable) || throwable != null && exception.isInstance(throwable.getCause()) || Exceptions.isRetryExhausted((Throwable)throwable));
    }

    protected Mono<Response<ServiceInstance>> choose(String serviceId, Request<RetryableRequestContext> request) {
        ReactiveLoadBalancer<ServiceInstance> loadBalancer = this.loadBalancerFactory.getInstance(serviceId);
        if (loadBalancer == null) {
            return Mono.just((Object)new EmptyResponse());
        }
        return Mono.from(loadBalancer.choose(request));
    }
}

