/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

public class WinRSCommandLinePasswordSanitizer {
    protected static final char[] SPECIAL_CHARS = " |<>&^\r\n".toCharArray();
    protected static final String WHITE_SPACE = " ";
    protected static final Character ESCAPE_CHAR = Character.valueOf('^');

    public static String sanitize(String str) {
        if (str.contains(WHITE_SPACE)) {
            return "\"" + str + "\"";
        }
        return WinRSCommandLinePasswordSanitizer.escapeSpecialCharacters(str);
    }

    protected static String escapeSpecialCharacters(String str) {
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < str.length(); ++j) {
            char c = str.charAt(j);
            if (WinRSCommandLinePasswordSanitizer.contains(c, SPECIAL_CHARS)) {
                builder.append(ESCAPE_CHAR);
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static boolean containsAnySpecialChars(String str) {
        for (char c : SPECIAL_CHARS) {
            if (str.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(char c, char[] chars) {
        for (char caret_char : chars) {
            if (caret_char != c) continue;
            return true;
        }
        return false;
    }
}

