/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.replication.ReplicationEndpoint;
import org.apache.activemq.artemis.core.server.LiveNodeLocator;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.BackupManager;
import org.jboss.logging.Logger;

final class ReplicationObserver
implements ClusterTopologyListener,
SessionFailureListener,
LiveNodeLocator.BackupRegistrationListener,
ReplicationEndpoint.ReplicationEndpointEventListener,
AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(ReplicationObserver.class);
    private final NodeManager nodeManager;
    private final BackupManager backupManager;
    private final ScheduledExecutorService scheduledPool;
    private final boolean failback;
    private final String expectedNodeID;
    private final CompletableFuture<ReplicationFailure> replicationFailure;
    @GuardedBy(value="this")
    private ClientSessionFactoryInternal sessionFactory;
    @GuardedBy(value="this")
    private CoreRemotingConnection connection;
    @GuardedBy(value="this")
    private ScheduledFuture<?> forcedFailover;
    private volatile String liveID;
    private volatile boolean backupUpToDate;
    private volatile boolean closed;
    public static final int WAIT_TIME_AFTER_FIRST_LIVE_STOPPING_MSG = 60;

    private ReplicationObserver(NodeManager nodeManager, BackupManager backupManager, ScheduledExecutorService scheduledPool, boolean failback, String expectedNodeID) {
        this.nodeManager = nodeManager;
        this.backupManager = backupManager;
        this.scheduledPool = scheduledPool;
        this.failback = failback;
        this.expectedNodeID = expectedNodeID;
        this.replicationFailure = new CompletableFuture();
        this.sessionFactory = null;
        this.connection = null;
        this.forcedFailover = null;
        this.liveID = null;
        this.backupUpToDate = false;
        this.closed = false;
    }

    public static ReplicationObserver failbackObserver(NodeManager nodeManager, BackupManager backupManager, ScheduledExecutorService scheduledPool, String expectedNodeID) {
        Objects.requireNonNull(expectedNodeID);
        return new ReplicationObserver(nodeManager, backupManager, scheduledPool, true, expectedNodeID);
    }

    public static ReplicationObserver failoverObserver(NodeManager nodeManager, BackupManager backupManager, ScheduledExecutorService scheduledPool) {
        return new ReplicationObserver(nodeManager, backupManager, scheduledPool, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLiveDown(boolean voluntaryFailover) {
        if (this.closed || this.replicationFailure.isDone()) {
            return;
        }
        ReplicationObserver replicationObserver = this;
        synchronized (replicationObserver) {
            if (this.closed || this.replicationFailure.isDone()) {
                return;
            }
            this.stopForcedFailoverAfterDelay();
            this.unlistenConnectionFailures();
            if (!this.isRemoteBackupUpToDate()) {
                this.replicationFailure.complete(ReplicationFailure.BackupNotInSync);
            } else if (voluntaryFailover) {
                this.replicationFailure.complete(ReplicationFailure.VoluntaryFailOver);
            } else {
                this.replicationFailure.complete(ReplicationFailure.NonVoluntaryFailover);
            }
        }
    }

    public void nodeDown(long eventUID, String nodeID) {
        if (this.failback) {
            return;
        }
        if (nodeID.equals(this.liveID)) {
            this.onLiveDown(false);
        }
    }

    public void nodeUP(TopologyMember member, boolean last) {
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver) {
        this.onLiveDown(false);
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
        this.connectionFailed(me, failedOver);
    }

    public void beforeReconnect(ActiveMQException exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        ReplicationObserver replicationObserver = this;
        synchronized (replicationObserver) {
            if (this.closed) {
                return;
            }
            this.unlistenConnectionFailures();
            this.closed = true;
            this.replicationFailure.complete(ReplicationFailure.ClosedObserver);
        }
    }

    public synchronized void listenConnectionFailuresOf(ClientSessionFactoryInternal liveSessionFactory) {
        if (this.closed) {
            throw new IllegalStateException("the observer is closed: cannot listen to any failures");
        }
        if (this.sessionFactory != null || this.connection != null) {
            throw new IllegalStateException("this observer is already listening to other session factory failures");
        }
        this.sessionFactory = liveSessionFactory;
        this.sessionFactory.addFailureListener((SessionFailureListener)this);
        this.connection = (CoreRemotingConnection)liveSessionFactory.getConnection();
        this.connection.addFailureListener((FailureListener)this);
    }

    public synchronized void unlistenConnectionFailures() {
        if (this.connection != null) {
            this.connection.removeFailureListener((FailureListener)this);
            this.connection = null;
        }
        if (this.sessionFactory != null) {
            this.sessionFactory.removeFailureListener((SessionFailureListener)this);
            this.sessionFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBackupRegistrationFailed(boolean alreadyReplicating) {
        if (this.closed || this.replicationFailure.isDone()) {
            return;
        }
        ReplicationObserver replicationObserver = this;
        synchronized (replicationObserver) {
            if (this.closed || this.replicationFailure.isDone()) {
                return;
            }
            this.stopForcedFailoverAfterDelay();
            this.unlistenConnectionFailures();
            this.replicationFailure.complete(alreadyReplicating ? ReplicationFailure.AlreadyReplicating : ReplicationFailure.RegistrationError);
        }
    }

    public ReplicationFailure awaitReplicationFailure() {
        try {
            return this.replicationFailure.get();
        }
        catch (Throwable e) {
            return ReplicationFailure.ClosedObserver;
        }
    }

    private synchronized void scheduleForcedFailoverAfterDelay() {
        if (this.forcedFailover != null) {
            return;
        }
        this.forcedFailover = this.scheduledPool.schedule(() -> this.onLiveDown(false), 60L, TimeUnit.SECONDS);
    }

    private synchronized void stopForcedFailoverAfterDelay() {
        if (this.forcedFailover == null) {
            return;
        }
        this.forcedFailover.cancel(false);
        this.forcedFailover = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRemoteBackupUpToDate() {
        if (this.backupUpToDate || this.closed || this.replicationFailure.isDone()) {
            return;
        }
        ReplicationObserver replicationObserver = this;
        synchronized (replicationObserver) {
            if (this.backupUpToDate || this.closed || this.replicationFailure.isDone()) {
                return;
            }
            assert (this.liveID != null);
            this.backupManager.announceBackup();
            this.backupUpToDate = true;
        }
    }

    public boolean isBackupUpToDate() {
        return this.backupUpToDate;
    }

    public String getLiveID() {
        return this.liveID;
    }

    private boolean validateNodeId(String nodeID) {
        if (nodeID == null) {
            return false;
        }
        String existingNodeId = this.liveID;
        if (existingNodeId == null) {
            if (!this.failback) {
                return true;
            }
            return nodeID.equals(this.expectedNodeID);
        }
        return existingNodeId.equals(nodeID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLiveNodeId(String nodeId) {
        if (this.closed || this.replicationFailure.isDone()) {
            return;
        }
        String existingNodeId = this.liveID;
        if (existingNodeId != null && existingNodeId.equals(nodeId)) {
            return;
        }
        ReplicationObserver replicationObserver = this;
        synchronized (replicationObserver) {
            if (this.closed || this.replicationFailure.isDone()) {
                return;
            }
            if (!this.validateNodeId(nodeId)) {
                this.stopForcedFailoverAfterDelay();
                this.unlistenConnectionFailures();
                this.replicationFailure.complete(ReplicationFailure.WrongNodeId);
            } else if (this.liveID == null) {
                this.liveID = nodeId;
                this.nodeManager.setNodeID(nodeId);
            }
        }
    }

    public boolean isRemoteBackupUpToDate() {
        return this.backupUpToDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLiveStopping(ReplicationLiveIsStoppingMessage.LiveStopping finalMessage) {
        if (this.closed || this.replicationFailure.isDone()) {
            return;
        }
        ReplicationObserver replicationObserver = this;
        synchronized (replicationObserver) {
            if (this.closed || this.replicationFailure.isDone()) {
                return;
            }
            switch (finalMessage) {
                case STOP_CALLED: {
                    this.scheduleForcedFailoverAfterDelay();
                    break;
                }
                case FAIL_OVER: {
                    this.onLiveDown(true);
                    break;
                }
                default: {
                    LOGGER.errorf("unsupported LiveStopping type: %s", (Object)finalMessage);
                }
            }
        }
    }

    public static enum ReplicationFailure {
        VoluntaryFailOver,
        BackupNotInSync,
        NonVoluntaryFailover,
        RegistrationError,
        AlreadyReplicating,
        ClosedObserver,
        WrongNodeId;

    }
}

