/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.openmbean.CompositeData;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.messagecounter.MessageCounter;
import org.apache.activemq.artemis.core.messagecounter.impl.MessageCounterHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.selector.filter.Filterable;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;

public class QueueControlImpl
extends AbstractControl
implements QueueControl {
    public static final int FLUSH_LIMIT = 500;
    private final Queue queue;
    private final String address;
    private final ActiveMQServer server;
    private final StorageManager storageManager;
    private final SecurityStore securityStore;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private MessageCounter counter;

    private static String toJSON(Map<String, Object>[] messages) {
        JsonArray array = QueueControlImpl.toJSONMsgArray(messages);
        return array.toString();
    }

    private static JsonArray toJSONMsgArray(Map<String, Object>[] messages) {
        JsonArrayBuilder array = JsonLoader.createArrayBuilder();
        for (Map<String, Object> message : messages) {
            array.add((JsonValue)JsonUtil.toJsonObject(message));
        }
        return array.build();
    }

    private static String toJSON(Map<String, Map<String, Object>[]> messages) {
        JsonArrayBuilder arrayReturn = JsonLoader.createArrayBuilder();
        for (Map.Entry<String, Map<String, Object>[]> entry : messages.entrySet()) {
            JsonObjectBuilder objectItem = JsonLoader.createObjectBuilder();
            objectItem.add("consumerName", entry.getKey());
            objectItem.add("elements", (JsonValue)QueueControlImpl.toJSONMsgArray(entry.getValue()));
            arrayReturn.add(objectItem);
        }
        return arrayReturn.build().toString();
    }

    public QueueControlImpl(Queue queue, String address, ActiveMQServer server, StorageManager storageManager, SecurityStore securityStore, HierarchicalRepository<AddressSettings> addressSettingsRepository) throws Exception {
        super(QueueControl.class, storageManager);
        this.queue = queue;
        this.address = address;
        this.server = server;
        this.storageManager = storageManager;
        this.securityStore = securityStore;
        this.addressSettingsRepository = addressSettingsRepository;
    }

    public void setMessageCounter(MessageCounter counter) {
        this.counter = counter;
    }

    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName((Object)this.queue);
        }
        this.clearIO();
        try {
            String string = this.queue.getName().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getAddress() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getAddress((Object)this.queue);
        }
        this.checkStarted();
        return this.address;
    }

    public String getFilter() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFilter((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = this.queue.getFilter();
            String string = filter != null ? filter.getFilterString().toString() : null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isDurable() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isDurable((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isDurable();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getUser() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getUser((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            SimpleString user = this.queue.getUser();
            String string = user == null ? null : user.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getRoutingType() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRoutingType((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.queue.getRoutingType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isTemporary() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isTemporary((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isTemporary();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isRetroactiveResource() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isRetroactiveResource((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = ResourceNames.isRetroactiveResource((String)this.server.getInternalNamingPrefix(), (SimpleString)this.queue.getName());
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getMessageCount() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessageCount((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getMessageCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getPersistentSize() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getPersistentSize((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getPersistentSize();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getDurableMessageCount() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getDurableMessageCount((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getDurableMessageCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getDurablePersistentSize() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getDurablePersistSize((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getDurablePersistentSize();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getConsumerCount() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getConsumerCount((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getConsumerCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getDeliveringCount() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getDeliveringCount((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getDeliveringCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getDeliveringSize() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getDeliveringSize((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getDeliveringSize();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getDurableDeliveringCount() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getDurableDeliveringCount((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getDurableDeliveringCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getDurableDeliveringSize() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getDurableDeliveringSize((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getDurableDeliveringSize();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getMessagesAdded() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesAdded((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getMessagesAdded();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getMessagesAcknowledged() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesAcknowledged((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getMessagesAcknowledged();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getAcknowledgeAttempts() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesAcknowledged((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getAcknowledgeAttempts();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getMessagesExpired() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesExpired((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getMessagesExpired();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getMessagesKilled() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesKilled((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getMessagesKilled();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getID() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getID((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getID();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getScheduledCount() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getScheduledCount((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getScheduledCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getScheduledSize() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getScheduledSize((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getScheduledSize();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getDurableScheduledCount() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getDurableScheduledCount((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getDurableScheduledCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getDurableScheduledSize() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getDurableScheduledSize((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getDurableScheduledSize();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getDeadLetterAddress() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getDeadLetterAddress((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address);
            if (addressSettings != null && addressSettings.getDeadLetterAddress() != null) {
                String string = addressSettings.getDeadLetterAddress().toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getExpiryAddress() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getExpiryAddress((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address);
            if (addressSettings != null && addressSettings.getExpiryAddress() != null) {
                String string = addressSettings.getExpiryAddress().toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getMaxConsumers() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMaxConsumers((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getMaxConsumers();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isPurgeOnNoConsumers() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isPurgeOnNoConsumers((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isPurgeOnNoConsumers();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void disable() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.disable((Object)this.queue, (Object[])new Object[0]);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.server.getPostOffice().updateQueue(this.queue.getQueueConfiguration().setEnabled(Boolean.valueOf(false)));
        }
        finally {
            this.blockOnIO();
        }
    }

    public void enable() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.enable((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.server.getPostOffice().updateQueue(this.queue.getQueueConfiguration().setEnabled(Boolean.valueOf(true)));
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isEnabled() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isEnabled((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isConfigurationManaged() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isConfigurationManaged((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isConfigurationManaged();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isExclusive() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isExclusive((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isExclusive();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isLastValue() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isLastValue((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isLastValue();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getLastValueKey() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.lastValueKey((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            if (this.queue.getLastValueKey() != null) {
                String string = this.queue.getLastValueKey().toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getConsumersBeforeDispatch() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.consumersBeforeDispatch((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getConsumersBeforeDispatch();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getDelayBeforeDispatch() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.delayBeforeDispatch((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getDelayBeforeDispatch();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public Map<String, Object>[] listScheduledMessages() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.listScheduledMessages((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            List<MessageReference> refs = this.queue.getScheduledMessages();
            Map<String, Object>[] mapArray = this.convertMessagesToMaps(refs);
            return mapArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listScheduledMessagesAsJSON() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.listScheduledMessagesAsJSON((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = QueueControlImpl.toJSON(this.listScheduledMessages());
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    private Map<String, Object>[] convertMessagesToMaps(List<MessageReference> refs) throws ActiveMQException {
        int attributeSizeLimit = this.addressSettingsRepository.getMatch(this.address).getManagementMessageAttributeSizeLimit();
        Map[] messages = new Map[refs.size()];
        int i = 0;
        for (MessageReference ref : refs) {
            Message message = ref.getMessage();
            messages[i++] = message.toMap(attributeSizeLimit);
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Object>[]> listDeliveringMessages() throws ActiveMQException {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.listDeliveringMessages((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            Map<String, List<MessageReference>> msgs = this.queue.getDeliveringMessages();
            HashMap<String, Map<String, Object>[]> msgRet = new HashMap<String, Map<String, Object>[]>();
            for (Map.Entry<String, List<MessageReference>> entry : msgs.entrySet()) {
                msgRet.put(entry.getKey(), this.convertMessagesToMaps(entry.getValue()));
            }
            HashMap<String, Map<String, Object>[]> hashMap = msgRet;
            return hashMap;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listDeliveringMessagesAsJSON() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.listDeliveringMessagesAsJSON((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = QueueControlImpl.toJSON(this.listDeliveringMessages());
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * Exception decompiling
     */
    public Map<String, Object>[] listMessages(String filterStr) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String listMessagesAsJSON(String filter) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.listMessagesAsJSON((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = QueueControlImpl.toJSON(this.listMessages(filter));
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * Loose catch block
     */
    protected Map<String, Object>[] getFirstMessage() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFirstMessage((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            ArrayList<Map> messages = new ArrayList<Map>();
            this.queue.flushExecutor();
            int attributeSizeLimit = this.addressSettingsRepository.getMatch(this.address).getManagementMessageAttributeSizeLimit();
            try (LinkedListIterator<MessageReference> iterator = this.queue.browserIterator();){
                if (iterator.hasNext()) {
                    MessageReference ref = (MessageReference)iterator.next();
                    Message message = ref.getMessage();
                    messages.add(message.toMap(attributeSizeLimit));
                }
                Map[] mapArray = messages.toArray(new Map[1]);
                return mapArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getFirstMessageAsJSON() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFirstMessageAsJSON((Object)this.queue);
        }
        return QueueControlImpl.toJSON(this.getFirstMessage());
    }

    public Long getFirstMessageTimestamp() throws Exception {
        Map<String, Object>[] _message;
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFirstMessageTimestamp((Object)this.queue);
        }
        if ((_message = this.getFirstMessage()) == null || _message.length == 0 || _message[0] == null) {
            return null;
        }
        Map<String, Object> message = _message[0];
        if (!message.containsKey("timestamp")) {
            return null;
        }
        return (Long)message.get("timestamp");
    }

    public Long getFirstMessageAge() throws Exception {
        Long firstMessageTimestamp;
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFirstMessageAge((Object)this.queue);
        }
        if ((firstMessageTimestamp = this.getFirstMessageTimestamp()) == null) {
            return null;
        }
        long now = new Date().getTime();
        return now - firstMessageTimestamp;
    }

    public long countMessages() throws Exception {
        return this.countMessages(null);
    }

    public long countMessages(String filterStr) throws Exception {
        Long value;
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.countMessages((Object)this.queue, (Object[])new Object[]{filterStr});
        }
        return (value = this.internalCountMessages(filterStr, null).get(null)) == null ? 0L : value;
    }

    public String countMessages(String filterStr, String groupByProperty) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.countMessages((Object)this.queue, (Object[])new Object[]{filterStr, groupByProperty});
        }
        return JsonUtil.toJsonObject(this.internalCountMessages(filterStr, groupByProperty)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> internalCountMessages(String filterStr, String groupByPropertyStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        HashMap<String, Long> result = new HashMap<String, Long>();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            SimpleString groupByProperty = SimpleString.toSimpleString((String)groupByPropertyStr);
            if (filter == null && groupByProperty == null) {
                result.put(null, this.getMessageCount());
            } else {
                int limit = this.addressSettingsRepository.getMatch(this.address).getManagementBrowsePageSize();
                int count = 0;
                try (LinkedListIterator<MessageReference> iterator = this.queue.browserIterator();){
                    try {
                        while (iterator.hasNext() && count++ < limit) {
                            Message message = ((MessageReference)iterator.next()).getMessage();
                            this.internalComputeMessage(result, filter, groupByProperty, message);
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
            }
            HashMap<String, Long> hashMap = result;
            return hashMap;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long countDeliveringMessages(String filterStr) throws Exception {
        Long value;
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.countDeliveringMessages((Object)this.queue, (Object[])new Object[]{filterStr});
        }
        return (value = this.internalCountDeliveryMessages(filterStr, null).get(null)) == null ? 0L : value;
    }

    public String countDeliveringMessages(String filterStr, String groupByProperty) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.countDeliveringMessages((Object)this.queue, (Object[])new Object[]{filterStr, groupByProperty});
        }
        return JsonUtil.toJsonObject(this.internalCountDeliveryMessages(filterStr, groupByProperty)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> internalCountDeliveryMessages(String filterStr, String groupByPropertyStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        HashMap<String, Long> result = new HashMap<String, Long>();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            SimpleString groupByProperty = SimpleString.toSimpleString((String)groupByPropertyStr);
            if (filter == null && groupByProperty == null) {
                result.put(null, Long.valueOf(this.getDeliveringCount()));
            } else {
                Map<String, List<MessageReference>> deliveringMessages = this.queue.getDeliveringMessages();
                deliveringMessages.forEach((s, messageReferenceList) -> messageReferenceList.forEach(messageReference -> this.internalComputeMessage(result, filter, groupByProperty, messageReference.getMessage())));
            }
            HashMap<String, Long> hashMap = result;
            return hashMap;
        }
        finally {
            this.blockOnIO();
        }
    }

    private void internalComputeMessage(Map<String, Long> result, Filter filter, SimpleString groupByProperty, Message message) {
        if (filter == null || filter.match(message)) {
            if (groupByProperty == null) {
                result.compute(null, (k, v) -> {
                    long l;
                    if (v == null) {
                        l = 1L;
                    } else {
                        v = v + 1L;
                        l = v;
                    }
                    return l;
                });
            } else {
                Object value = message.getObjectProperty(groupByProperty);
                String valueStr = value == null ? null : value.toString();
                result.compute(valueStr, (k, v) -> {
                    long l;
                    if (v == null) {
                        l = 1L;
                    } else {
                        v = v + 1L;
                        l = v;
                    }
                    return l;
                });
            }
        }
    }

    public boolean removeMessage(long messageID) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.removeMessage((Object)this.queue, (Object[])new Object[]{messageID});
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.deleteReference(messageID);
            return bl;
        }
        catch (ActiveMQException e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    public int removeMessages(String filterStr) throws Exception {
        return this.removeMessages(500, filterStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeMessages(int flushLimit, String filterStr) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.removeMessages((Object)this.queue, (Object[])new Object[]{flushLimit, filterStr});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            int removed = 0;
            try {
                removed = this.queue.deleteMatchingReferences(flushLimit, filter);
                if (AuditLogger.isResourceLoggingEnabled()) {
                    AuditLogger.removeMessagesSuccess((int)removed, (String)this.queue.getName().toString());
                }
            }
            catch (Exception e) {
                if (AuditLogger.isResourceLoggingEnabled()) {
                    AuditLogger.removeMessagesFailure((String)this.queue.getName().toString());
                }
                throw e;
            }
            int n = removed;
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int removeAllMessages() throws Exception {
        return this.removeMessages(500, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expireMessage(long messageID) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.expireMessage((Object)this.queue, (Object[])new Object[]{messageID});
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.expireReference(messageID);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int expireMessages(String filterStr) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.expireMessages((Object)this.queue, (Object[])new Object[]{filterStr});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.expireReferences(filter);
            return n;
        }
        catch (ActiveMQException e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retryMessage(final long messageID) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.retryMessage((Object)this.queue, (Object[])new Object[]{messageID});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Filter singleMessageFilter = new Filter(){

                @Override
                public boolean match(Message message) {
                    return message.getMessageID() == messageID;
                }

                @Override
                public boolean match(Map<String, String> map) {
                    return false;
                }

                @Override
                public boolean match(Filterable filterable) {
                    return false;
                }

                @Override
                public SimpleString getFilterString() {
                    return new SimpleString("custom filter for MESSAGEID= messageID");
                }
            };
            boolean bl = this.queue.retryMessages(singleMessageFilter) > 0;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int retryMessages() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.retryMessages((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.retryMessages(null);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean moveMessage(long messageID, String otherQueueName) throws Exception {
        return this.moveMessage(messageID, otherQueueName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveMessage(long messageID, String otherQueueName, boolean rejectDuplicates) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.moveMessage((Object)this.queue, (Object[])new Object[]{messageID, otherQueueName, rejectDuplicates});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Binding binding = this.server.getPostOffice().getBinding(new SimpleString(otherQueueName));
            if (binding == null) {
                throw ActiveMQMessageBundle.BUNDLE.noQueueFound(otherQueueName);
            }
            boolean bl = this.queue.moveReference(messageID, binding.getAddress(), binding, rejectDuplicates);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int moveMessages(String filterStr, String otherQueueName) throws Exception {
        return this.moveMessages(filterStr, otherQueueName, false);
    }

    public int moveMessages(int flushLimit, String filterStr, String otherQueueName, boolean rejectDuplicates) throws Exception {
        return this.moveMessages(flushLimit, filterStr, otherQueueName, rejectDuplicates, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveMessages(int flushLimit, String filterStr, String otherQueueName, boolean rejectDuplicates, int messageCount) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.moveMessages((Object)this.queue, (Object[])new Object[]{flushLimit, filterStr, otherQueueName, rejectDuplicates, messageCount});
        }
        this.checkStarted();
        this.clearIO();
        try {
            int retValue;
            Filter filter = FilterImpl.createFilter(filterStr);
            Binding binding = this.server.getPostOffice().getBinding(new SimpleString(otherQueueName));
            if (binding == null) {
                throw ActiveMQMessageBundle.BUNDLE.noQueueFound(otherQueueName);
            }
            int n = retValue = this.queue.moveReferences(flushLimit, filter, binding.getAddress(), rejectDuplicates, messageCount, binding);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int moveMessages(String filterStr, String otherQueueName, boolean rejectDuplicates) throws Exception {
        return this.moveMessages(500, filterStr, otherQueueName, rejectDuplicates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessagesToDeadLetterAddress(String filterStr) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.sendMessagesToDeadLetterAddress((Object)this.queue, (Object[])new Object[]{filterStr});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.sendMessagesToDeadLetterAddress(filter);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String sendMessage(Map<String, String> headers, int type, String body, boolean durable, String user, String password) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.sendMessageThroughManagement((Object)this.queue, (Object[])new Object[]{headers, type, body, durable, user, "****"});
        }
        try {
            String s = this.sendMessage(this.queue.getAddress(), this.server, headers, type, body, durable, user, password, this.queue.getID());
            if (AuditLogger.isResourceLoggingEnabled()) {
                AuditLogger.sendMessageSuccess((String)this.queue.getName().toString(), (String)user);
            }
            return s;
        }
        catch (Exception e) {
            if (AuditLogger.isResourceLoggingEnabled()) {
                AuditLogger.sendMessageFailure((String)this.queue.getName().toString(), (String)user);
            }
            throw new IllegalStateException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.sendMessageToDeadLetterAddress((Object)this.queue, (Object[])new Object[]{messageID});
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.sendMessageToDeadLetterAddress(messageID);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int changeMessagesPriority(String filterStr, int newPriority) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.changeMessagesPriority((Object)this.queue, (Object[])new Object[]{filterStr, newPriority});
        }
        this.checkStarted();
        this.clearIO();
        try {
            if (newPriority < 0 || newPriority > 9) {
                throw ActiveMQMessageBundle.BUNDLE.invalidNewPriority(newPriority);
            }
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.changeReferencesPriority(filter, (byte)newPriority);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeMessagePriority(long messageID, int newPriority) throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.changeMessagePriority((Object)this.queue, (Object[])new Object[]{messageID, newPriority});
        }
        this.checkStarted();
        this.clearIO();
        try {
            if (newPriority < 0 || newPriority > 9) {
                throw ActiveMQMessageBundle.BUNDLE.invalidNewPriority(newPriority);
            }
            boolean bl = this.queue.changeReferencePriority(messageID, (byte)newPriority);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listMessageCounter() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.listMessageCounter((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.counter.toJSon();
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resetMessageCounter() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.resetMessageCounter((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.counter.resetCounter();
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listMessageCounterAsHTML() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.listMessageCounterAsHTML((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterHelper.listMessageCounterAsHTML(new MessageCounter[]{this.counter});
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listMessageCounterHistory() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.listMessageCounterHistory((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterHelper.listMessageCounterHistory(this.counter);
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listMessageCounterHistoryAsHTML() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.listMessageCounterHistoryAsHTML((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterHelper.listMessageCounterHistoryAsHTML(new MessageCounter[]{this.counter});
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void pause() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.pause((Object)this.queue, (Object[])new Object[0]);
        }
        this.checkStarted();
        this.clearIO();
        try {
            try {
                this.queue.pause();
                if (AuditLogger.isResourceLoggingEnabled()) {
                    AuditLogger.pauseQueueSuccess((String)this.queue.getName().toString());
                }
            }
            catch (Exception e) {
                if (AuditLogger.isResourceLoggingEnabled()) {
                    AuditLogger.pauseQueueFailure((String)this.queue.getName().toString());
                }
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public void pause(boolean persist) {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.pause((Object)this.queue, (Object[])new Object[]{persist});
        }
        this.checkStarted();
        this.clearIO();
        try {
            try {
                this.queue.pause(persist);
                if (AuditLogger.isResourceLoggingEnabled()) {
                    AuditLogger.pauseQueueSuccess((String)this.queue.getName().toString());
                }
            }
            catch (Exception e) {
                if (AuditLogger.isResourceLoggingEnabled()) {
                    AuditLogger.pauseQueueFailure((String)this.queue.getName().toString());
                }
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resume() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.resume((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            try {
                this.queue.resume();
                if (AuditLogger.isResourceLoggingEnabled()) {
                    AuditLogger.resumeQueueSuccess((String)this.queue.getName().toString());
                }
            }
            catch (Exception e) {
                if (AuditLogger.isResourceLoggingEnabled()) {
                    AuditLogger.resumeQueueFailure((String)this.queue.getName().toString());
                }
                e.printStackTrace();
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isPaused() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isPaused((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isPaused();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public CompositeData[] browse(int page, int pageSize) throws Exception {
        return this.browse(page, pageSize, null);
    }

    /*
     * Exception decompiling
     */
    public CompositeData[] browse(int page, int pageSize, String filter) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CompositeData[] browse() throws Exception {
        return this.browse(null);
    }

    /*
     * Exception decompiling
     */
    public CompositeData[] browse(String filter) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void flushExecutor() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.flushExecutor((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.flushExecutor();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resetAllGroups() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.resetAllGroups((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.resetAllGroups();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resetGroup(String groupID) {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.resetGroup((Object)this.queue, (Object[])new Object[]{groupID});
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.resetGroup(SimpleString.toSimpleString((String)groupID));
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getGroupCount() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getGroupCount((Object)this.queue, (Object[])new Object[0]);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getGroupCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listGroupsAsJSON() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.listGroupsAsJSON((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            Map<SimpleString, Consumer> groups = this.queue.getGroups();
            JsonArrayBuilder jsonArray = JsonLoader.createArrayBuilder();
            for (Map.Entry<SimpleString, Consumer> group : groups.entrySet()) {
                if (!(group.getValue() instanceof ServerConsumer)) continue;
                ServerConsumer serverConsumer = (ServerConsumer)group.getValue();
                JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add("groupID", group.getKey().toString()).add("consumerID", serverConsumer.getID()).add("connectionID", serverConsumer.getConnectionID().toString()).add("sessionID", serverConsumer.getSessionID()).add("browseOnly", serverConsumer.isBrowseOnly()).add("creationTime", serverConsumer.getCreationTime());
                jsonArray.add(obj);
            }
            String string = jsonArray.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getRingSize() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRingSize((Object)this.queue, (Object[])new Object[0]);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getRingSize();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listConsumersAsJSON() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.listConsumersAsJSON((Object)this.queue, (Object[])new Object[0]);
        }
        this.checkStarted();
        this.clearIO();
        try {
            Collection<Consumer> consumers = this.queue.getConsumers();
            JsonArrayBuilder jsonArray = JsonLoader.createArrayBuilder();
            for (Consumer consumer : consumers) {
                if (!(consumer instanceof ServerConsumer)) continue;
                ServerConsumer serverConsumer = (ServerConsumer)consumer;
                JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add("consumerID", serverConsumer.getID()).add("connectionID", serverConsumer.getConnectionID().toString()).add("sessionID", serverConsumer.getSessionID()).add("browseOnly", serverConsumer.isBrowseOnly()).add("creationTime", serverConsumer.getCreationTime());
                jsonArray.add(obj);
            }
            String string = jsonArray.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(QueueControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(QueueControl.class);
    }

    public void resetMessagesAdded() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.resetMessagesAdded((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.resetMessagesAdded();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resetMessagesAcknowledged() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.resetMessagesAcknowledged((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.resetMessagesAcknowledged();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resetMessagesExpired() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.resetMessagesExpired((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.resetMessagesExpired();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resetMessagesKilled() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.resetMessagesKilled((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.resetMessagesKilled();
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isGroupRebalance() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isGroupRebalance((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isGroupRebalance();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isGroupRebalancePauseDispatch() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isGroupRebalancePauseDispatch((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isGroupRebalancePauseDispatch();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getGroupBuckets() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getGroupBuckets((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getGroupBuckets();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getGroupFirstKey() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getGroupFirstKey((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            SimpleString groupFirstKey = this.queue.getGroupFirstKey();
            String string = groupFirstKey != null ? groupFirstKey.toString() : null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreparedTransactionMessageCount() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getPreparedTransactionMessageCount((Object)this.queue);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int count = 0;
            ResourceManager resourceManager = this.server.getResourceManager();
            if (resourceManager != null) {
                List<Xid> preparedTransactions = resourceManager.getPreparedTransactions();
                for (Xid preparedTransaction : preparedTransactions) {
                    Transaction transaction = resourceManager.getTransaction(preparedTransaction);
                    if (transaction == null) continue;
                    List<TransactionOperation> allOperations = transaction.getAllOperations();
                    for (TransactionOperation operation : allOperations) {
                        if (!(operation instanceof RefsOperation)) continue;
                        RefsOperation refsOperation = (RefsOperation)operation;
                        List<MessageReference> references = refsOperation.getReferencesToAcknowledge();
                        for (MessageReference reference : references) {
                            if (reference == null || !reference.getQueue().getName().equals((Object)this.queue.getName())) continue;
                            ++count;
                        }
                    }
                }
            }
            int n = count;
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    private void checkStarted() {
        if (!this.server.getPostOffice().isStarted()) {
            throw new IllegalStateException("Broker is not started. Queue can not be managed yet");
        }
    }
}

