/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.Reader;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.SqlException;

class ClobLocatorReader
extends Reader {
    private final ClientConnection connection;
    private final ClientClob clob;
    private long currentPos;
    private final long maxPos;
    private boolean isClosed = false;

    ClobLocatorReader(ClientConnection clientConnection, ClientClob clientClob) throws SqlException {
        this.connection = clientConnection;
        this.clob = clientClob;
        this.currentPos = 1L;
        this.maxPos = -1L;
    }

    ClobLocatorReader(ClientConnection clientConnection, ClientClob clientClob, long l, long l2) throws SqlException {
        this.connection = clientConnection;
        this.clob = clientClob;
        this.currentPos = l;
        this.maxPos = l2 != -1L ? Math.min(clientClob.sqlLength(), l + l2 - 1L) : -1L;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        char[] cArray = this.readCharacters(1);
        if (cArray.length == 0) {
            return -1;
        }
        return cArray[0];
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (n2 == 0) {
            return 0;
        }
        if (n < 0 || n2 < 0 || n2 > cArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray2 = this.readCharacters(n2);
        if (cArray2.length == 0) {
            return -1;
        }
        System.arraycopy(cArray2, 0, cArray, n, cArray2.length);
        return cArray2.length;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("This operation is not permitted because theReader has been closed");
        }
    }

    private char[] readCharacters(int n) throws IOException {
        try {
            int n2 = -1;
            n2 = this.maxPos != -1L ? (int)Math.min((long)n, this.maxPos - this.currentPos + 1L) : (int)Math.min((long)n, this.clob.sqlLength() - this.currentPos + 1L);
            String string = this.connection.locatorProcedureCall().clobGetSubString(this.clob.getLocator(), this.currentPos, n2);
            char[] cArray = string.toCharArray();
            this.currentPos += (long)cArray.length;
            return cArray;
        }
        catch (SqlException sqlException) {
            throw new IOException(sqlException);
        }
    }
}

