/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.cloud.config.server.support.AwsCodeCommitCredentialProvider;
import org.springframework.cloud.config.server.support.GitSkipSslValidationCredentialsProvider;
import org.springframework.cloud.config.server.support.PassphraseCredentialsProvider;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class GitCredentialsProviderFactory {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected boolean awsCodeCommitEnabled = true;

    @Deprecated
    public CredentialsProvider createFor(String uri, String username, String password, String passphrase) {
        return this.createFor(uri, username, password, passphrase, false);
    }

    public CredentialsProvider createFor(String uri, String username, String password, String passphrase, boolean skipSslValidation) {
        Object provider = null;
        if (this.awsAvailable() && AwsCodeCommitCredentialProvider.canHandle(uri)) {
            this.logger.debug((Object)("Constructing AwsCodeCommitCredentialProvider for URI " + uri));
            AwsCodeCommitCredentialProvider aws = new AwsCodeCommitCredentialProvider();
            aws.setUsername(username);
            aws.setPassword(password);
            provider = aws;
        } else if (StringUtils.hasText((String)username)) {
            this.logger.debug((Object)("Constructing UsernamePasswordCredentialsProvider for URI " + uri));
            provider = new UsernamePasswordCredentialsProvider(username, password.toCharArray());
        } else if (StringUtils.hasText((String)passphrase)) {
            this.logger.debug((Object)("Constructing PassphraseCredentialsProvider for URI " + uri));
            provider = new PassphraseCredentialsProvider(passphrase);
        }
        if (skipSslValidation && GitSkipSslValidationCredentialsProvider.canHandle(uri)) {
            this.logger.debug((Object)("Constructing GitSkipSslValidationCredentialsProvider for URI " + uri));
            provider = new GitSkipSslValidationCredentialsProvider((CredentialsProvider)provider);
        }
        if (provider == null) {
            this.logger.debug((Object)("No credentials provider required for URI " + uri));
        }
        return provider;
    }

    private boolean awsAvailable() {
        return this.awsCodeCommitEnabled && ClassUtils.isPresent((String)"com.amazonaws.auth.DefaultAWSCredentialsProviderChain", null);
    }

    public boolean isAwsCodeCommitEnabled() {
        return this.awsCodeCommitEnabled;
    }

    public void setAwsCodeCommitEnabled(boolean awsCodeCommitEnabled) {
        this.awsCodeCommitEnabled = awsCodeCommitEnabled;
    }
}

